/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.cache;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.cache.CacheEntryParcel;
import com.google.android.gms.ads.internal.cache.CacheOffering;
import com.google.android.gms.ads.internal.cache.zzc;
import com.google.android.gms.ads.internal.cache.zzf;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.internal.zzct;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkr;

@zziy
public class zza {
    private final Runnable zzavq = new Runnable(){

        @Override
        public void run() {
            zza.this.disconnect();
        }
    };
    private final Object zzakd = new Object();
    @Nullable
    private zzc zzavr;
    @Nullable
    private Context mContext;
    @Nullable
    private zzf zzavs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Context context) {
        if (context == null) {
            return;
        }
        Object object = this.zzakd;
        synchronized (object) {
            if (this.mContext != null) {
                return;
            }
            this.mContext = context.getApplicationContext();
            if (zzdi.zzbhl.get().booleanValue()) {
                this.connect();
            } else if (zzdi.zzbhk.get().booleanValue()) {
                this.zza(new zzct.zzb(){

                    @Override
                    public void zzk(boolean bl) {
                        if (bl) {
                            zza.this.connect();
                        } else {
                            zza.this.disconnect();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzit() {
        if (zzdi.zzbhm.get().booleanValue()) {
            Object object = this.zzakd;
            synchronized (object) {
                this.connect();
                zzu.zzfz();
                zzkr.zzcrf.removeCallbacks(this.zzavq);
                zzu.zzfz();
                zzkr.zzcrf.postDelayed(this.zzavq, zzdi.zzbhn.get().longValue());
            }
        }
    }

    protected void zza(zzct.zzb zzb2) {
        zzu.zzgc().zza(zzb2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntryParcel zza(CacheOffering cacheOffering) {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzavs == null) {
                return new CacheEntryParcel();
            }
            try {
                return this.zzavs.zza(cacheOffering);
            }
            catch (RemoteException remoteException) {
                zzkn.zzb((String)"Unable to call into cache service.", (Throwable)remoteException);
                return new CacheEntryParcel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.mContext == null || this.zzavr != null) {
                return;
            }
            zze.zzb zzb2 = new zze.zzb(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onConnected(@Nullable Bundle bundle) {
                    Object object = zza.this.zzakd;
                    synchronized (object) {
                        try {
                            zza.this.zzavs = zza.this.zzavr.zziz();
                        }
                        catch (DeadObjectException deadObjectException) {
                            zzkn.zzb((String)"Unable to obtain a cache service instance.", (Throwable)deadObjectException);
                            zza.this.disconnect();
                        }
                        zza.this.zzakd.notifyAll();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onConnectionSuspended(int n2) {
                    Object object = zza.this.zzakd;
                    synchronized (object) {
                        zza.this.zzavr = null;
                        zza.this.zzavs = null;
                        zza.this.zzakd.notifyAll();
                        zzu.zzgp().zzuz();
                    }
                }
            };
            zze.zzc zzc2 = new zze.zzc(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
                    Object object = zza.this.zzakd;
                    synchronized (object) {
                        zza.this.zzavr = null;
                        zza.this.zzavs = null;
                        zza.this.zzakd.notifyAll();
                        zzu.zzgp().zzuz();
                    }
                }
            };
            this.zzavr = this.zza(zzb2, zzc2);
            this.zzavr.zzatu();
        }
    }

    protected zzc zza(zze.zzb zzb2, zze.zzc zzc2) {
        return new zzc(this.mContext, zzu.zzgp().zzuy(), zzb2, zzc2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzavr == null) {
                return;
            }
            if (this.zzavr.isConnected() || this.zzavr.isConnecting()) {
                this.zzavr.disconnect();
            }
            this.zzavr = null;
            this.zzavs = null;
            Binder.flushPendingCommands();
            zzu.zzgp().zzuz();
        }
    }
}

