/*
 * Decompiled with CFR 0.152.
 */
package android.support.multidex;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import java.util.zip.ZipException;

final class ZipUtil {
    private static final int ENDHDR = 22;
    private static final int ENDSIG = 101010256;
    private static final int BUFFER_SIZE = 16384;

    ZipUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getZipCrc(File apk) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(apk, "r");
        try {
            CentralDirectory dir = ZipUtil.findCentralDirectory(raf);
            long l2 = ZipUtil.computeCrcOfCentralDir(raf, dir);
            return l2;
        }
        finally {
            raf.close();
        }
    }

    static CentralDirectory findCentralDirectory(RandomAccessFile raf) throws IOException, ZipException {
        block3: {
            long scanOffset = raf.length() - 22L;
            if (scanOffset < 0L) {
                throw new ZipException("File too short to be a zip file: " + raf.length());
            }
            long stopOffset = scanOffset - 65536L;
            if (stopOffset < 0L) {
                stopOffset = 0L;
            }
            int endSig = Integer.reverseBytes(101010256);
            do {
                raf.seek(scanOffset);
                if (raf.readInt() == endSig) break block3;
            } while (--scanOffset >= stopOffset);
            throw new ZipException("End Of Central Directory signature not found");
        }
        raf.skipBytes(2);
        raf.skipBytes(2);
        raf.skipBytes(2);
        raf.skipBytes(2);
        CentralDirectory dir = new CentralDirectory();
        dir.size = (long)Integer.reverseBytes(raf.readInt()) & 0xFFFFFFFFL;
        dir.offset = (long)Integer.reverseBytes(raf.readInt()) & 0xFFFFFFFFL;
        return dir;
    }

    static long computeCrcOfCentralDir(RandomAccessFile raf, CentralDirectory dir) throws IOException {
        CRC32 crc = new CRC32();
        long stillToRead = dir.size;
        raf.seek(dir.offset);
        int length = (int)Math.min(16384L, stillToRead);
        byte[] buffer = new byte[16384];
        length = raf.read(buffer, 0, length);
        while (length != -1) {
            crc.update(buffer, 0, length);
            if ((stillToRead -= (long)length) == 0L) break;
            length = (int)Math.min(16384L, stillToRead);
            length = raf.read(buffer, 0, length);
        }
        return crc.getValue();
    }

    static class CentralDirectory {
        long offset;
        long size;

        CentralDirectory() {
        }
    }
}

