/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.mraid;

import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.loopme.common.Logging;
import com.loopme.common.Utils;
import com.loopme.debugging.ErrorLog;
import com.loopme.mraid.MraidView;
import java.net.URI;
import java.net.URISyntaxException;

public class MraidBridge
extends WebViewClient {
    private static final String LOG_TAG = MraidBridge.class.getSimpleName();
    private static final String LOOPME_SCHEME = "loopme";
    private static final String MRAID_SCHEME = "mraid";
    private static final String CUSTOM_HTTP_SCHEME = "http";
    private static final String QUERY_PARAMETER_URI = "uri";
    private static final String QUERY_PARAMETER_URL = "url";
    private static final String QUERY_PARAMETER_WIDTH = "width";
    private static final String QUERY_PARAMETER_HEIGHT = "height";
    private static final String QUERY_PARAMETER_OFFSET_X = "offsetX";
    private static final String QUERY_PARAMETER_OFFSET_Y = "offsetY";
    private static final String QUERY_PARAMETER_CUSTOM_CLOSE = "shouldUseCustomClose";
    private static final String QUERY_PARAMETER_CUSTOM_CLOSE_POSITION = "customClosePosition";
    private static final String ALLOW_OFF_SCREEN = "allowOffscreen";
    private static final String CLOSE = "close";
    private static final String OPEN = "open";
    private static final String PLAY_VIDEO = "playVideo";
    private static final String RESIZE = "resize";
    private static final String EXPAND = "expand";
    private static final String USE_CUSTOM_CLOSE = "usecustomclose";
    private OnMraidBridgeListener mOnMraidBridgeListener;

    public MraidBridge(OnMraidBridgeListener onMraidBridgeListener) {
        this.mOnMraidBridgeListener = onMraidBridgeListener;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.notifyError((View)view, "Broken redirect in mraid: " + url);
            return false;
        }
        try {
            URI redirect = new URI(url);
            String protocol = redirect.getScheme();
            if (TextUtils.isEmpty((CharSequence)protocol)) {
                return false;
            }
            if (protocol.equalsIgnoreCase(MRAID_SCHEME) || protocol.equalsIgnoreCase(LOOPME_SCHEME)) {
                String host = redirect.getHost();
                this.handleMraidCommand(host, url);
                return true;
            }
            if (TextUtils.equals((CharSequence)protocol, (CharSequence)CUSTOM_HTTP_SCHEME)) {
                this.mOnMraidBridgeListener.open(url);
                return true;
            }
        }
        catch (URISyntaxException e2) {
            this.notifyError((View)view, "Broken redirect in bridge: " + url);
            return false;
        }
        return false;
    }

    private void notifyError(View view, String errorMessage) {
        ErrorLog.post(errorMessage);
        ((MraidView)view).notifyError();
        Logging.out(LOG_TAG, errorMessage);
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        ((MraidView)view).notifyError();
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        ((MraidView)view).setState("default");
        ((MraidView)view).notifyReady();
        this.mOnMraidBridgeListener.onLoadSuccess();
    }

    private void handleMraidCommand(String command, String url) {
        Uri uri = Uri.parse((String)url);
        switch (command) {
            case "usecustomclose": {
                boolean hasOwnCloseButton = this.detectBooleanQueryParameter(uri, QUERY_PARAMETER_CUSTOM_CLOSE);
                this.mOnMraidBridgeListener.onChangeCloseButtonVisibility(hasOwnCloseButton);
                break;
            }
            case "expand": {
                boolean custom = this.detectBooleanQueryParameter(uri, QUERY_PARAMETER_CUSTOM_CLOSE);
                this.mOnMraidBridgeListener.expand(custom);
                break;
            }
            case "resize": {
                String width = this.detectQueryParameter(uri, QUERY_PARAMETER_WIDTH);
                int w2 = Integer.parseInt(width);
                String height = this.detectQueryParameter(uri, QUERY_PARAMETER_HEIGHT);
                int h2 = Integer.parseInt(height);
                String offsetX = this.detectQueryParameter(uri, QUERY_PARAMETER_OFFSET_X);
                String offsetY = this.detectQueryParameter(uri, QUERY_PARAMETER_OFFSET_Y);
                String customClosePosition = this.detectQueryParameter(uri, QUERY_PARAMETER_CUSTOM_CLOSE_POSITION);
                String allowOffscreen = this.detectQueryParameter(uri, ALLOW_OFF_SCREEN);
                this.mOnMraidBridgeListener.resize(Utils.convertDpToPixel(w2), Utils.convertDpToPixel(h2));
                break;
            }
            case "close": {
                this.mOnMraidBridgeListener.close();
                break;
            }
            case "open": {
                String openUrl = this.detectQueryParameter(uri, QUERY_PARAMETER_URL);
                Logging.out(LOG_TAG, String.valueOf(openUrl));
                this.mOnMraidBridgeListener.open(openUrl);
                break;
            }
            case "playVideo": {
                String videoUrl = this.detectQueryParameter(uri, QUERY_PARAMETER_URI);
                Logging.out(LOG_TAG, String.valueOf(videoUrl));
                this.mOnMraidBridgeListener.playVideo(videoUrl);
                break;
            }
        }
    }

    private String detectQueryParameter(Uri uri, String parameter) {
        String result = null;
        try {
            result = uri.getQueryParameter(parameter);
        }
        catch (NullPointerException | UnsupportedOperationException e2) {
            e2.printStackTrace();
        }
        return result;
    }

    private boolean detectBooleanQueryParameter(Uri uri, String parameter) {
        String result = this.detectQueryParameter(uri, parameter);
        return Boolean.parseBoolean(result);
    }

    public static interface OnMraidBridgeListener {
        public void close();

        public void open(String var1);

        public void resize(int var1, int var2);

        public void playVideo(String var1);

        public void expand(boolean var1);

        public void onLoadSuccess();

        public void onChangeCloseButtonVisibility(boolean var1);
    }
}

