/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.Surface;
import com.loopme.adview.AdView;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.Utils;
import com.loopme.debugging.ErrorLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class VideoController
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnCompletionListener {
    private static final String LOG_TAG = VideoController.class.getSimpleName();
    private static final int BUFFERING_MILLIS_IN_FUTURE = 2000;
    private static final int BUFFERING_COUNTDOWN_INTERVAL = 1000;
    private final long DELAY_TIME = 200L;
    private volatile MediaPlayer mMediaPlayer;
    private int mVideoDuration;
    private int mVideoPositionWhenError;
    private boolean mMuteState = false;
    private boolean mWasError;
    private boolean mIsSurfaceTextureAvailable;
    private boolean mWaitForVideo;
    private Handler mHandler;
    private Runnable mRunnable;
    private AdView mAdView;
    private Context mContext;
    private String mFileRest;
    private Callback mCallback;
    private Surface mSurface;
    private CountDownTimer mBufferingTimer;
    private String mAppKey;
    private int mFormat = 1001;
    private int mQuarter25;
    private int mQuarter50;
    private int mQuarter75;
    private boolean mIs360;
    private OnMoatEventListener mOnMoatEventListener;
    private Map<String, Integer> mQuartileEventsMap;
    private int mCurrentPosition;
    private boolean mIsFirstLaunch = true;

    public void resumeVideo() {
        if (this.mAdView.getCurrentVideoState() == 3) {
            this.playVideo(this.mCurrentPosition, this.mIs360);
        }
    }

    public VideoController(AdView adView, Callback callback, String appKey, int format, OnMoatEventListener onMoatEventListener) {
        this.mAdView = adView;
        this.mCallback = callback;
        this.mContext = adView.getContext();
        this.mAppKey = appKey;
        this.mFormat = format;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mOnMoatEventListener = onMoatEventListener;
        this.initProgressRunnable();
        this.mQuartileEventsMap = new HashMap<String, Integer>();
    }

    void contain360(boolean b2) {
        this.mIs360 = b2;
    }

    public void destroy() {
        Logging.out(LOG_TAG, "destroy");
        this.onStopMoatTracking();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
        }
        this.stopBuffering();
        this.mRunnable = null;
        this.releasePlayer();
        this.mCallback = null;
        this.mSurface = null;
    }

    private void initProgressRunnable() {
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                if (VideoController.this.mAdView == null) {
                    return;
                }
                VideoController.this.mCurrentPosition = VideoController.this.getCurrentPosition();
                VideoController.this.mAdView.setVideoCurrentTime(VideoController.this.mCurrentPosition);
                VideoController.this.updateCurrentVolume();
                if (VideoController.this.mCurrentPosition < VideoController.this.mVideoDuration) {
                    VideoController.this.mHandler.postDelayed(VideoController.this.mRunnable, 200L);
                }
            }
        };
    }

    private int roundNumberToHundredth(int number) {
        return number / 100 * 100;
    }

    public int getCurrentPosition() {
        return this.mMediaPlayer == null ? 0 : this.mMediaPlayer.getCurrentPosition();
    }

    public void releasePlayer() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
        }
    }

    public void setSurface(Surface surface) throws IllegalStateException {
        Logging.out(LOG_TAG, "setSurface " + surface);
        this.mSurface = surface;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setSurface(surface);
        }
    }

    public void waitForVideo() {
        if (this.mWaitForVideo) {
            this.releasePlayer();
            this.initPlayer(this.mFileRest);
            this.setSurface(this.mSurface);
            if (this.mAdView.getCurrentWebViewState() == 1) {
                this.startMediaPlayer();
            }
            this.seekTo(this.mVideoPositionWhenError);
            Logging.out(LOG_TAG, "waitForVideo mHandler.postDelayed");
            this.mHandler.postDelayed(this.mRunnable, 200L);
            this.setVideoState(2);
        }
    }

    public void seekTo(int position) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.seekTo(position);
        }
    }

    public void initPlayerFromFile(String filePath) {
        this.mMediaPlayer = new MediaPlayer();
        this.initPlayerListeners();
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        try {
            this.mMediaPlayer.setDataSource(filePath);
            this.mMediaPlayer.prepareAsync();
        }
        catch (IOException | IllegalStateException e2) {
            Logging.out(LOG_TAG, e2.getMessage());
            this.setVideoState(5);
        }
    }

    private void initPlayer(String filePath) {
        this.mMediaPlayer = MediaPlayer.create((Context)this.mContext, (Uri)Uri.parse((String)filePath));
        this.initPlayerListeners();
    }

    private void initPlayerListeners() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setLooping(false);
            this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.mMediaPlayer.setAudioStreamType(3);
        }
    }

    public void muteVideo(boolean mute) {
        if (this.mMediaPlayer != null) {
            if (mute) {
                this.mMediaPlayer.setVolume(0.0f, 0.0f);
                this.onVolumeChangedMoatTracking();
            } else {
                float systemVolume = Utils.getSystemVolume();
                this.mMediaPlayer.setVolume(systemVolume, systemVolume);
            }
        }
        this.mMuteState = mute;
    }

    private void applyMuteSettings() {
        if (this.mMediaPlayer != null) {
            Logging.out(LOG_TAG, "applyMuteSettings " + this.mMuteState);
            this.muteVideo(this.mMuteState);
        }
    }

    private void updateCurrentVolume() {
        if (!this.mMuteState && this.mMediaPlayer != null) {
            float systemVolume = Utils.getSystemVolume();
            this.mMediaPlayer.setVolume(systemVolume, systemVolume);
        }
    }

    public void setSurfaceTextureAvailable(boolean isAvailable) {
        this.mIsSurfaceTextureAvailable = isAvailable;
    }

    private boolean isPlayerReadyForPlay() {
        return this.mMediaPlayer != null && this.mAdView != null && !this.mWasError;
    }

    public void playVideo(int time, boolean is360) {
        if (this.isPlayerReadyForPlay()) {
            if (this.mIsFirstLaunch && this.mFormat == 1000) {
                this.onStartMoatTracking(this.mMediaPlayer, this.mAdView);
                this.mIsFirstLaunch = false;
            }
            if (!is360 && !this.mIsSurfaceTextureAvailable) {
                Logging.out(LOG_TAG, "postpone play (surface not available)");
                if (this.mCallback != null) {
                    this.mCallback.onPostponePlay(time);
                }
                return;
            }
            try {
                if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
                    return;
                }
                Logging.out(LOG_TAG, "Play video " + time);
                this.applyMuteSettings();
                if (time == 10) {
                    this.mMediaPlayer.seekTo(0);
                }
                this.startMediaPlayer();
                this.mAdView.setVideoState(2);
                this.mHandler.postDelayed(this.mRunnable, 200L);
            }
            catch (IllegalStateException e2) {
                Logging.out(LOG_TAG, "playVideo:" + e2.getMessage());
            }
        }
    }

    public void pauseVideo() {
        if (this.mMediaPlayer != null && this.mAdView != null && !this.mWasError) {
            try {
                if (this.mMediaPlayer.isPlaying()) {
                    Logging.out(LOG_TAG, "Pause video");
                    this.mHandler.removeCallbacks(this.mRunnable);
                    this.mMediaPlayer.pause();
                    this.mAdView.setVideoState(3);
                } else {
                    this.mAdView.setVideoState(0);
                }
            }
            catch (IllegalStateException e2) {
                e2.printStackTrace();
                Logging.out(LOG_TAG, e2.getMessage());
            }
        }
    }

    public void setFileRest(String filePath) {
        this.mFileRest = filePath;
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.mAdView.getCurrentVideoState() != 4) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.mAdView.setVideoCurrentTime(this.mVideoDuration);
            this.mAdView.setVideoState(4);
            this.onVideoReachEnd();
            this.onStopMoatTracking();
            this.onCompletionMoatTracking();
        }
    }

    private void onVideoReachEnd() {
        if (this.mCallback != null) {
            this.mCallback.onVideoReachEnd();
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        Logging.out(LOG_TAG, "onError: " + extra);
        this.mHandler.removeCallbacks(this.mRunnable);
        this.destroyListeners();
        if (extra == -1004) {
            Logging.out(LOG_TAG, "end of preview file");
            if (!TextUtils.isEmpty((CharSequence)this.mFileRest)) {
                this.mVideoPositionWhenError = mp.getCurrentPosition();
                this.releasePlayer();
                this.initPlayer(this.mFileRest);
                this.setSurface(this.mSurface);
                this.startMediaPlayer();
                this.mMediaPlayer.seekTo(this.mVideoPositionWhenError);
                this.mHandler.postDelayed(this.mRunnable, 200L);
            } else {
                this.mWaitForVideo = true;
                this.mVideoPositionWhenError = mp.getCurrentPosition();
                this.setVideoState(6);
                this.startBuffering();
            }
            return true;
        }
        if (this.mAdView.getCurrentVideoState() == 5 || this.mAdView.getCurrentVideoState() == 0) {
            this.onFail();
        } else {
            this.mAdView.setWebViewState(2);
            this.mAdView.setVideoState(3);
            this.onPlaybackFinishedWithError();
            this.resetMediaPlayer();
            this.mWasError = true;
        }
        return true;
    }

    private void startMediaPlayer() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.start();
            if (this.mFormat == 1001) {
                this.onStartMoatTracking(this.mMediaPlayer, this.mAdView);
            }
        }
    }

    private void destroyListeners() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setOnErrorListener(null);
            this.mMediaPlayer.setOnCompletionListener(null);
        }
    }

    private void resetMediaPlayer() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
        }
    }

    private void onPlaybackFinishedWithError() {
        if (this.mCallback != null) {
            this.mCallback.onPlaybackFinishedWithError();
        }
    }

    private void startBuffering() {
        this.mBufferingTimer = new CountDownTimer(2000L, 1000L){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                ErrorLog.post("Buffering 2 seconds");
            }
        };
        this.mBufferingTimer.start();
    }

    private void onFail() {
        if (this.mCallback != null) {
            this.mCallback.onFail(new LoopMeError("Error during video loading"));
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        this.setVideoState(1);
        this.extractVideoInfo(mediaPlayer);
        this.stopBuffering();
    }

    private void stopBuffering() {
        if (this.mBufferingTimer != null) {
            this.mBufferingTimer.cancel();
        }
    }

    private void setVideoState(int state) {
        if (this.mAdView != null) {
            this.mAdView.setVideoState(state);
        }
    }

    private void extractVideoInfo(MediaPlayer mediaPlayer) {
        if (mediaPlayer != null) {
            if (this.mCallback != null) {
                this.mCallback.onVideoSizeChanged(mediaPlayer.getVideoWidth(), mediaPlayer.getVideoHeight());
            }
            this.mVideoDuration = mediaPlayer.getDuration();
            if (this.mAdView != null) {
                this.mAdView.setVideoDuration(this.mVideoDuration);
            }
        }
        this.mQuarter25 = this.roundNumberToHundredth(this.mVideoDuration / 4);
        this.mQuarter50 = this.roundNumberToHundredth(this.mVideoDuration / 2);
        this.mQuarter75 = this.mQuarter25 + this.mQuarter50;
        this.fillQuartileEventsList();
    }

    private void fillQuartileEventsList() {
        this.mQuartileEventsMap.clear();
        this.mQuartileEventsMap.put("VIDEO_25", this.mQuarter25);
        this.mQuartileEventsMap.put("VIDEO_50", this.mQuarter50);
        this.mQuartileEventsMap.put("VIDEO_75", this.mQuarter75);
    }

    public void onStartMoatTracking(MediaPlayer mediaPlayer, AdView adView) {
        if (this.mOnMoatEventListener != null) {
            this.mOnMoatEventListener.initMoatNativeTracker();
            this.mOnMoatEventListener.onChangeViewMoatTracking(this.mAdView);
            this.mOnMoatEventListener.onStartMoatTracking(mediaPlayer, adView);
        }
    }

    public void onStopMoatTracking() {
        if (this.mOnMoatEventListener != null) {
            this.mOnMoatEventListener.onStopMoatTracking();
        }
    }

    public void onVolumeChangedMoatTracking() {
        if (this.mOnMoatEventListener != null) {
            this.mOnMoatEventListener.onVolumeChangedMoatTracking(this.mMediaPlayer.getCurrentPosition(), Utils.getSystemVolume());
        }
    }

    public void onCompletionMoatTracking() {
        if (this.mOnMoatEventListener != null) {
            this.mOnMoatEventListener.onCompletionMoatTracking(this.mMediaPlayer);
        }
    }

    private void onPreparedMoatTracking(MediaPlayer mediaPlayer) {
        if (this.mOnMoatEventListener != null) {
            this.mOnMoatEventListener.onPreparedMoatTracking(mediaPlayer, this.mAdView);
        }
    }

    public static interface OnMoatEventListener {
        public void onStartMoatTracking(MediaPlayer var1, AdView var2);

        public void onStopMoatTracking();

        public void onChangeViewMoatTracking(AdView var1);

        public void onPreparedMoatTracking(MediaPlayer var1, AdView var2);

        public void onCompletionMoatTracking(MediaPlayer var1);

        public void onVolumeChangedMoatTracking(int var1, double var2);

        public void initMoatNativeTracker();
    }

    public static interface Callback {
        public void onVideoReachEnd();

        public void onFail(LoopMeError var1);

        public void onVideoSizeChanged(int var1, int var2);

        public void onPostponePlay(int var1);

        public void onPlaybackFinishedWithError();
    }
}

