/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzdw;
import com.google.android.gms.internal.zziy;
import java.util.Locale;

@zziy
public final class zzjh {
    public final int zzclr;
    public final boolean zzcls;
    public final boolean zzclt;
    public final String zzclu;
    public final String zzclv;
    public final boolean zzclw;
    public final boolean zzclx;
    public final boolean zzcly;
    public final boolean zzclz;
    public final String zzcma;
    public final String zzcmb;
    public final int zzcmc;
    public final int zzcmd;
    public final int zzcme;
    public final int zzcmf;
    public final int zzcmg;
    public final int zzcmh;
    public final float zzcgg;
    public final int zzcge;
    public final int zzcgf;
    public final double zzcmi;
    public final boolean zzcmj;
    public final boolean zzcmk;
    public final int zzcml;
    public final String zzcmm;
    public final boolean zzcmn;

    zzjh(int n2, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n3, int n4, int n5, int n6, int n7, int n8, float f2, int n9, int n10, double d2, boolean bl7, boolean bl8, int n11, String string6, boolean bl9) {
        this.zzclr = n2;
        this.zzcls = bl;
        this.zzclt = bl2;
        this.zzclu = string2;
        this.zzclv = string3;
        this.zzclw = bl3;
        this.zzclx = bl4;
        this.zzcly = bl5;
        this.zzclz = bl6;
        this.zzcma = string4;
        this.zzcmb = string5;
        this.zzcmc = n3;
        this.zzcmd = n4;
        this.zzcme = n5;
        this.zzcmf = n6;
        this.zzcmg = n7;
        this.zzcmh = n8;
        this.zzcgg = f2;
        this.zzcge = n9;
        this.zzcgf = n10;
        this.zzcmi = d2;
        this.zzcmj = bl7;
        this.zzcmk = bl8;
        this.zzcml = n11;
        this.zzcmm = string6;
        this.zzcmn = bl9;
    }

    public static final class zza {
        private int zzclr;
        private boolean zzcly;
        private boolean zzclz;
        private int zzcmc;
        private int zzcmg;
        private int zzcmh;
        private String zzclu;
        private int zzcmd;
        private int zzcme;
        private int zzcmf;
        private boolean zzcmk;
        private int zzcml;
        private double zzcmi;
        private boolean zzcmj;
        private String zzcmm;
        private boolean zzcls;
        private boolean zzclt;
        private String zzclv;
        private boolean zzclw;
        private boolean zzclx;
        private String zzcma;
        private String zzcmb;
        private float zzcgg;
        private int zzcge;
        private int zzcgf;
        private boolean zzcmn;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzv(context);
            this.zza(context, packageManager);
            this.zzw(context);
            Locale locale = Locale.getDefault();
            this.zzcls = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzclt = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzclv = locale.getCountry();
            this.zzclw = zzm.zzjr().zzve();
            this.zzclx = zzi.zzcm((Context)context);
            this.zzcma = locale.getLanguage();
            this.zzcmb = zza.zza(packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzcgg = displayMetrics.density;
            this.zzcge = displayMetrics.widthPixels;
            this.zzcgf = displayMetrics.heightPixels;
        }

        public zza(Context context, zzjh zzjh2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzv(context);
            this.zza(context, packageManager);
            this.zzw(context);
            this.zzx(context);
            this.zzcls = zzjh2.zzcls;
            this.zzclt = zzjh2.zzclt;
            this.zzclv = zzjh2.zzclv;
            this.zzclw = zzjh2.zzclw;
            this.zzclx = zzjh2.zzclx;
            this.zzcma = zzjh2.zzcma;
            this.zzcmb = zzjh2.zzcmb;
            this.zzcgg = zzjh2.zzcgg;
            this.zzcge = zzjh2.zzcge;
            this.zzcgf = zzjh2.zzcgf;
        }

        private void zzv(Context context) {
            AudioManager audioManager = zzu.zzfz().zzak(context);
            if (audioManager != null) {
                try {
                    this.zzclr = audioManager.getMode();
                    this.zzcly = audioManager.isMusicActive();
                    this.zzclz = audioManager.isSpeakerphoneOn();
                    this.zzcmc = audioManager.getStreamVolume(3);
                    this.zzcmg = audioManager.getRingerMode();
                    this.zzcmh = audioManager.getStreamVolume(2);
                    return;
                }
                catch (Throwable throwable) {
                    zzu.zzgd().zza(throwable, "DeviceInfo.gatherAudioInfo");
                }
            }
            this.zzclr = -2;
            this.zzcly = false;
            this.zzclz = false;
            this.zzcmc = 0;
            this.zzcmg = 0;
            this.zzcmh = 0;
        }

        @TargetApi(value=16)
        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzclu = telephonyManager.getNetworkOperator();
            this.zzcme = telephonyManager.getNetworkType();
            this.zzcmf = telephonyManager.getPhoneType();
            this.zzcmd = -2;
            this.zzcmk = false;
            this.zzcml = -1;
            if (zzu.zzfz().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    this.zzcmd = networkInfo.getType();
                    this.zzcml = networkInfo.getDetailedState().ordinal();
                } else {
                    this.zzcmd = -1;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.zzcmk = connectivityManager.isActiveNetworkMetered();
                }
            }
        }

        private void zzw(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n2 = intent.getIntExtra("status", -1);
                int n3 = intent.getIntExtra("level", -1);
                int n4 = intent.getIntExtra("scale", -1);
                this.zzcmi = (float)n3 / (float)n4;
                this.zzcmj = n2 == 2 || n2 == 5;
            } else {
                this.zzcmi = -1.0;
                this.zzcmj = false;
            }
        }

        private void zzx(Context context) {
            this.zzcmm = Build.FINGERPRINT;
            this.zzcmn = zzdw.zzo(context);
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                String string2;
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                if (packageInfo != null) {
                    int n2 = packageInfo.versionCode;
                    String string3 = String.valueOf(activityInfo.packageName);
                    string2 = new StringBuilder(12 + String.valueOf(string3).length()).append(n2).append(".").append(string3).toString();
                } else {
                    string2 = null;
                }
                return string2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zzjh zzsk() {
            return new zzjh(this.zzclr, this.zzcls, this.zzclt, this.zzclu, this.zzclv, this.zzclw, this.zzclx, this.zzcly, this.zzclz, this.zzcma, this.zzcmb, this.zzcmc, this.zzcmd, this.zzcme, this.zzcmf, this.zzcmg, this.zzcmh, this.zzcgg, this.zzcge, this.zzcgf, this.zzcmi, this.zzcmj, this.zzcmk, this.zzcml, this.zzcmm, this.zzcmn);
        }
    }
}

