/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzlt;
import java.util.Map;

@zziy
public class zzhj
extends zzhm {
    private final Map<String, String> zzbiq;
    private final Context mContext;

    public zzhj(zzlt zzlt2, Map<String, String> map) {
        super(zzlt2, "storePicture");
        this.zzbiq = map;
        this.mContext = zzlt2.zzvn();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzbx("Activity context is not available");
            return;
        }
        zzda zzda2 = zzu.zzfz().zzag(this.mContext);
        if (!zzda2.zzkl()) {
            this.zzbx("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzbiq.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzbx("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzbx(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        final String string4 = this.zzbw(string2);
        if (!zzu.zzfz().zzcx(string4)) {
            String string5 = String.valueOf(string4);
            this.zzbx(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzu.zzgd().getResources();
        AlertDialog.Builder builder = zzu.zzfz().zzaf(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.store_picture_title) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.store_picture_message) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                DownloadManager downloadManager = (DownloadManager)zzhj.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzhj.this.zzk(string2, string4);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzhj.this.zzbx("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                zzhj.this.zzbx("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzk(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzu.zzgb().zza(request);
        return request;
    }

    String zzbw(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

