/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzlt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zziy
public class zzfm
extends zzfj {
    private static final Set<String> zzbog = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzboh = new DecimalFormat("#,###");
    private File zzboi;
    private boolean zzboj;

    public zzfm(zzlt zzlt2) {
        super(zzlt2);
        File file = this.mContext.getCacheDir();
        if (file == null) {
            zzkn.zzdf((String)"Context.getCacheDir() returned null");
            return;
        }
        this.zzboi = new File(file, "admobVideoStreams");
        if (!this.zzboi.isDirectory() && !this.zzboi.mkdirs()) {
            String string2 = String.valueOf(this.zzboi.getAbsolutePath());
            zzkn.zzdf((String)(string2.length() != 0 ? "Could not create preload cache directory at ".concat(string2) : new String("Could not create preload cache directory at ")));
            this.zzboi = null;
            return;
        }
        if (!this.zzboi.setReadable(true, false) || !this.zzboi.setExecutable(true, false)) {
            String string3 = String.valueOf(this.zzboi.getAbsolutePath());
            zzkn.zzdf((String)(string3.length() != 0 ? "Could not set cache file permissions at ".concat(string3) : new String("Could not set cache file permissions at ")));
            this.zzboi = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzbc(String string2) {
        if (this.zzboi == null) {
            this.zza(string2, null, "noCacheDir", null);
            return false;
        }
        while (this.zzmj() > zzdi.zzbbe.get()) {
            if (this.zzmk()) continue;
            zzkn.zzdf((String)"Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        String string3 = this.zzbd(string2);
        File file = new File(this.zzboi, string3);
        File file2 = this.zzb(file);
        if (file.isFile() && file2.isFile()) {
            int n2 = (int)file.length();
            String string4 = String.valueOf(string2);
            zzkn.zzdd((String)(string4.length() != 0 ? "Stream cache hit at ".concat(string4) : new String("Stream cache hit at ")));
            this.zza(string2, file.getAbsolutePath(), n2);
            return true;
        }
        String string5 = String.valueOf(this.zzboi.getAbsolutePath());
        String string6 = String.valueOf(string2);
        String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        Object object = zzbog;
        synchronized (object) {
            if (zzbog.contains(string7)) {
                String string8 = String.valueOf(string2);
                zzkn.zzdf((String)(string8.length() != 0 ? "Stream cache already in progress at ".concat(string8) : new String("Stream cache already in progress at ")));
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzbog.add(string7);
        }
        object = null;
        String string9 = "error";
        String string10 = null;
        try {
            int n3;
            int n4;
            HttpURLConnection httpURLConnection = zzu.zzgm().zzb(string2, zzdi.zzbbk.get());
            if (httpURLConnection instanceof HttpURLConnection && (n4 = httpURLConnection.getResponseCode()) >= 400) {
                string9 = "badUrl";
                String string11 = String.valueOf(Integer.toString(n4));
                string10 = string11.length() != 0 ? "HTTP request failed. Code: ".concat(string11) : new String("HTTP request failed. Code: ");
                throw new IOException(new StringBuilder(32 + String.valueOf(string2).length()).append("HTTP status code ").append(n4).append(" at ").append(string2).toString());
            }
            n4 = httpURLConnection.getContentLength();
            if (n4 < 0) {
                String string12 = String.valueOf(string2);
                zzkn.zzdf((String)(string12.length() != 0 ? "Stream cache aborted, missing content-length header at ".concat(string12) : new String("Stream cache aborted, missing content-length header at ")));
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzbog.remove(string7);
                return false;
            }
            String string13 = zzboh.format(n4);
            int n5 = zzdi.zzbbf.get();
            if (n4 > n5) {
                zzkn.zzdf((String)new StringBuilder(33 + String.valueOf(string13).length() + String.valueOf(string2).length()).append("Content length ").append(string13).append(" exceeds limit at ").append(string2).toString());
                String string14 = String.valueOf(string13);
                String string15 = string14.length() != 0 ? "File too big for full file cache. Size: ".concat(string14) : new String("File too big for full file cache. Size: ");
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string15);
                zzbog.remove(string7);
                return false;
            }
            zzkn.zzdd((String)new StringBuilder(20 + String.valueOf(string13).length() + String.valueOf(string2).length()).append("Caching ").append(string13).append(" bytes from ").append(string2).toString());
            InputStream inputStream = httpURLConnection.getInputStream();
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            object = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            zze zze2 = zzu.zzgf();
            int n6 = 0;
            long l2 = zze2.currentTimeMillis();
            long l3 = zzdi.zzbbj.get();
            zzlc zzlc2 = new zzlc(l3);
            long l4 = zzdi.zzbbi.get();
            while ((n3 = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n6 += n3) > n5) {
                    string9 = "sizeExceeded";
                    String string16 = String.valueOf(Integer.toString(n6));
                    string10 = string16.length() != 0 ? "File too big for full file cache. Size: ".concat(string16) : new String("File too big for full file cache. Size: ");
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                long l5 = zze2.currentTimeMillis();
                if (l5 - l2 > l4 * 1000L) {
                    string9 = "downloadTimeout";
                    String string17 = String.valueOf(Long.toString(l4));
                    string10 = new StringBuilder(29 + String.valueOf(string17).length()).append("Timeout exceeded. Limit: ").append(string17).append(" sec").toString();
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzboj) {
                    string9 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zzlc2.tryAcquire()) continue;
                this.zza(string2, file.getAbsolutePath(), n6, n4, false);
            }
            ((FileOutputStream)object).close();
            if (zzkn.zzbf((int)3)) {
                String string18 = zzboh.format(n6);
                zzkn.zzdd((String)new StringBuilder(22 + String.valueOf(string18).length() + String.valueOf(string2).length()).append("Preloaded ").append(string18).append(" bytes from ").append(string2).toString());
            }
            file.setReadable(true, false);
            zzfm.zzc(file2);
            this.zza(string2, file.getAbsolutePath(), n6);
            zzbog.remove(string7);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            if (exception instanceof RuntimeException) {
                zzu.zzgd().zza(exception, "VideoStreamFullFileCache.preload");
            }
            try {
                ((FileOutputStream)object).close();
            }
            catch (IOException | NullPointerException exception2) {
                // empty catch block
            }
            if (this.zzboj) {
                zzkn.zzde((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Preload aborted for URL \"").append(string2).append("\"").toString());
            } else {
                zzkn.zzd((String)new StringBuilder(25 + String.valueOf(string2).length()).append("Preload failed for URL \"").append(string2).append("\"").toString(), (Throwable)exception);
            }
            if (file.exists() && !file.delete()) {
                String string19 = String.valueOf(file.getAbsolutePath());
                zzkn.zzdf((String)(string19.length() != 0 ? "Could not delete partial cache file at ".concat(string19) : new String("Could not delete partial cache file at ")));
            }
            this.zza(string2, file.getAbsolutePath(), string9, string10);
            zzbog.remove(string7);
            return false;
        }
    }

    @Override
    public void abort() {
        this.zzboj = true;
    }

    public int zzmj() {
        if (this.zzboi == null) {
            return 0;
        }
        int n2 = 0;
        for (File file : this.zzboi.listFiles()) {
            if (file.getName().endsWith(".done")) continue;
            ++n2;
        }
        return n2;
    }

    public boolean zzmk() {
        if (this.zzboi == null) {
            return false;
        }
        File file = null;
        long l2 = Long.MAX_VALUE;
        for (File file2 : this.zzboi.listFiles()) {
            long l3;
            if (file2.getName().endsWith(".done") || (l3 = file2.lastModified()) >= l2) continue;
            file = file2;
            l2 = l3;
        }
        boolean bl = false;
        if (file != null) {
            bl = file.delete();
            File file3 = this.zzb(file);
            if (file3.isFile()) {
                bl &= file3.delete();
            }
        }
        return bl;
    }

    private File zzb(File file) {
        return new File(this.zzboi, String.valueOf(file.getName()).concat(".done"));
    }

    private static void zzc(File file) {
        if (file.isFile()) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

