/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzcr;
import com.google.android.gms.internal.zzcs;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzlt;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
@TargetApi(value=14)
public class zzcu
extends Thread {
    private boolean mStarted = false;
    private boolean zzauq = false;
    private boolean zzbl = false;
    private final Object zzakd;
    private final zzcs zzaur;
    private final zzix zzaus;
    private final int zzaut;
    private final int zzatu;
    private final int zzauu;
    private final int zzatw;
    private final int zzauv;

    public zzcu(zzcs zzcs2, zzix zzix2) {
        this.zzaur = zzcs2;
        this.zzaus = zzix2;
        this.zzakd = new Object();
        this.zzatu = zzdi.zzbce.get();
        this.zzauu = zzdi.zzbcf.get();
        this.zzatw = zzdi.zzbcg.get();
        this.zzauv = zzdi.zzbch.get();
        this.zzaut = zzdi.zzbci.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzim() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.mStarted) {
                zzkn.zzdd((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            if (false) break;
            try {
                if (this.zzin()) {
                    object = zzu.zzgc().getActivity();
                    if (object == null) {
                        zzkn.zzdd((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzip();
                    } else {
                        this.zza((Activity)object);
                    }
                } else {
                    zzkn.zzdd((String)"ContentFetchTask: sleeping");
                    this.zzip();
                }
                Thread.sleep(this.zzaut * 1000);
            }
            catch (Throwable throwable) {
                zzkn.zzb((String)"Error in ContentFetchTask", (Throwable)throwable);
                this.zzaus.zza(throwable, "ContentFetchTask.run");
            }
            object = this.zzakd;
            synchronized (object) {
                while (this.zzauq) {
                    try {
                        zzkn.zzdd((String)"ContentFetchTask: waiting");
                        this.zzakd.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zze(final @Nullable View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzcu.this.zzf(view);
            }
        });
        return true;
    }

    void zzf(View view) {
        try {
            zzcr zzcr2 = new zzcr(this.zzatu, this.zzauu, this.zzatw, this.zzauv);
            zza zza2 = this.zza(view, zzcr2);
            zzcr2.zzij();
            if (zza2.zzavd == 0 && zza2.zzave == 0) {
                return;
            }
            if (zza2.zzave == 0 && zzcr2.zzik() == 0) {
                return;
            }
            if (zza2.zzave == 0 && this.zzaur.zza(zzcr2)) {
                return;
            }
            this.zzaur.zzc(zzcr2);
        }
        catch (Exception exception) {
            zzkn.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzaus.zza(exception, "ContentFetchTask.fetchContent");
        }
    }

    boolean zzi(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzin() {
        try {
            Context context = zzu.zzgc().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzi(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        try {
            if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                view = activity.getWindow().getDecorView().findViewById(0x1020002);
            }
        }
        catch (Throwable throwable) {
            zzkn.zzdd((String)"Failed getting root view of activity. Content not extracted.");
        }
        if (view == null) {
            return;
        }
        this.zze(view);
    }

    zza zza(@Nullable View view, zzcr zzcr2) {
        if (view == null) {
            return new zza(0, 0);
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzcr2.zze(string2, bl);
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzlt)) {
            zzcr2.zzii();
            if (this.zza((WebView)view, zzcr2, bl)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n2 = 0;
            int n3 = 0;
            for (int i2 = 0; i2 < viewGroup.getChildCount(); ++i2) {
                zza zza2 = this.zza(viewGroup.getChildAt(i2), zzcr2);
                n2 += zza2.zzavd;
                n3 += zza2.zzave;
            }
            return new zza(n2, n3);
        }
        return new zza(0, 0);
    }

    @TargetApi(value=19)
    boolean zza(final WebView webView, final zzcr zzcr2, final boolean bl) {
        if (!zzs.zzaxr()) {
            return false;
        }
        zzcr2.zzii();
        webView.post(new Runnable(){
            ValueCallback<String> zzauy = new ValueCallback<String>(){

                public void zzab(String string2) {
                    zzcu.this.zza(zzcr2, webView, string2, bl);
                }

                public /* synthetic */ void onReceiveValue(Object object) {
                    this.zzab((String)object);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzauy);
                    }
                    catch (Throwable throwable) {
                        this.zzauy.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzcr zzcr2, WebView webView, String string2, boolean bl) {
        zzcr2.zzih();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = String.valueOf(webView.getTitle());
                    zzcr2.zzd(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl);
                } else {
                    zzcr2.zzd(string3, bl);
                }
            }
            if (zzcr2.zzid()) {
                this.zzaur.zzb(zzcr2);
            }
        }
        catch (JSONException jSONException) {
            zzkn.zzdd((String)"Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzkn.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzaus.zza(throwable, "ContentFetchTask.processWebViewContent");
        }
    }

    public zzcr zzio() {
        return this.zzaur.zzil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzauq = false;
            this.zzakd.notifyAll();
            zzkn.zzdd((String)"ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzip() {
        Object object = this.zzakd;
        synchronized (object) {
            boolean bl = this.zzauq = true;
            zzkn.zzdd((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
        }
    }

    public boolean zziq() {
        return this.zzauq;
    }

    @zziy
    class zza {
        final int zzavd;
        final int zzave;

        zza(int n2, int n3) {
            this.zzavd = n2;
            this.zzave = n3;
        }
    }
}

