/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.clearcut.zzb;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.zzc;
import com.google.android.gms.gass.internal.zza;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzam;
import com.google.android.gms.internal.zzao;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzbu;
import com.google.android.gms.internal.zzdi;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzbb {
    private static final String TAG = zzbb.class.getSimpleName();
    protected Context zzahn;
    protected Context zzaho;
    private ExecutorService zzahp;
    private DexClassLoader zzahq;
    private zzaw zzahr;
    private byte[] zzahs;
    private volatile AdvertisingIdClient zzaht = null;
    private volatile boolean zzagr = false;
    private Future zzahu = null;
    private volatile zzae.zza zzahv = null;
    private Future zzahw = null;
    private zzao zzahx;
    private GoogleApiClient zzahy = null;
    protected boolean zzahz = false;
    protected static final Object zzaia = new Object();
    protected boolean zzaib = false;
    private static zzc zzaic = null;
    protected boolean zzaid = false;
    private Map<Pair<String, String>, zzbu> zzaie;

    public static zzbb zza(Context context, String string2, String string3, boolean bl) {
        zzbb zzbb2 = new zzbb(context);
        try {
            if (zzbb2.zzc(string2, string3, bl)) {
                return zzbb2;
            }
        }
        catch (zzay zzay2) {
            // empty catch block
        }
        return null;
    }

    public Context getContext() {
        return this.zzahn;
    }

    public Context getApplicationContext() {
        return this.zzaho;
    }

    public ExecutorService zzch() {
        return this.zzahp;
    }

    public DexClassLoader zzci() {
        return this.zzahq;
    }

    public zzaw zzcj() {
        return this.zzahr;
    }

    public byte[] zzck() {
        return this.zzahs;
    }

    public GoogleApiClient zzcl() {
        return this.zzahy;
    }

    public boolean zzcm() {
        return this.zzahz;
    }

    public boolean zzcn() {
        return this.zzaid;
    }

    public zzao zzco() {
        return this.zzahx;
    }

    public zzae.zza zzcp() {
        return this.zzahv;
    }

    public Future zzcq() {
        return this.zzahw;
    }

    private zzbb(Context context) {
        this.zzahn = context;
        this.zzaho = context.getApplicationContext();
        this.zzaie = new HashMap<Pair<String, String>, zzbu>();
    }

    private boolean zzc(String string2, String string3, boolean bl) throws zzay {
        boolean bl2 = false;
        this.zzahp = Executors.newCachedThreadPool();
        this.zzc(bl);
        this.zzcu();
        this.zzcs();
        this.zzahr = new zzaw(null);
        try {
            this.zzahs = this.zzahr.zzn(string2);
        }
        catch (zzaw.zza zza2) {
            throw new zzay(zza2);
        }
        bl2 = this.zzo(string3);
        this.zzahx = new zzao(this);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzo(String string2) throws zzay {
        try {
            File file = this.zzahn.getCacheDir();
            if (file == null && (file = this.zzahn.getDir("dex", 0)) == null) {
                throw new zzay();
            }
            String string3 = zzax.zzax();
            File file2 = this.zza(string2, file, string3);
            this.zzb(file, string3);
            try {
                this.zzahq = new DexClassLoader(file2.getAbsolutePath(), file.getAbsolutePath(), null, this.zzahn.getClassLoader());
                boolean bl = true;
                this.zza(file2);
                this.zza(file, string3);
            }
            catch (Throwable throwable) {
                this.zza(file2);
                this.zza(file, string3);
                this.zzp(String.format("%s/%s.dex", file, string3));
                throw throwable;
            }
            this.zzp(String.format("%s/%s.dex", file, string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new zzay(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new zzay(iOException);
        }
        catch (zzaw.zza zza2) {
            throw new zzay(zza2);
        }
        catch (NullPointerException nullPointerException) {
            throw new zzay(nullPointerException);
        }
        return true;
    }

    @NonNull
    private File zza(String string2, File file, String string3) throws zzaw.zza, IOException {
        File file2 = new File(String.format("%s/%s.jar", file, string3));
        if (!file2.exists()) {
            byte[] byArray = this.zzahr.zzc(this.zzahs, string2);
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zza(File file, String string2) {
        block29: {
            byte[] byArray;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            File file3;
            block28: {
                file3 = new File(String.format("%s/%s.tmp", file, string2));
                if (file3.exists()) {
                    return;
                }
                file2 = new File(String.format("%s/%s.dex", file, string2));
                if (!file2.exists()) {
                    return;
                }
                fileInputStream = null;
                fileOutputStream = null;
                long l2 = file2.length();
                if (l2 <= 0L) {
                    return;
                }
                byArray = new byte[(int)l2];
                fileInputStream = new FileInputStream(file2);
                int n2 = fileInputStream.read(byArray);
                if (n2 > 0) break block28;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.zza(file2);
                return;
            }
            try {
                zzae.zzd zzd2 = new zzae.zzd();
                zzd2.zzft = Build.VERSION.SDK.getBytes();
                zzd2.zzfs = string2.getBytes();
                byte[] byArray2 = this.zzahr.zzd(this.zzahs, byArray).getBytes();
                zzd2.data = byArray2;
                zzd2.zzfr = zzam.zzg(byArray2);
                byArray = null;
                file3.createNewFile();
                fileOutputStream = new FileOutputStream(file3);
                byte[] byArray3 = zzark.zzf((zzark)zzd2);
                zzd2 = null;
                fileOutputStream.write(byArray3, 0, byArray3.length);
                fileOutputStream.close();
            }
            catch (zzaw.zza | IOException | NoSuchAlgorithmException exception) {
                break block29;
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                this.zza(file2);
            }
        }
    }

    private void zzp(String string2) {
        File file = new File(string2);
        this.zza(file);
    }

    private void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean zzb(File file, String string2) {
        File file2 = new File(String.format("%s/%s.tmp", file, string2));
        if (!file2.exists()) {
            return false;
        }
        File file3 = new File(String.format("%s/%s.dex", file, string2));
        if (file3.exists()) {
            return false;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            long l2 = file2.length();
            if (l2 <= 0L) {
                this.zza(file2);
                boolean bl = false;
                try {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    return false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            fileInputStream = new FileInputStream(file2);
            byte[] byArray = new byte[(int)l2];
            int n2 = fileInputStream.read(byArray);
            if (n2 <= 0) {
                Log.d((String)TAG, (String)"Cannot read the cache data.");
                this.zza(file2);
                boolean bl = false;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    return false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            zzae.zzd zzd2 = zzae.zzd.zzd((byte[])byArray);
            byArray = null;
            if (!(string2.equals(new String(zzd2.zzfs)) && Arrays.equals(zzd2.zzfr, zzam.zzg(zzd2.data)) && Arrays.equals(zzd2.zzft, Build.VERSION.SDK.getBytes()))) {
                this.zza(file2);
                boolean bl = false;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    return false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            byte[] byArray2 = this.zzahr.zzc(this.zzahs, new String(zzd2.data));
            file3.createNewFile();
            fileOutputStream = new FileOutputStream(file3);
            fileOutputStream.write(byArray2, 0, byArray2.length);
            return true;
        }
        catch (zzaw.zza | IOException | NoSuchAlgorithmException exception) {
            boolean bl = false;
            return false;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean zza(String string2, String string3, List<Class> list) {
        if (!this.zzaie.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzaie.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzbu(this, string2, string3, list));
            return true;
        }
        return false;
    }

    public Method zzc(String string2, String string3) {
        zzbu zzbu2 = this.zzaie.get(new Pair((Object)string2, (Object)string3));
        if (zzbu2 == null) {
            return null;
        }
        return zzbu2.zzdd();
    }

    private void zzc(boolean bl) {
        this.zzagr = bl;
        if (!bl) {
            return;
        }
        this.zzahu = this.zzahp.submit(new Runnable(){

            @Override
            public void run() {
                zzbb.this.zzcr();
            }
        });
    }

    private void zzcr() {
        try {
            if (this.zzaht == null && this.zzaho != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzaho);
                advertisingIdClient.start();
                this.zzaht = advertisingIdClient;
            }
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzaht = null;
        }
    }

    void zzcs() {
        if (!zzdi.zzbfh.get().booleanValue()) {
            return;
        }
        this.zzahw = this.zzahp.submit(new Runnable(){

            @Override
            public void run() {
                zzbb.this.zzct();
            }
        });
    }

    private void zzct() {
        if (this.zzaib) {
            try {
                PackageInfo packageInfo = this.zzahn.getPackageManager().getPackageInfo(this.zzahn.getPackageName(), 0);
                this.zzahv = zza.zzi((Context)this.zzahn, (String)this.zzahn.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    private void zzcu() {
        zzaic = zzc.zzapd();
        this.zzahz = zzaic.zzbo(this.zzahn) > 0;
        boolean bl = this.zzaib = zzaic.isGooglePlayServicesAvailable(this.zzahn) == 0;
        if (this.zzahn.getApplicationContext() != null) {
            this.zzahy = new GoogleApiClient.Builder(this.zzahn).addApi(zzb.API).build();
        }
        zzdi.initialize(this.zzahn);
    }

    public AdvertisingIdClient zzcv() {
        if (!this.zzagr) {
            return null;
        }
        if (this.zzaht != null) {
            return this.zzaht;
        }
        if (this.zzahu != null) {
            try {
                this.zzahu.get(2000L, TimeUnit.MILLISECONDS);
                this.zzahu = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzahu.cancel(true);
            }
        }
        return this.zzaht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcw() {
        Object object = zzaia;
        synchronized (object) {
            if (this.zzaid) {
                return;
            }
            if (this.zzaib && this.zzahy != null) {
                this.zzahy.connect();
                this.zzaid = true;
            } else {
                this.zzaid = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcx() {
        Object object = zzaia;
        synchronized (object) {
            if (this.zzaid && this.zzahy != null) {
                this.zzahy.disconnect();
                this.zzaid = false;
            }
        }
    }

    public int zzau() {
        int n2 = Integer.MIN_VALUE;
        zzao zzao2 = this.zzco();
        if (zzao2 != null) {
            n2 = zzao2.zzau();
        }
        return n2;
    }
}

