/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzp;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.internal.reward.client.zzd;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcc;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdu;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzib;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkq;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zziy
public class zzt
extends zzu.zza {
    private final VersionInfoParcel zzanh;
    private final AdSizeParcel zzapc;
    private final Future<zzcc> zzapd;
    private final Context mContext;
    private final zzb zzape;
    @Nullable
    private WebView zzapf;
    @Nullable
    private zzq zzamy;
    @Nullable
    private zzcc zzapg;
    private AsyncTask<Void, Void, Void> zzaph;

    public zzt(Context context, AdSizeParcel adSizeParcel, String string2, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzanh = versionInfoParcel;
        this.zzapc = adSizeParcel;
        this.zzapf = new WebView(this.mContext);
        this.zzapd = this.zzfp();
        this.zzape = new zzb(string2);
        this.zzfm();
    }

    public com.google.android.gms.dynamic.zzd zzds() throws RemoteException {
        zzac.zzhq((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzac((Object)this.zzapf);
    }

    public void destroy() throws RemoteException {
        zzac.zzhq((String)"destroy must be called on the main UI thread.");
        this.zzaph.cancel(true);
        this.zzapd.cancel(true);
        this.zzapf.destroy();
        this.zzapf = null;
    }

    public boolean isReady() throws RemoteException {
        return false;
    }

    public boolean zzb(AdRequestParcel adRequestParcel) throws RemoteException {
        zzac.zzb((Object)this.zzapf, (Object)"This Search Ad has already been torn down");
        this.zzape.zzi(adRequestParcel);
        this.zzaph = new zza().execute(new Void[0]);
        return true;
    }

    public void pause() throws RemoteException {
        zzac.zzhq((String)"pause must be called on the main UI thread.");
    }

    public void resume() throws RemoteException {
        zzac.zzhq((String)"resume must be called on the main UI thread.");
    }

    public void zza(zzq zzq2) throws RemoteException {
        this.zzamy = zzq2;
    }

    public void zza(zzw zzw2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void showInterstitial() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void stopLoading() throws RemoteException {
    }

    public void zzdv() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public AdSizeParcel zzdt() throws RemoteException {
        return this.zzapc;
    }

    public void zza(AdSizeParcel adSizeParcel) throws RemoteException {
        throw new IllegalStateException("AdSize must be set before initialization");
    }

    public void zza(zzhx zzhx2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzib zzib2, String string2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public String getMediationAdapterClassName() throws RemoteException {
        return null;
    }

    public void zza(zzdu zzdu2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzp zzp2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzy zzy2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void setManualImpressionsEnabled(boolean bl) throws RemoteException {
    }

    public boolean isLoading() throws RemoteException {
        return false;
    }

    public void zza(zzd zzd2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void setUserId(String string2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public zzab zzdw() {
        return null;
    }

    public void zza(VideoOptionsParcel videoOptionsParcel) {
        throw new IllegalStateException("Unused method");
    }

    private void zzfm() {
        this.zzj(0);
        this.zzapf.setVerticalScrollBarEnabled(false);
        this.zzapf.getSettings().setJavaScriptEnabled(true);
        this.zzapf.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
                if (string2.startsWith(zzt.this.zzfo())) {
                    return false;
                }
                if (string2.startsWith(zzdi.zzbgv.get())) {
                    if (zzt.this.zzamy != null) {
                        try {
                            zzt.this.zzamy.onAdFailedToLoad(3);
                        }
                        catch (RemoteException remoteException) {
                            zzkn.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                        }
                    }
                    zzt.this.zzj(0);
                    return true;
                }
                if (string2.startsWith(zzdi.zzbgw.get())) {
                    if (zzt.this.zzamy != null) {
                        try {
                            zzt.this.zzamy.onAdFailedToLoad(0);
                        }
                        catch (RemoteException remoteException) {
                            zzkn.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                        }
                    }
                    zzt.this.zzj(0);
                    return true;
                }
                if (string2.startsWith(zzdi.zzbgx.get())) {
                    if (zzt.this.zzamy != null) {
                        try {
                            zzt.this.zzamy.onAdLoaded();
                        }
                        catch (RemoteException remoteException) {
                            zzkn.zzd((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
                        }
                    }
                    int n2 = zzt.this.zzy(string2);
                    zzt.this.zzj(n2);
                    return true;
                }
                if (string2.startsWith("gmsg://")) {
                    return true;
                }
                if (zzt.this.zzamy != null) {
                    try {
                        zzt.this.zzamy.onAdLeftApplication();
                    }
                    catch (RemoteException remoteException) {
                        zzkn.zzd((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
                    }
                }
                String string3 = zzt.this.zzz(string2);
                zzt.this.zzaa(string3);
                return true;
            }

            public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                if (zzt.this.zzamy != null) {
                    try {
                        zzt.this.zzamy.onAdFailedToLoad(0);
                    }
                    catch (RemoteException remoteException) {
                        zzkn.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                    }
                }
            }
        });
        this.zzapf.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (zzt.this.zzapg != null) {
                    try {
                        zzt.this.zzapg.zza(motionEvent);
                    }
                    catch (RemoteException remoteException) {
                        zzkn.zzd((String)"Unable to process ad data", (Throwable)remoteException);
                    }
                }
                return false;
            }
        });
    }

    int zzy(String string2) {
        String string3 = Uri.parse((String)string2).getQueryParameter("height");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return 0;
        }
        try {
            return zzm.zzjr().zzb(this.mContext, Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    void zzj(int n2) {
        if (this.zzapf == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, n2);
        this.zzapf.setLayoutParams(layoutParams);
    }

    String zzfn() {
        String string22;
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https://").appendEncodedPath(zzdi.zzbgy.get());
        builder.appendQueryParameter("query", this.zzape.getQuery());
        builder.appendQueryParameter("pubId", this.zzape.zzfs());
        Map<String, String> map = this.zzape.zzft();
        for (String string22 : map.keySet()) {
            builder.appendQueryParameter(string22, map.get(string22));
        }
        Uri uri = builder.build();
        if (this.zzapg != null) {
            try {
                uri = this.zzapg.zzc(uri, this.mContext);
            }
            catch (RemoteException | zzcd throwable) {
                zzkn.zzd((String)"Unable to process ad data", (Throwable)throwable);
            }
        }
        string22 = String.valueOf(this.zzfo());
        String string3 = String.valueOf(uri.getEncodedQuery());
        return new StringBuilder(1 + String.valueOf(string22).length() + String.valueOf(string3).length()).append(string22).append("#").append(string3).toString();
    }

    String zzfo() {
        String string2 = this.zzape.zzfr();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "www.google.com";
        }
        String string3 = String.valueOf("https://");
        String string4 = string2;
        String string5 = zzdi.zzbgy.get();
        return new StringBuilder(0 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string3).append(string4).append(string5).toString();
    }

    private String zzz(String string2) {
        if (this.zzapg == null) {
            return string2;
        }
        Uri uri = Uri.parse((String)string2);
        try {
            uri = this.zzapg.zzd(uri, this.mContext);
        }
        catch (RemoteException remoteException) {
            zzkn.zzd((String)"Unable to process ad data", (Throwable)remoteException);
        }
        catch (zzcd zzcd2) {
            zzkn.zzd((String)"Unable to parse ad click url", (Throwable)zzcd2);
        }
        return uri.toString();
    }

    private void zzaa(String string2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string2));
        this.mContext.startActivity(intent);
    }

    private Future<zzcc> zzfp() {
        return zzkq.zza(new Callable<zzcc>(){

            public zzcc zzfq() throws Exception {
                return new zzcc(((zzt)zzt.this).zzanh.zzcs, zzt.this.mContext, false);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzfq();
            }
        });
    }

    private static class zzb {
        private final String zzapj;
        private final Map<String, String> zzapk;
        private String zzapl;
        private String zzapm;

        public zzb(String string2) {
            this.zzapj = string2;
            this.zzapk = new TreeMap<String, String>();
        }

        public String zzfr() {
            return this.zzapm;
        }

        public String getQuery() {
            return this.zzapl;
        }

        public String zzfs() {
            return this.zzapj;
        }

        public Map<String, String> zzft() {
            return this.zzapk;
        }

        public void zzi(AdRequestParcel adRequestParcel) {
            this.zzapl = adRequestParcel.zzawk.zzbab;
            Bundle bundle = null;
            if (adRequestParcel.zzawn != null) {
                bundle = adRequestParcel.zzawn.getBundle(AdMobAdapter.class.getName());
            }
            if (bundle == null) {
                return;
            }
            String string2 = zzdi.zzbgz.get();
            for (String string3 : bundle.keySet()) {
                if (string2.equals(string3)) {
                    this.zzapm = bundle.getString(string3);
                    continue;
                }
                if (!string3.startsWith("csa_")) continue;
                this.zzapk.put(string3.substring("csa_".length()), bundle.getString(string3));
            }
        }
    }

    private class zza
    extends AsyncTask<Void, Void, Void> {
        private zza() {
        }

        protected Void doInBackground(Void ... voidArray) {
            try {
                zzt.this.zzapg = (zzcc)zzt.this.zzapd.get(zzdi.zzbha.get(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException exception) {
                zzkn.zzd((String)"Failed to load ad data", (Throwable)exception);
            }
            catch (TimeoutException timeoutException) {
                zzkn.zzdf((String)"Timed out waiting for ad data");
            }
            return null;
        }

        protected void onPostExecute(Void void_) {
            String string2 = zzt.this.zzfn();
            if (zzt.this.zzapf != null) {
                zzt.this.zzapf.loadUrl(string2);
            }
        }
    }
}

