/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzs;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzhp;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkm;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzku;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzlu;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;

@zziy
public class zzd
extends zzhp.zza
implements com.google.android.gms.ads.internal.overlay.zzu {
    static final int zzbxe = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzbxf;
    zzlt zzbkr;
    zzc zzbxg;
    zzo zzbxh;
    boolean zzbxi = false;
    FrameLayout zzbxj;
    WebChromeClient.CustomViewCallback zzbxk;
    boolean zzbxl = false;
    boolean zzbxm = false;
    zzb zzbxn;
    boolean zzbxo = false;
    int zzbxp = 0;
    zzl zzbxq;
    private final Object zzbxr = new Object();
    private Runnable zzbxs;
    private boolean zzbxt;
    private boolean zzbxu;
    private boolean zzbxv = false;
    private boolean zzbxw = false;
    private boolean zzbxx = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
        this.zzbxq = new zzs();
    }

    public void close() {
        this.zzbxp = 2;
        this.mActivity.finish();
    }

    public void zzos() {
        if (this.zzbxf != null && this.zzbxi) {
            this.setRequestedOrientation(this.zzbxf.orientation);
        }
        if (this.zzbxj != null) {
            this.mActivity.setContentView((View)this.zzbxn);
            this.zzdf();
            this.zzbxj.removeAllViews();
            this.zzbxj = null;
        }
        if (this.zzbxk != null) {
            this.zzbxk.onCustomViewHidden();
            this.zzbxk = null;
        }
        this.zzbxi = false;
    }

    @Override
    public void zzot() {
        this.zzbxp = 1;
        this.mActivity.finish();
    }

    public void onBackPressed() {
        this.zzbxp = 0;
    }

    public boolean zzou() {
        boolean bl;
        this.zzbxp = 0;
        if (this.zzbkr == null) {
            return true;
        }
        boolean bl2 = bl = this.zzbkr.zzpr() && this.zzbxq.zzpr();
        if (!bl) {
            this.zzbkr.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzbxl = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzbxf = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzbxf == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzbxf.zzaqv.zzctt > 7500000) {
                this.zzbxp = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzbxx = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzbxm = this.zzbxf.zzbyq != null ? this.zzbxf.zzbyq.zzanx : false;
            if (zzdi.zzbfn.get().booleanValue() && this.zzbxm && this.zzbxf.zzbyq.zzaoc != -1) {
                Future cfr_ignored_0 = (Future)new zzd().zzqw();
            }
            if (bundle == null) {
                if (this.zzbxf.zzbyg != null && this.zzbxx) {
                    this.zzbxf.zzbyg.zzee();
                }
                if (this.zzbxf.zzbyn != 1 && this.zzbxf.zzbyf != null) {
                    this.zzbxf.zzbyf.onAdClicked();
                }
            }
            this.zzbxn = new zzb((Context)this.mActivity, this.zzbxf.zzbyp);
            this.zzbxn.setId(1000);
            switch (this.zzbxf.zzbyn) {
                case 1: {
                    this.zzab(false);
                    break;
                }
                case 2: {
                    this.zzbxg = new zzc(this.zzbxf.zzbyh);
                    this.zzab(false);
                    break;
                }
                case 3: {
                    this.zzab(true);
                    break;
                }
                case 4: {
                    if (this.zzbxl) {
                        this.zzbxp = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzu.zzfw().zza((Context)this.mActivity, this.zzbxf.zzbye, this.zzbxf.zzbym)) {
                        this.zzbxp = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            zzkn.zzdf((String)zza2.getMessage());
            this.zzbxp = 3;
            this.mActivity.finish();
        }
    }

    public void onRestart() {
    }

    public void onStart() {
    }

    public void onResume() {
        if (this.zzbxf != null && this.zzbxf.zzbyn == 4) {
            if (this.zzbxl) {
                this.zzbxp = 3;
                this.mActivity.finish();
            } else {
                this.zzbxl = true;
            }
        }
        if (this.zzbxf.zzbyg != null) {
            this.zzbxf.zzbyg.onResume();
        }
        if (this.zzbkr != null && !this.zzbkr.isDestroyed()) {
            zzu.zzgb().zzm(this.zzbkr);
        } else {
            zzkn.zzdf((String)"The webview does not exit. Ignoring action.");
        }
        this.zzbxq.resume();
    }

    public void onPause() {
        this.zzbxq.pause();
        this.zzos();
        if (this.zzbxf.zzbyg != null) {
            this.zzbxf.zzbyg.onPause();
        }
        if (!(this.zzbkr == null || this.mActivity.isFinishing() && this.zzbxg != null)) {
            zzu.zzgb().zzl(this.zzbkr);
        }
        this.zzow();
    }

    public void onActivityResult(int n2, int n3, Intent intent) {
    }

    public void zzn(com.google.android.gms.dynamic.zzd zzd2) {
        if (zzdi.zzbhx.get().booleanValue() && com.google.android.gms.common.util.zzs.zzaxw()) {
            Configuration configuration = (Configuration)zze.zzae((com.google.android.gms.dynamic.zzd)zzd2);
            if (zzu.zzfz().zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
            } else {
                this.mActivity.getWindow().addFlags(2048);
                this.mActivity.getWindow().clearFlags(1024);
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzbxl);
    }

    public void onStop() {
        this.zzow();
    }

    public void onDestroy() {
        if (this.zzbkr != null) {
            this.zzbxn.removeView(this.zzbkr.getView());
        }
        this.zzow();
    }

    public void zzaa(boolean bl) {
        int n2 = bl ? 50 : 32;
        this.zzbxh = new zzo((Context)this.mActivity, n2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n3 = bl ? 11 : 9;
        layoutParams.addRule(n3);
        this.zzbxh.zza(bl, this.zzbxf.zzbyk);
        this.zzbxn.addView((View)this.zzbxh, (ViewGroup.LayoutParams)layoutParams);
    }

    public void zzdf() {
        this.zzbxu = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzbxh != null) {
            this.zzbxh.zza(bl, bl2);
        }
    }

    public void zzov() {
        this.zzbxn.removeView((View)this.zzbxh);
        this.zzaa(true);
    }

    public void setRequestedOrientation(int n2) {
        this.mActivity.setRequestedOrientation(n2);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzbxj = new FrameLayout((Context)this.mActivity);
        this.zzbxj.setBackgroundColor(-16777216);
        this.zzbxj.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzbxj);
        this.zzdf();
        this.zzbxk = customViewCallback;
        this.zzbxi = true;
    }

    protected void zzab(boolean bl) throws zza {
        com.google.android.gms.ads.internal.zzd zzd2;
        zzm zzm2;
        zzlu zzlu2;
        boolean bl2;
        Window window;
        if (!this.zzbxu) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (com.google.android.gms.common.util.zzs.zzaxw() && zzdi.zzbhx.get().booleanValue()) {
            bl3 = zzu.zzfz().zza(this.mActivity, this.mActivity.getResources().getConfiguration());
        }
        boolean bl4 = bl2 = this.zzbxf.zzbyq != null && this.zzbxf.zzbyq.zzany;
        if ((!this.zzbxm || bl2) && bl3) {
            window.setFlags(1024, 1024);
        }
        boolean bl5 = (zzlu2 = this.zzbxf.zzbyh.zzvr()) != null ? zzlu2.zzib() : false;
        this.zzbxo = false;
        if (bl5) {
            if (this.zzbxf.orientation == zzu.zzgb().zzum()) {
                this.zzbxo = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzbxf.orientation == zzu.zzgb().zzun()) {
                this.zzbxo = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzbxo;
        zzkn.zzdd((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzbxf.orientation);
        if (zzu.zzgb().zza(window)) {
            zzkn.zzdd((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzbxm) {
            this.zzbxn.setBackgroundColor(-16777216);
        } else {
            this.zzbxn.setBackgroundColor(zzbxe);
        }
        this.mActivity.setContentView((View)this.zzbxn);
        this.zzdf();
        if (bl) {
            this.zzbkr = zzu.zzga().zza((Context)this.mActivity, this.zzbxf.zzbyh.zzdt(), true, bl5, null, this.zzbxf.zzaqv, null, null, this.zzbxf.zzbyh.zzdp());
            this.zzbkr.zzvr().zza(null, null, this.zzbxf.zzbyi, this.zzbxf.zzbym, true, this.zzbxf.zzbyo, null, this.zzbxf.zzbyh.zzvr().zzwi(), null, null);
            this.zzbkr.zzvr().zza(new zzlu.zza(){

                @Override
                public void zza(zzlt zzlt2, boolean bl) {
                    zzlt2.zzoz();
                }
            });
            if (this.zzbxf.url != null) {
                this.zzbkr.loadUrl(this.zzbxf.url);
            } else if (this.zzbxf.zzbyl != null) {
                this.zzbkr.loadDataWithBaseURL(this.zzbxf.zzbyj, this.zzbxf.zzbyl, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzbxf.zzbyh != null) {
                this.zzbxf.zzbyh.zzc(this);
            }
        } else {
            this.zzbkr = this.zzbxf.zzbyh;
            this.zzbkr.setContext((Context)this.mActivity);
        }
        this.zzbkr.zzb(this);
        ViewParent viewParent = this.zzbkr.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzbkr.getView());
        }
        if (this.zzbxm) {
            this.zzbkr.zzwh();
        }
        this.zzbxn.addView(this.zzbkr.getView(), -1, -1);
        if (!bl && !this.zzbxo) {
            this.zzoz();
        }
        this.zzaa(bl5);
        if (this.zzbkr.zzvs()) {
            this.zza(bl5, true);
        }
        zzm zzm3 = zzm2 = (zzd2 = this.zzbkr.zzdp()) != null ? zzd2.zzame : null;
        if (zzm2 != null) {
            this.zzbxq = zzm2.zza(this.mActivity, this.zzbkr, this.zzbxn);
        } else {
            zzkn.zzdf((String)"Appstreaming controller is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzow() {
        if (!this.mActivity.isFinishing() || this.zzbxv) {
            return;
        }
        this.zzbxv = true;
        if (this.zzbkr != null) {
            this.zzah(this.zzbxp);
            Object object = this.zzbxr;
            synchronized (object) {
                if (!this.zzbxt && this.zzbkr.zzwc()) {
                    this.zzbxs = new Runnable(){

                        @Override
                        public void run() {
                            zzd.this.zzox();
                        }
                    };
                    zzkr.zzcrf.postDelayed(this.zzbxs, zzdi.zzbdh.get().longValue());
                    return;
                }
            }
        }
        this.zzox();
    }

    void zzox() {
        if (this.zzbxw) {
            return;
        }
        this.zzbxw = true;
        if (this.zzbkr != null) {
            this.zzbxn.removeView(this.zzbkr.getView());
            if (this.zzbxg != null) {
                this.zzbkr.setContext(this.zzbxg.zzahn);
                this.zzbkr.zzaj(false);
                this.zzbxg.zzbyb.addView(this.zzbkr.getView(), this.zzbxg.index, this.zzbxg.zzbya);
                this.zzbxg = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzbkr.setContext(this.mActivity.getApplicationContext());
            }
            this.zzbkr = null;
        }
        if (this.zzbxf != null && this.zzbxf.zzbyg != null) {
            this.zzbxf.zzbyg.zzed();
        }
        this.zzbxq.destroy();
    }

    public void zzoy() {
        if (this.zzbxo) {
            this.zzbxo = false;
            this.zzoz();
        }
    }

    protected void zzoz() {
        this.zzbkr.zzoz();
    }

    protected void zzah(int n2) {
        this.zzbkr.zzah(n2);
    }

    public void zzf(zzlt zzlt2, Map<String, String> map) {
        this.zzbxq.zzf(zzlt2, map);
    }

    public void zzpa() {
        this.zzbxn.disable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzpb() {
        Object object = this.zzbxr;
        synchronized (object) {
            this.zzbxt = true;
            if (this.zzbxs != null) {
                zzkr.zzcrf.removeCallbacks(this.zzbxs);
                zzkr.zzcrf.post(this.zzbxs);
            }
        }
    }

    @zziy
    private class zzd
    extends zzkm {
        private zzd() {
        }

        @Override
        public void zzfc() {
            Bitmap bitmap = zzu.zzgu().zza(zzd.this.zzbxf.zzbyq.zzaoc);
            if (bitmap != null) {
                final Drawable drawable = zzu.zzgb().zza((Context)zzd.this.mActivity, bitmap, zzd.this.zzbxf.zzbyq.zzaoa, zzd.this.zzbxf.zzbyq.zzaob);
                zzkr.zzcrf.post(new Runnable(){

                    @Override
                    public void run() {
                        zzd.this.mActivity.getWindow().setBackgroundDrawable(drawable);
                    }
                });
            }
        }

        @Override
        public void onStop() {
        }
    }

    @zziy
    static class zzb
    extends RelativeLayout {
        zzku zzase;
        boolean zzbxz;

        public zzb(Context context, String string2) {
            super(context);
            this.zzase = new zzku(context, string2);
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (!this.zzbxz) {
                this.zzase.zzg(motionEvent);
            }
            return false;
        }

        void disable() {
            this.zzbxz = true;
        }
    }

    @zziy
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzbya;
        public final ViewGroup zzbyb;
        public final Context zzahn;

        public zzc(zzlt zzlt2) throws zza {
            this.zzbya = zzlt2.getLayoutParams();
            ViewParent viewParent = zzlt2.getParent();
            this.zzahn = zzlt2.zzvo();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzbyb = (ViewGroup)viewParent;
            this.index = this.zzbyb.indexOfChild(zzlt2.getView());
            this.zzbyb.removeView(zzlt2.getView());
            zzlt2.zzaj(true);
        }
    }

    @zziy
    private static final class zza
    extends Exception {
        public zza(String string2) {
            super(string2);
        }
    }
}

