/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.debugging;

import android.text.TextUtils;
import com.loopme.common.Logging;
import com.loopme.debugging.HttpUtils;
import com.loopme.request.AdRequestParametersProvider;
import java.util.HashMap;
import java.util.Map;

public class ErrorLog {
    private static final String LOG_TAG = ErrorLog.class.getSimpleName();

    private ErrorLog() {
    }

    public static void post(String errorMessage) {
        Logging.out(LOG_TAG, errorMessage);
        Map<String, String> params = ErrorLog.initPostDataParams(errorMessage, null);
        HttpUtils.postDataToServer(params);
    }

    public static void post(String errorMessage, String type) {
        Logging.out(LOG_TAG, errorMessage);
        Map<String, String> params = ErrorLog.initPostDataParams(errorMessage, type);
        HttpUtils.postDataToServer(params);
    }

    private static Map<String, String> initPostDataParams(String errorMessage, String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        AdRequestParametersProvider provider = AdRequestParametersProvider.getInstance();
        params.put("device_os", "android");
        params.put("sdk_type", "loopme");
        params.put("sdk_version", "5.1.11");
        params.put("device_id", provider.getViewerToken());
        params.put("package", provider.getPackage());
        params.put("app_key", TextUtils.isEmpty((CharSequence)provider.getAppKey()) ? "unknown" : provider.getAppKey());
        params.put("msg", "sdk_error");
        params.put("error_type", TextUtils.isEmpty((CharSequence)type) ? "custom" : type);
        params.put("error_msg", errorMessage);
        return params;
    }
}

