/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.common;

import android.content.Context;
import com.loopme.common.Logging;
import com.loopme.common.StaticParams;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

class VideoUtils {
    private static final String LOG_TAG = VideoUtils.class.getSimpleName();
    public static final String MP4_FORMAT = ".mp4";
    public static final String VIDEO_FOLDER = "LoopMeAds";
    private static final int MAX_FILE_NAME_LENGHT = 123;

    VideoUtils() {
    }

    public static void deleteInvalidVideoFiles(Context context) {
        File[] files;
        File parentDir = VideoUtils.getParentDir(context);
        if (parentDir == null) {
            return;
        }
        int amountOfCachedFiles = 0;
        for (File file : files = parentDir.listFiles()) {
            long currentTime;
            if (file.isDirectory() || !file.getName().endsWith(MP4_FORMAT)) continue;
            File f = new File(file.getAbsolutePath());
            long creationTime = f.lastModified();
            if (creationTime + StaticParams.CACHED_VIDEO_LIFE_TIME < (currentTime = System.currentTimeMillis()) || f.length() == 0L) {
                f.delete();
                Logging.out(LOG_TAG, "Deleted cached file: " + file.getAbsolutePath());
                continue;
            }
            ++amountOfCachedFiles;
        }
        Logging.out(LOG_TAG, "In cache " + amountOfCachedFiles + " file(s)");
        float cacheHours = StaticParams.CACHED_VIDEO_LIFE_TIME / 3600000L;
        Logging.out(LOG_TAG, "Cache time: " + cacheHours + " hours");
    }

    public static File checkFileNotExists(String filename, Context context) {
        File[] files;
        File parentDir = VideoUtils.getParentDir(context);
        if (parentDir == null) {
            return null;
        }
        Logging.out(LOG_TAG, "Cache dir: " + parentDir.getAbsolutePath());
        for (File file : files = parentDir.listFiles()) {
            if (file.isDirectory() || !file.getName().startsWith(filename)) continue;
            return file;
        }
        return null;
    }

    public static String detectFileName(String videoUrl) {
        String fileName = null;
        try {
            URL url = new URL(videoUrl);
            fileName = url.getFile();
            if (fileName != null && !fileName.isEmpty()) {
                int length;
                if (!fileName.endsWith(MP4_FORMAT)) {
                    int urlHash = videoUrl.hashCode();
                    return Long.toString((long)urlHash & 0xFFFFFFFFL);
                }
                fileName = fileName.replace(MP4_FORMAT, "");
                int lastSlash = fileName.lastIndexOf("/");
                if ((fileName = fileName.substring(lastSlash + 1, length = fileName.length())).length() > 123) {
                    fileName = fileName.substring(0, 123);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return fileName;
    }

    public static File getParentDir(Context context) {
        return context == null ? null : context.getExternalFilesDir(VIDEO_FOLDER);
    }

    static void clearCache(Context context) {
        Logging.out(LOG_TAG, "Clear cache");
        File parentDir = context.getExternalFilesDir(VIDEO_FOLDER);
        File[] files = new File[]{};
        if (parentDir == null) {
            return;
        }
        files = parentDir.listFiles();
        int deletedFilesCounter = 0;
        for (File file : files) {
            if (file.isDirectory() || !file.getName().endsWith(MP4_FORMAT)) continue;
            File f = new File(file.getAbsolutePath());
            f.delete();
            ++deletedFilesCounter;
        }
        Logging.out(LOG_TAG, "Deleted " + deletedFilesCounter + " file(s)");
    }
}

