/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.opengl.GLSurfaceView;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import com.loopme.IViewController;
import com.loopme.adview.AdView;
import com.loopme.common.Logging;
import com.loopme.constants.StretchOption;
import com.loopme.video360.MDVRLibrary;
import java.util.List;

public class View360Controller
implements IViewController {
    private static final String LOG_TAG = View360Controller.class.getSimpleName();
    private static final String ACCEL = "Accelerometer";
    private static final String GYRO = "Gyroscope";
    private GLSurfaceView mGLSurfaceView;
    private Callback mCallback;
    private MDVRLibrary mVRLibrary;

    public View360Controller(Callback callback) {
        this.mCallback = callback;
    }

    @Override
    public void setViewSize(int w, int h) {
    }

    @Override
    public void setVideoSize(int w, int h) {
    }

    @Override
    public void buildVideoAdView(Context context, ViewGroup bannerView, AdView adView) {
        this.mGLSurfaceView = new GLSurfaceView(context);
        bannerView.addView((View)this.mGLSurfaceView, 0);
        if (adView != null) {
            adView.setBackgroundColor(0);
            adView.setLayerType(1, null);
            if (adView.getParent() != null) {
                ((ViewGroup)adView.getParent()).removeView((View)adView);
            }
            bannerView.addView((View)adView, 1);
        }
    }

    @Override
    public void initVRLibrary(Context context) {
        if (this.mVRLibrary == null) {
            Logging.out(LOG_TAG, "initVRLibrary");
            this.mVRLibrary = MDVRLibrary.with(context).video(new MDVRLibrary.IOnSurfaceReadyCallback(){

                @Override
                public void onSurfaceReady(Surface surface) {
                    if (View360Controller.this.mCallback != null) {
                        View360Controller.this.mCallback.onSurfaceReady(surface);
                    }
                }
            }).build(this.mGLSurfaceView);
            this.checkIsAccelGyroPresented(context);
            this.mVRLibrary.setEventCallback(this.mCallback);
        }
    }

    private void checkIsAccelGyroPresented(Context context) {
        SensorManager mSensorManager = (SensorManager)context.getSystemService("sensor");
        List mSensorList = mSensorManager.getSensorList(-1);
        for (Sensor s : mSensorList) {
            if (s.getName().contains(ACCEL)) {
                this.mVRLibrary.setAccelSupported(true);
            }
            if (!s.getName().contains(GYRO)) continue;
            this.mVRLibrary.setGyroSupported(true);
        }
    }

    @Override
    public boolean handleTouchEvent(MotionEvent event) {
        return this.mVRLibrary != null && this.mVRLibrary.handleTouchEvent(event);
    }

    @Override
    public void onResume() {
        if (this.mVRLibrary != null && this.mGLSurfaceView != null && this.mVRLibrary.isPaused()) {
            Logging.out(LOG_TAG, "VRLibrary onResume");
            this.mVRLibrary.onResume(this.mGLSurfaceView.getContext());
        }
    }

    @Override
    public void onPause() {
        if (this.mVRLibrary != null && this.mGLSurfaceView != null && !this.mVRLibrary.isPaused()) {
            Logging.out(LOG_TAG, "VRLibrary onPause");
            this.mVRLibrary.onPause(this.mGLSurfaceView.getContext());
        }
    }

    @Override
    public void onDestroy() {
        if (this.mVRLibrary != null) {
            Logging.out(LOG_TAG, "VRLibrary onDestroy");
            this.mVRLibrary.onDestroy();
            this.mVRLibrary = null;
        }
    }

    @Override
    public void rebuildView(ViewGroup bannerView, AdView adView) {
        Logging.out(LOG_TAG, "rebuildView");
        if (bannerView == null || adView == null || this.mGLSurfaceView == null) {
            return;
        }
        if (this.mGLSurfaceView.getParent() != null) {
            ((ViewGroup)this.mGLSurfaceView.getParent()).removeView((View)this.mGLSurfaceView);
        }
        if (adView.getParent() != null) {
            ((ViewGroup)adView.getParent()).removeView((View)adView);
        }
        bannerView.removeAllViews();
        bannerView.addView((View)this.mGLSurfaceView, 0);
        bannerView.addView((View)adView, 1);
    }

    @Override
    public void setStretchParam(StretchOption option) {
    }

    public static interface Callback {
        public void onSurfaceReady(Surface var1);

        public void onEvent(String var1);
    }
}

