/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.common;

import android.os.Environment;
import com.loopme.common.StaticParams;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FileUtils {
    private FileUtils() {
    }

    public static void logToFile(String message, boolean append) {
        if (FileUtils.isExternalStorageAvailable() && !FileUtils.isExternalStorageReadOnly()) {
            File file = FileUtils.getCachedLogFile();
            try (FileWriter writer = new FileWriter(file, append);){
                writer.write(message + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isExternalStorageReadOnly() {
        String extStorageState = Environment.getExternalStorageState();
        return "mounted_ro".equals(extStorageState);
    }

    private static boolean isExternalStorageAvailable() {
        String extStorageState = Environment.getExternalStorageState();
        return "mounted".equals(extStorageState);
    }

    public static File getCachedLogFile() {
        File directoryPath = new File(StaticParams.sCacheDirectory);
        FileUtils.createDirectory(directoryPath);
        File logFile = new File(directoryPath, "events_log.txt");
        FileUtils.createNewFile(logFile);
        return logFile;
    }

    private static void createDirectory(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    private static void createNewFile(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

