/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.adview;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.loopme.adview.AdViewChromeClient;
import com.loopme.adview.Bridge;
import com.loopme.adview.BridgeCommandBuilder;
import com.loopme.adview.BridgeInterface;
import com.loopme.common.Logging;
import com.loopme.common.StaticParams;
import com.loopme.constants.VideoState;

public class AdView
extends WebView
implements BridgeInterface,
Bridge.Listener {
    private static final String LOG_TAG = AdView.class.getSimpleName();
    public static final String DEFAULT_CHROME_USER_AGENT = "Dalvik/2.1.0 (Linux; U; Android 7.1.1; Nexus 6P Build/NMF26F)";
    public static final String CHROME_USER_AGENT = AdView.initUserAgent();
    private Bridge.Listener mBridgeListener;
    private volatile Bridge mBridge;
    private int mCurrentVideoState = 0;
    private int mViewState = 3;

    public AdView(Context context) {
        super(context);
        Logging.out(LOG_TAG, "AdView created");
        this.init();
    }

    private static String initUserAgent() {
        String agent = System.getProperty("http.agent");
        if (TextUtils.isEmpty((CharSequence)agent)) {
            agent = DEFAULT_CHROME_USER_AGENT;
        }
        return agent;
    }

    public void scrollTo(int x, int y) {
    }

    public void computeScroll() {
    }

    protected boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
        return false;
    }

    public void addBridgeListener(Bridge.Listener listener) {
        this.mBridgeListener = listener;
    }

    private void init() {
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setPluginState(WebSettings.PluginState.ON);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        if (Build.VERSION.SDK_INT >= 19 && StaticParams.DEBUG_MODE) {
            AdView.setWebContentsDebuggingEnabled((boolean)true);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        webSettings.setSupportZoom(false);
        this.setWebChromeClient(new AdViewChromeClient());
        this.mBridge = new Bridge(this);
        this.setWebViewClient(this.mBridge);
    }

    public int getCurrentVideoState() {
        return this.mCurrentVideoState;
    }

    @Override
    public void setWebViewState(int state) {
        if (this.mViewState != state) {
            this.mViewState = state;
            String command = new BridgeCommandBuilder().webviewState(this.mViewState);
            this.loadUrl(command);
        }
    }

    @Override
    public void setFullscreenMode(boolean mode) {
        String command = new BridgeCommandBuilder().fullscreenMode(mode);
        this.loadUrl(command);
    }

    public int getCurrentWebViewState() {
        return this.mViewState;
    }

    @Override
    public void send360Event(String event) {
        String command = new BridgeCommandBuilder().event360(event);
        this.loadUrl(command);
    }

    @Override
    public void setVideoState(int state) {
        if (this.mCurrentVideoState != state) {
            this.mCurrentVideoState = state;
            Logging.out(LOG_TAG, "VIDEO : " + VideoState.toString(state));
            String command = new BridgeCommandBuilder().videoState(state);
            this.loadUrl(command);
        }
    }

    @Override
    public void setVideoDuration(int duration) {
        String command = new BridgeCommandBuilder().videoDuration(duration);
        this.loadUrl(command);
    }

    @Override
    public void setVideoCurrentTime(int currentTime) {
        String command = new BridgeCommandBuilder().videoCurrentTime(currentTime);
        this.loadUrl(command);
    }

    @Override
    public void setVideoMute(boolean mute) {
        Logging.out(LOG_TAG, "MUTE : " + mute);
        String command = new BridgeCommandBuilder().videoMute(mute);
        this.loadUrl(command);
    }

    public void shake() {
        Logging.out(LOG_TAG, "SHAKE");
        String command = new BridgeCommandBuilder().shake(true);
        this.loadUrl(command);
    }

    @Override
    public void sendNativeCallFinished() {
        String command = new BridgeCommandBuilder().isNativeCallFinished(true);
        this.loadUrl(command);
    }

    @Override
    public void onJsClose() {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onJsClose();
        }
    }

    @Override
    public void onJsLoadSuccess() {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onJsLoadSuccess();
        }
    }

    @Override
    public void onJsLoadFail(String mess) {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onJsLoadFail(mess);
        }
    }

    @Override
    public void onJsFullscreenMode(boolean isFullScreen) {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onJsFullscreenMode(isFullScreen);
        }
    }

    @Override
    public void onNonLoopMe(String url) {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onNonLoopMe(url);
        }
    }

    @Override
    public void onHtmlAdOpens() {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onHtmlAdOpens();
        }
    }

    @Override
    public void onJsVideoLoad(String videoUrl) {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onJsVideoLoad(videoUrl);
        }
    }

    @Override
    public void onJsVideoMute(boolean mute) {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onJsVideoMute(mute);
        }
    }

    @Override
    public void onJsVideoPlay(int time) {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onJsVideoPlay(time);
        }
    }

    @Override
    public void onJsVideoPause(int time) {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onJsVideoPause(time);
        }
    }

    @Override
    public void onJsVideoStretch(boolean b) {
        if (this.mBridgeListener != null) {
            this.mBridgeListener.onJsVideoStretch(b);
        }
    }
}

