/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.loopme.AdBrowserActivity;
import com.loopme.AdUtils;
import com.loopme.BaseAd;
import com.loopme.IViewController;
import com.loopme.LoopMeBanner;
import com.loopme.LoopMeBannerView;
import com.loopme.MraidController;
import com.loopme.VideoController;
import com.loopme.View360Controller;
import com.loopme.ViewController;
import com.loopme.adview.AdView;
import com.loopme.adview.BaseWebView;
import com.loopme.adview.Bridge;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.MinimizedMode;
import com.loopme.common.SwipeListener;
import com.loopme.common.Utils;
import com.loopme.common.VideoLoader;
import com.loopme.constants.StretchOption;
import com.loopme.mraid.MraidView;

public class AdController {
    private static final String LOG_TAG = AdController.class.getSimpleName();
    private static final String LEVEL1 = "level1";
    private static final String LEVEL2 = "level2";
    private static final String LEVEL3 = "level3";
    private static final String LEVEL4 = "level4";
    private static final String SLICER1 = "slicer1";
    private static final String SLICER2 = "slicer2";
    private static final String EXTRA_URL = "url";
    private BaseAd mBaseAd;
    private AdView mAdView;
    private MraidView mMraidView;
    private boolean mIsVideoPresented;
    private BaseAd mAd;
    private int mDisplayMode = 100;
    private int mPrevDisplayMode = 100;
    private MinimizedMode mMinimizedMode;
    private LoopMeBannerView mMinimizedView;
    private boolean mIsFirstFullScreenCommand = true;
    private boolean mHorizontalScrollOrientation;
    private boolean mIsBackFromExpand;
    private boolean mPostponePlay;
    private VideoLoader mVideoLoader;
    private int mPostponePlayPosition;
    private String mFileRest;
    private VideoController mVideoController;
    private IViewController mViewController;
    private MraidController mMraidController;
    private volatile Bridge.Listener mBridgeListener;
    private View.OnTouchListener mOnTouchListener;
    private boolean mHtmlAd;

    public AdController(BaseAd ad) {
        this.mBaseAd = ad;
        this.mAdView = new AdView(this.mBaseAd.getContext());
        this.mBridgeListener = this.initBridgeListener();
        this.mAdView.addBridgeListener(this.mBridgeListener);
        this.mOnTouchListener = this.initOnTouchListener();
        this.mAdView.setOnTouchListener(this.mOnTouchListener);
        if (this.mBaseAd != null) {
            this.mBaseAd.setNativeAd(true);
        }
    }

    private View.OnTouchListener initOnTouchListener() {
        return new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                AdController.this.mViewController.handleTouchEvent(event);
                return false;
            }
        };
    }

    public void initVideoController() {
        VideoController.Callback callback = this.initVideoControllerCallback();
        this.mVideoController = new VideoController(this.mAdView, callback, this.mBaseAd.getAppKey(), this.mBaseAd.getAdFormat());
    }

    public void pauseVideo() {
        if (this.mVideoController != null) {
            this.mVideoController.pauseVideo();
        }
    }

    public void initViewController() {
        if (!this.mBaseAd.getAdParams().isVideo360()) {
            ViewController.Callback viewCallback = this.initViewControllerCallback();
            this.mViewController = new ViewController(viewCallback);
        } else {
            View360Controller.Callback callback = this.initView360ControllerCallback();
            this.mViewController = new View360Controller(callback);
        }
    }

    IViewController getViewController() {
        return this.mViewController;
    }

    public void initControllers(boolean mraid) {
        if (mraid) {
            Logging.out(LOG_TAG, "initMraidController");
            this.mMraidController = new MraidController(this.mBaseAd);
        }
        this.initVideoController();
        this.initViewController();
    }

    private View360Controller.Callback initView360ControllerCallback() {
        return new View360Controller.Callback(){

            @Override
            public void onSurfaceReady(Surface surface) {
                Logging.out(LOG_TAG, "onSurfaceReady ####");
                AdController.this.mVideoController.setSurface(surface);
            }

            @Override
            public void onEvent(String event) {
                if (AdController.this.mAdView != null) {
                    AdController.this.mAdView.send360Event(event);
                }
            }
        };
    }

    private ViewController.Callback initViewControllerCallback() {
        return new ViewController.Callback(){

            @Override
            public void onSurfaceTextureAvailable(SurfaceTexture surface) {
                AdController.this.surfaceTextureAvailable(surface);
            }

            @Override
            public void onSurfaceTextureDestroyed() {
                AdController.this.surfaceTextureDestroyed();
            }
        };
    }

    private VideoController.Callback initVideoControllerCallback() {
        return new VideoController.Callback(){

            @Override
            public void onVideoReachEnd() {
                AdController.this.mBaseAd.onAdVideoDidReachEnd();
            }

            @Override
            public void onFail(LoopMeError error) {
                AdController.this.mBaseAd.onAdLoadFail(error);
            }

            @Override
            public void onVideoSizeChanged(int width, int height) {
                AdController.this.mViewController.setVideoSize(width, height);
            }

            @Override
            public void onPostponePlay(int position) {
                AdController.this.mPostponePlay = true;
                AdController.this.mPostponePlayPosition = position;
            }

            @Override
            public void onPlaybackFinishedWithError() {
                if (AdController.this.mBaseAd.getAdFormat() == 1000) {
                    ((LoopMeBanner)AdController.this.mBaseAd).playbackFinishedWithError();
                }
            }
        };
    }

    void resetFullScreenCommandCounter() {
        this.mIsFirstFullScreenCommand = true;
    }

    void destroy() {
        this.mBridgeListener = null;
        if (this.mVideoController != null) {
            this.mVideoController.destroy();
        }
        if (this.mVideoLoader != null) {
            this.mVideoLoader.stop();
        }
        if (this.mAdView != null) {
            this.mAdView.stopLoading();
            this.mAdView.clearCache(true);
            this.mAdView = null;
        }
        if (this.mMraidView != null) {
            this.mMraidView.stopLoading();
            this.mMraidView.clearCache(true);
            this.mMraidView = null;
        }
        this.mMinimizedMode = null;
    }

    public void setWebViewState(int state) {
        if (this.mAdView != null) {
            this.mAdView.setWebViewState(state);
        }
    }

    public void setMraidWebViewState(int state) {
        if (this.mMraidView != null) {
            this.mMraidView.setWebViewState(state);
        }
    }

    void onAdShake() {
        if (this.mAdView != null) {
            this.mAdView.shake();
        }
    }

    int getCurrentVideoState() {
        if (this.mAdView != null) {
            return this.mAdView.getCurrentVideoState();
        }
        return -1;
    }

    public int getCurrentDisplayMode() {
        return this.mDisplayMode;
    }

    void buildStaticAdView(ViewGroup bannerView) {
        if (bannerView == null || this.mAdView == null) {
            return;
        }
        this.mAdView.setBackgroundColor(-16777216);
        bannerView.addView((View)this.mAdView);
    }

    void ensureAdIsVisible(View view) {
        int rectHeight;
        if (this.mAdView == null || view == null) {
            return;
        }
        Rect rect = new Rect();
        boolean b = view.getGlobalVisibleRect(rect);
        int halfOfView = this.mHorizontalScrollOrientation ? view.getWidth() / 2 : view.getHeight() / 2;
        int n = rectHeight = this.mHorizontalScrollOrientation ? rect.width() : rect.height();
        if (b) {
            if (rectHeight < halfOfView) {
                this.setWebViewState(2);
                this.mIsBackFromExpand = false;
            } else if (rectHeight >= halfOfView) {
                this.setWebViewState(1);
            }
        } else {
            this.setWebViewState(2);
        }
    }

    void buildMraidContainer(ViewGroup bannerView) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        bannerView.addView((View)this.mMraidView, (ViewGroup.LayoutParams)layoutParams);
    }

    void buildVideoAdView(ViewGroup bannerView) {
        if (this.mViewController != null) {
            this.mViewController.buildVideoAdView(this.mBaseAd.getContext(), bannerView, this.mAdView);
        }
    }

    void rebuildView(ViewGroup bannerView) {
        if (this.mViewController != null) {
            this.mViewController.rebuildView(bannerView, this.mAdView);
        }
    }

    private void storePreviousMode(int displayMode) {
        this.mPrevDisplayMode = displayMode == 102 ? 102 : (displayMode == 101 ? 101 : 100);
    }

    boolean isBackFromExpand() {
        return this.mIsBackFromExpand;
    }

    void switchToMinimizedMode() {
        if (this.mDisplayMode == 101) {
            if (this.getCurrentVideoState() == 3) {
                this.setWebViewState(1);
            }
            return;
        }
        Logging.out(LOG_TAG, "switch to minimized mode");
        this.storePreviousMode(this.mDisplayMode);
        this.mDisplayMode = 101;
        int width = this.mMinimizedMode.getWidth();
        int height = this.mMinimizedMode.getHeight();
        this.mMinimizedView = new LoopMeBannerView(this.mAdView.getContext(), width, height);
        this.mViewController.rebuildView((ViewGroup)this.mMinimizedView, this.mAdView);
        this.addBordersToView(this.mMinimizedView);
        this.mViewController.onResume();
        if (this.mAdView.getCurrentWebViewState() == 2) {
            this.mMinimizedView.setAlpha(0.0f);
        }
        this.mMinimizedMode.getRootView().addView((View)this.mMinimizedView);
        this.configMinimizedViewLayoutParams(this.mMinimizedView);
        this.setWebViewState(1);
        this.mAdView.setOnTouchListener(new SwipeListener(width, new SwipeListener.Listener(){

            @Override
            public void onSwipe(boolean toRight) {
                AdController.this.mAdView.setWebViewState(2);
                Animation anim = AnimationUtils.makeOutAnimation((Context)AdController.this.mBaseAd.getContext(), (boolean)toRight);
                anim.setDuration(200L);
                AdController.this.mMinimizedView.startAnimation(anim);
                AdController.this.switchToNormalMode();
                AdController.this.mMinimizedMode = null;
            }
        }));
    }

    private void configMinimizedViewLayoutParams(LoopMeBannerView bannerView) {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)bannerView.getLayoutParams();
        lp.addRule(12);
        lp.addRule(11);
        lp.bottomMargin = this.mMinimizedMode.getMarginBottom();
        lp.rightMargin = this.mMinimizedMode.getMarginRight();
        bannerView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    @SuppressLint(value={"NewApi"})
    private void addBordersToView(LoopMeBannerView bannerView) {
        ShapeDrawable drawable = new ShapeDrawable((Shape)new RectShape());
        drawable.getPaint().setColor(-16777216);
        drawable.getPaint().setStyle(Paint.Style.FILL_AND_STROKE);
        drawable.getPaint().setAntiAlias(true);
        bannerView.setPadding(2, 2, 2, 2);
        if (Build.VERSION.SDK_INT < 16) {
            bannerView.setBackgroundDrawable((Drawable)drawable);
        } else {
            bannerView.setBackground((Drawable)drawable);
        }
    }

    void switchToNormalMode() {
        if (this.mDisplayMode == 100) {
            return;
        }
        Logging.out(LOG_TAG, "switch to normal mode");
        if (this.mDisplayMode == 102) {
            this.mIsBackFromExpand = true;
        }
        this.storePreviousMode(this.mDisplayMode);
        this.mDisplayMode = 100;
        LoopMeBannerView initialView = ((LoopMeBanner)this.mBaseAd).getBannerView();
        initialView.setVisibility(0);
        this.mViewController.rebuildView((ViewGroup)initialView, this.mAdView);
        if (this.mMinimizedView != null && this.mMinimizedView.getParent() != null) {
            ((ViewGroup)this.mMinimizedView.getParent()).removeView((View)this.mMinimizedView);
            this.mMinimizedView.removeAllViews();
        }
    }

    public void setMinimizedMode(MinimizedMode mode) {
        this.mMinimizedMode = mode;
    }

    boolean isMinimizedModeEnable() {
        return this.mMinimizedMode != null && this.mMinimizedMode.getRootView() != null;
    }

    void destroyMinimizedView() {
        if (this.mMinimizedView != null) {
            if (this.mMinimizedView.getParent() != null) {
                ((ViewGroup)this.mMinimizedView.getParent()).removeView((View)this.mMinimizedView);
            }
            this.mMinimizedView.removeAllViews();
            this.mMinimizedView = null;
        }
    }

    void preloadHtml(String html, boolean mraid) {
        if (mraid) {
            this.mMraidView = new MraidView(this.mBaseAd.getContext(), this.mMraidController);
            this.mMraidView.loadDataWithBaseURL("file:///android_asset/", html, "text/html", "UTF-8", null);
        } else if (this.mAdView != null) {
            this.preloadAd(html);
        } else {
            this.mBaseAd.onAdLoadFail(new LoopMeError("Html loading error"));
        }
    }

    private void preloadAd(String html) {
        if (this.mBaseAd.getAdFormat() == 1001) {
            this.dummyPreloadHtml(html);
        } else {
            this.loadHtml(html);
        }
    }

    MraidView getMraidView() {
        return this.mMraidView;
    }

    public boolean isVideoPresented() {
        return this.mIsVideoPresented;
    }

    private Bridge.Listener initBridgeListener() {
        return new Bridge.Listener(){

            @Override
            public void onJsVideoPlay(int time) {
                AdController.this.handleVideoPlay(time);
            }

            @Override
            public void onJsVideoPause(int time) {
                AdController.this.handleVideoPause(time);
            }

            @Override
            public void onJsVideoMute(boolean mute) {
                AdController.this.handleVideoMute(mute);
            }

            @Override
            public void onJsVideoLoad(String videoUrl) {
                AdController.this.handleVideoLoad(videoUrl);
            }

            @Override
            public void onJsLoadSuccess() {
                AdController.this.handleLoadNoneHtmlAdSuccess();
            }

            @Override
            public void onJsClose() {
                AdController.this.handleClose();
            }

            @Override
            public void onJsLoadFail(String mess) {
                AdController.this.handleLoadFail(mess);
            }

            @Override
            public void onJsFullscreenMode(boolean isFullScreen) {
                AdController.this.handleFullscreenMode(isFullScreen);
            }

            @Override
            public void onNonLoopMe(String url) {
                AdController.this.handleNonLoopMe(url);
            }

            @Override
            public void onHtmlAdOpens() {
                if (AdController.this.isHtmlAd()) {
                    AdController.this.setWebViewState(1);
                }
            }

            @Override
            public void onJsVideoStretch(boolean b) {
                AdController.this.handleVideoStretch(b);
            }
        };
    }

    private void handleLoadHtmlAdSuccess() {
        if (this.isHtmlAd()) {
            this.handleLoadSuccess();
        }
    }

    private void handleLoadNoneHtmlAdSuccess() {
        if (!this.isHtmlAd()) {
            this.handleLoadSuccess();
        }
    }

    private void handleLoadSuccess() {
        this.mBaseAd.startExpirationTimer();
        this.mBaseAd.onAdLoadSuccess();
    }

    private void handleLoadFail(String message) {
        if (this.mBaseAd != null) {
            this.mBaseAd.onAdLoadFail(new LoopMeError("Failed to process ad" + message));
        }
    }

    private void handleVideoLoad(String videoUrl) {
        Logging.out(LOG_TAG, "JS command: load video " + videoUrl);
        this.mIsVideoPresented = true;
        boolean preload = this.mBaseAd.getAdParams().getPartPreload();
        this.mVideoController.contain360(this.mBaseAd.getAdParams().isVideo360());
        this.loadVideoFile(videoUrl, this.mBaseAd.getContext(), preload);
    }

    private void loadVideoFile(String videoUrl, Context context, final boolean preload) {
        this.mVideoLoader = new VideoLoader(videoUrl, preload, context, new VideoLoader.Callback(){

            @Override
            public void onError(LoopMeError error) {
                AdController.this.sendLoadFail(error);
            }

            @Override
            public void onPreviewLoaded(String filePath) {
                Logging.out(LOG_TAG, "onPreviewLoaded");
                AdController.this.mVideoController.initPlayerFromFile(filePath);
            }

            @Override
            public void onFullVideoLoaded(String filePath) {
                Logging.out(LOG_TAG, "onFullVideoLoaded: " + filePath);
                if (preload) {
                    if (AdController.this.mBaseAd.isShowing()) {
                        AdController.this.mFileRest = filePath;
                        AdController.this.mVideoController.setFileRest(AdController.this.mFileRest);
                        AdController.this.mVideoController.waitForVideo();
                    } else {
                        AdController.this.mVideoController.releasePlayer();
                        AdController.this.mVideoController.initPlayerFromFile(filePath);
                    }
                } else {
                    AdController.this.mVideoController.initPlayerFromFile(filePath);
                }
            }
        });
        this.mVideoLoader.start();
    }

    private void sendLoadFail(LoopMeError error) {
        if (this.mBaseAd != null) {
            this.mBaseAd.onAdLoadFail(error);
        }
    }

    private void handleVideoMute(boolean mute) {
        if (this.mAdView != null) {
            this.mAdView.setVideoMute(mute);
        }
        if (this.mVideoController != null) {
            this.mVideoController.muteVideo(mute);
        }
    }

    private void handleVideoPlay(int time) {
        if (this.mVideoController != null) {
            this.mVideoController.playVideo(time, this.mBaseAd.getAdParams().isVideo360());
        }
        if (this.mDisplayMode == 101) {
            Utils.animateAppear((View)this.mMinimizedView);
        }
    }

    private void handleVideoPause(int time) {
        this.mVideoController.pauseVideo();
    }

    private void handleClose() {
        this.mBaseAd.dismiss();
    }

    private void handleVideoStretch(boolean b) {
        Logging.out(LOG_TAG, "JS command: stretch video ");
        StretchOption stretch = b ? StretchOption.STRETCH : StretchOption.NO_STRETCH;
        this.mViewController.setStretchParam(stretch);
    }

    private void handleFullscreenMode(boolean b) {
        if (this.mIsFirstFullScreenCommand) {
            this.mIsFirstFullScreenCommand = false;
            this.mAdView.setFullscreenMode(false);
            return;
        }
        if (b) {
            this.switchToFullScreenMode();
        } else {
            this.broadcastDestroyIntent();
        }
        this.mAdView.setFullscreenMode(b);
    }

    private void broadcastDestroyIntent() {
        Intent intent = new Intent();
        intent.setAction("com.loopme.DESTROY_INTENT");
        this.mBaseAd.getContext().sendBroadcast(intent);
    }

    private void switchToFullScreenMode() {
        if (this.mDisplayMode != 102) {
            Logging.out(LOG_TAG, "switch to fullscreen mode");
            this.storePreviousMode(this.mDisplayMode);
            this.mDisplayMode = 102;
            if (this.mPrevDisplayMode == 101 && this.mMinimizedView != null && this.mMinimizedView.getParent() != null) {
                ((ViewGroup)this.mMinimizedView.getParent()).removeView((View)this.mMinimizedView);
            }
            AdUtils.startAdActivity(this.mBaseAd);
        }
    }

    void switchToPreviousMode() {
        if (this.mPrevDisplayMode == 101) {
            this.switchToMinimizedMode();
        } else if (this.mPrevDisplayMode == 100) {
            this.switchToNormalMode();
        }
    }

    private void handleNonLoopMe(String url) {
        Logging.out(LOG_TAG, "Non Js command");
        Context context = this.mBaseAd.getContext();
        if (Utils.isOnline(context)) {
            Intent intent = new Intent(context, AdBrowserActivity.class);
            intent.putExtra(EXTRA_URL, url);
            intent.putExtra("appkey", this.mBaseAd.getAppKey());
            intent.putExtra("format", this.mBaseAd.getAdFormat());
            intent.addFlags(0x10000000);
            this.mBaseAd.onAdClicked();
            this.setWebViewState(2);
            this.broadcastAdClickedIntent();
            context.startActivity(intent);
        } else {
            Logging.out(LOG_TAG, "No internet connection");
        }
    }

    private void broadcastAdClickedIntent() {
        Intent intent = new Intent();
        intent.setAction("com.loopme.CLICK_INTENT");
        this.mBaseAd.getContext().sendBroadcast(intent);
    }

    private void surfaceTextureAvailable(SurfaceTexture surface) {
        Logging.out(LOG_TAG, "onSurfaceTextureAvailable");
        this.mVideoController.setSurfaceTextureAvailable(true);
        if (this.mPostponePlay) {
            this.mVideoController.playVideo(this.mPostponePlayPosition, this.mBaseAd.getAdParams().isVideo360());
            this.mPostponePlay = false;
        }
        int viewWidth = 0;
        int viewHeight = 0;
        switch (this.mDisplayMode) {
            case 101: {
                if (this.mMinimizedMode != null) {
                    viewWidth = this.mMinimizedMode.getWidth();
                    viewHeight = this.mMinimizedMode.getHeight();
                    break;
                }
                Logging.out(LOG_TAG, "WARNING: MinimizedMode is null");
                break;
            }
            case 100: {
                viewWidth = this.mBaseAd.detectWidth();
                viewHeight = this.mBaseAd.detectHeight();
                break;
            }
            case 102: {
                viewWidth = Utils.getScreenWidth();
                viewHeight = Utils.getScreenHeight();
                break;
            }
            default: {
                Logging.out(LOG_TAG, "Unknown display mode");
            }
        }
        try {
            Surface s = new Surface(surface);
            this.mVideoController.setSurface(s);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        this.mViewController.setViewSize(viewWidth, viewHeight);
    }

    private boolean surfaceTextureDestroyed() {
        Logging.out(LOG_TAG, "onSurfaceTextureDestroyed");
        this.mVideoController.setSurfaceTextureAvailable(false);
        try {
            this.mVideoController.setSurface(null);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void loadHtmlAdToWebView(String html, boolean mraid) {
        if (!mraid && this.mBaseAd.getAdFormat() == 1001 && this.isHtmlAd()) {
            this.loadHtml(html);
        }
    }

    private void loadHtml(String html) {
        if (this.mAdView != null) {
            this.mAdView.loadDataWithBaseURL(null, html, "text/html", "UTF-8", null);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void dummyPreloadHtml(String html) {
        BaseWebView dummyWebView = new BaseWebView(this.mBaseAd.getContext());
        dummyWebView.enableJavascriptCaching();
        dummyWebView.setWebViewClient(new WebViewClient(){
            private static final String WEBVIEW_HTML_AD = "loopme://webview/success";
            private static final String WEBVIEW_FAIL = "loopme://webview/fail";

            public boolean shouldOverrideUrlLoading(WebView webView, String url) {
                if (TextUtils.equals((CharSequence)url, (CharSequence)WEBVIEW_HTML_AD)) {
                    AdController.this.mHtmlAd = true;
                    AdController.this.handleLoadHtmlAdSuccess();
                } else if (TextUtils.equals((CharSequence)url, (CharSequence)WEBVIEW_FAIL)) {
                    AdController.this.handleLoadFail("Ad received specific URL loopme://webview/fail");
                } else {
                    AdController.this.loadHtmlRunnable(AdController.this.mBaseAd.getAdParams().getHtml());
                }
                webView.stopLoading();
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                if (AdController.this.mBridgeListener != null) {
                    AdController.this.mBridgeListener.onJsLoadFail("onReceivedError " + description);
                }
            }
        });
        dummyWebView.loadDataWithBaseURL(null, html, "text/html", "UTF-8", null);
    }

    public boolean isHtmlAd() {
        return this.mHtmlAd;
    }

    private void loadHtmlRunnable(final String html) {
        this.mBaseAd.mHandler.post(new Runnable(){

            @Override
            public void run() {
                AdController.this.loadHtml(html);
            }
        });
    }

    public AdView getAdView() {
        return this.mAdView;
    }

    public MraidController getMraidController() {
        return this.mMraidController;
    }

    public void resumeVideo() {
        if (this.mVideoController != null) {
            this.mVideoController.resumeVideo();
        }
    }

    public int getWebViewState() {
        if (this.mAdView != null) {
            return this.mAdView.getCurrentWebViewState();
        }
        return 3;
    }
}

