package com.loopme.common;

public class Base64Drawables {

    private final String BTN_BACK_ACTIVE = "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";
    private final String BTN_BACK_INACTIVE = "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";
    private final String BTN_REFRESH = "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";
    private final String BTN_NATIVE_BROWSER = "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";
    private final String BTN_CLOSE = "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";

    private final String BTN_MUTE = "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";
    private final String BTN_UNMUTE = "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";

    public String getBackActive() {
        return BTN_BACK_ACTIVE;
    }

    public String getBackInactive() {
        return BTN_BACK_INACTIVE;
    }

    public String getRefresh() {
        return BTN_REFRESH;
    }

    public String getNativeBrowser() {
        return BTN_NATIVE_BROWSER;
    }

    public String getClose() {
        return BTN_CLOSE;
    }

    public String getMute() {
        return BTN_MUTE;
    }

    public String getUnmute() {
        return BTN_UNMUTE;
    }
}