/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.video360.strategy.interactive;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import android.view.MotionEvent;
import android.view.WindowManager;
import com.loopme.video360.MD360Director;
import com.loopme.video360.common.VRUtil;
import com.loopme.video360.strategy.interactive.AbsInteractiveStrategy;
import java.util.List;

public class MotionStrategy
extends AbsInteractiveStrategy
implements SensorEventListener {
    private static final String TAG = "MotionStrategy";
    private int mDeviceRotation;
    private float[] mSensorMatrix = new float[16];
    private boolean mRegistered = false;

    public MotionStrategy(List<MD360Director> directorList) {
        super(directorList);
    }

    @Override
    public void onResume(Context context) {
        this.registerSensor(context);
    }

    @Override
    public void onPause(Context context) {
        this.unregisterSensor(context);
    }

    @Override
    public boolean handleTouchEvent(MotionEvent event) {
        boolean handled = false;
        for (MD360Director director : this.getDirectorList()) {
            handled |= director.handleTouchEvent(event);
        }
        return handled;
    }

    @Override
    public void on(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        this.mDeviceRotation = wm.getDefaultDisplay().getRotation();
    }

    @Override
    public void off(Context context) {
        this.unregisterSensor(context);
    }

    protected void registerSensor(Context context) {
        if (this.mRegistered) {
            return;
        }
        SensorManager mSensorManager = (SensorManager)context.getSystemService("sensor");
        Sensor sensor = mSensorManager.getDefaultSensor(11);
        if (sensor == null) {
            Log.e((String)TAG, (String)"TYPE_ROTATION_VECTOR sensor not support!");
            return;
        }
        mSensorManager.registerListener((SensorEventListener)this, sensor, 2);
        this.mRegistered = true;
    }

    protected void unregisterSensor(Context context) {
        if (!this.mRegistered) {
            return;
        }
        SensorManager mSensorManager = (SensorManager)context.getSystemService("sensor");
        mSensorManager.unregisterListener((SensorEventListener)this);
        this.mRegistered = false;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.accuracy != 0) {
            int type = event.sensor.getType();
            switch (type) {
                case 11: {
                    VRUtil.sensorRotationVector2Matrix(event, this.mDeviceRotation, this.mSensorMatrix);
                    float[] orientation = new float[3];
                    SensorManager.getOrientation((float[])this.mSensorMatrix, (float[])orientation);
                    for (MD360Director director : this.getDirectorList()) {
                        director.updateSensorInfo(orientation);
                    }
                    break;
                }
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

