/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.video360.objects;

import android.content.Context;
import android.opengl.GLES20;
import com.loopme.R;
import com.loopme.video360.MD360Program;
import com.loopme.video360.common.GLUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class MDSphere3D {
    private static final int sPositionDataSize = 3;
    private FloatBuffer mVerticesBuffer;
    private FloatBuffer mTexCoordinateBuffer;
    private int mNumIndices;

    public void uploadDataToProgram(MD360Program program) {
        FloatBuffer vertexBuffer = this.getVerticesBuffer();
        FloatBuffer textureBuffer = this.getTexCoordinateBuffer();
        vertexBuffer.position(0);
        textureBuffer.position(0);
        int positionHandle = program.getPositionHandle();
        GLES20.glVertexAttribPointer((int)positionHandle, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)positionHandle);
        int textureCoordinateHandle = program.getTextureCoordinateHandle();
        GLES20.glVertexAttribPointer((int)textureCoordinateHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureBuffer);
        GLES20.glEnableVertexAttribArray((int)textureCoordinateHandle);
    }

    public void loadObj(Context context) {
        GLUtil.loadObject3D(context, this.obtainObjResId(), this);
    }

    protected int obtainObjResId() {
        return R.raw.sphere;
    }

    public int getNumIndices() {
        return this.mNumIndices;
    }

    public void setNumIndices(int mNumIndices) {
        this.mNumIndices = mNumIndices;
    }

    public FloatBuffer getVerticesBuffer() {
        return this.mVerticesBuffer;
    }

    public void setVerticesBuffer(FloatBuffer verticesBuffer) {
        this.mVerticesBuffer = verticesBuffer;
    }

    public FloatBuffer getTexCoordinateBuffer() {
        return this.mTexCoordinateBuffer;
    }

    public void setTexCoordinateBuffer(FloatBuffer texCoordinateBuffer) {
        this.mTexCoordinateBuffer = texCoordinateBuffer;
    }
}

