/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.video360;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import com.loopme.video360.MD360Director;
import com.loopme.video360.MD360Program;
import com.loopme.video360.MDStatusManager;
import com.loopme.video360.common.GLUtil;
import com.loopme.video360.objects.MDSphere3D;
import com.loopme.video360.texture.MD360Texture;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class MD360Renderer
implements GLSurfaceView.Renderer,
MD360Texture.ISyncDrawCallback {
    private static final String TAG = "MD360Renderer";
    private MDSphere3D mObject3D;
    private MD360Program mProgram;
    private MD360Texture mTexture;
    private final Context mContext;
    private final MD360Director mDirector;
    private MDStatusManager.Status mStatus;

    private MD360Renderer(Builder params) {
        this.mContext = params.context;
        this.mTexture = params.texture;
        this.mDirector = params.director;
        this.mObject3D = new MDSphere3D();
        this.mProgram = new MD360Program(params.contentType);
    }

    public void onSurfaceCreated(GL10 glUnused, EGLConfig config) {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glEnable((int)2884);
        GLES20.glEnable((int)2929);
        this.initProgram();
        this.initTexture();
        this.initObject3D();
    }

    public void onSurfaceChanged(GL10 glUnused, int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        this.mTexture.resize(width, height);
        this.mDirector.updateProjection(width, height);
    }

    public void onDrawFrame(GL10 glUnused) {
        GLES20.glClear((int)16640);
        if (this.mStatus == null) {
            return;
        }
        if (this.mStatus.isAllReady()) {
            this.mTexture.syncDrawInContext(this);
        } else {
            this.mStatus.ready();
        }
    }

    @Override
    public void onDrawOpenGL() {
        this.mProgram.use();
        GLUtil.glCheck("mProgram use");
        GLES20.glUniform1i((int)this.mProgram.getTextureUniformHandle(), (int)0);
        GLUtil.glCheck("glUniform1i");
        this.mDirector.shot(this.mProgram);
        GLES20.glDrawArrays((int)4, (int)0, (int)this.mObject3D.getNumIndices());
    }

    private void initProgram() {
        this.mProgram.build(this.mContext);
    }

    private void initTexture() {
        this.mTexture.create();
    }

    private void initObject3D() {
        this.mObject3D.loadObj(this.mContext);
        this.mObject3D.uploadDataToProgram(this.mProgram);
    }

    public static Builder with(Context context) {
        Builder builder = new Builder();
        builder.context = context;
        return builder;
    }

    public void setStatus(MDStatusManager.Status mStatus) {
        this.mStatus = mStatus;
    }

    public static class Builder {
        private Context context;
        private MD360Texture texture;
        private MD360Director director;
        private int contentType = 0;

        private Builder() {
        }

        public MD360Renderer build() {
            if (this.director == null) {
                this.director = MD360Director.builder().build();
            }
            return new MD360Renderer(this);
        }

        public Builder setContentType(int contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setTexture(MD360Texture texture) {
            this.texture = texture;
            return this;
        }

        public Builder setDirector(MD360Director director) {
            this.director = director;
            return this;
        }
    }
}

