/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.data;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Base64;
import com.loopme.common.Logging;
import com.loopme.data.LoopMeReceiver;
import com.loopme.request.AdRequestParametersProvider;
import com.loopme.tasks.AdvIdFetcher;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class DataCollector {
    private static final String LOG_TAG = "data";
    private static final String URL = "http://loopme.me/api/v2/events?et=INFO";
    private static final String PARAM_CONNECTION_TYPE = "ct";
    private static final String PARAM_LANGUAGE = "lng";
    private static final String PARAM_SDK_VERSION = "sv";
    private static final String PARAM_APP_VERSION = "av";
    private static final String PARAM_MRAID = "mr";
    private static final String PARAM_ORIENTATION = "or";
    private static final String PARAM_VIEWER_TOKEN = "vt";
    private static final String PARAM_DNT = "dnt";
    private static final String PARAM_LATITUDE = "lat";
    private static final String PARAM_LONGITUDE = "lon";
    private static final String PARAM_CARRIER = "carrier";
    private static final String PARAM_BUNDLE_ID = "bundleid";
    private static final String PARAM_WIFI_NAME = "wn";
    private static final String PARAM_OLD_VIEWER_TOKEN = "ovt";
    private static final String PARAM_ACCOUNT_NAME = "an";
    private static final String PARAM_IMEI = "imei";
    private static final byte[] encryptionKey = new byte[]{-6, 98, 68, -94, -105, -92, -70, 3, 46, -119, -34, -101, 119, -13, -94, -7};
    private static AlarmManager mAlarmManager;
    private static PendingIntent mAlarmIntent;
    private static boolean sStarted;
    private long mInterval;
    private static DataCollector sDataCollector;
    private Context mContext;
    private String mCurrentId;
    private String mOldId;

    public static DataCollector getInstance(Context context) {
        if (sDataCollector == null) {
            sDataCollector = new DataCollector(context);
        }
        return sDataCollector;
    }

    private DataCollector(Context context) {
        this.mContext = context;
        mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        if (mAlarmManager == null) {
            Logging.out(LOG_TAG, "AlarmManager not available");
            return;
        }
        Intent intent = new Intent(context, LoopMeReceiver.class);
        mAlarmIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        final SharedPreferences sp = context.getSharedPreferences("loopme", 0);
        String viewerToken = sp.getString("viewer_token", "");
        if (TextUtils.isEmpty((CharSequence)viewerToken)) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(new AdvIdFetcher(context, new AdvIdFetcher.Listener(){

                @Override
                public void onComplete(String advId, boolean isLimited) {
                    sp.edit().putString("viewer_token", advId).apply();
                }
            }));
        }
    }

    private List<String> detectAccounts(Context context) {
        ArrayList<String> result = new ArrayList<String>();
        int permissionCheck = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.GET_ACCOUNTS");
        if (permissionCheck == 0) {
            Account[] accounts;
            AccountManager am = AccountManager.get((Context)context);
            for (Account acc : accounts = am.getAccountsByType("com.google")) {
                result.add(acc.name);
            }
        }
        return result;
    }

    public void onReceive(String oldId) {
        final List<String> accounts = this.detectAccounts(this.mContext);
        this.mOldId = oldId;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(new AdvIdFetcher(this.mContext, new AdvIdFetcher.Listener(){

            @Override
            public void onComplete(String advId, boolean isLimited) {
                DataCollector.this.mCurrentId = advId;
                if (TextUtils.isEmpty((CharSequence)DataCollector.this.mCurrentId)) {
                    return;
                }
                Map params = DataCollector.this.initPostDataParams(DataCollector.this.mOldId, DataCollector.this.mCurrentId, accounts);
                DataCollector.this.postDataToServer(params);
            }
        }));
    }

    private Map<String, String> initPostDataParams(String oldId, String currentId, List<String> accounts) {
        String deviceId;
        String wifiName;
        String carrier;
        String longitude;
        String latitude;
        AdRequestParametersProvider provider = AdRequestParametersProvider.getInstance();
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put(PARAM_CONNECTION_TYPE, String.valueOf(provider.getConnectionType(this.mContext)));
        params.put(PARAM_LANGUAGE, provider.getLanguage());
        params.put(PARAM_SDK_VERSION, "5.0");
        params.put(PARAM_APP_VERSION, provider.getAppVersion(this.mContext));
        params.put(PARAM_MRAID, provider.getMraidSupport());
        params.put(PARAM_ORIENTATION, provider.getOrientation(this.mContext));
        params.put(PARAM_BUNDLE_ID, this.mContext.getPackageName());
        params.put(PARAM_VIEWER_TOKEN, currentId);
        if (!TextUtils.isEmpty((CharSequence)oldId) && !currentId.equalsIgnoreCase(oldId)) {
            params.put(PARAM_OLD_VIEWER_TOKEN, oldId);
        }
        if (accounts != null && accounts.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < accounts.size(); ++i) {
                sb.append(accounts.get(i));
                if (i >= accounts.size() - 1) continue;
                sb.append(",");
            }
            if (sb.length() != 0) {
                params.put(PARAM_ACCOUNT_NAME, sb.toString());
            }
        }
        if ((latitude = provider.getLatitude()) != null) {
            params.put(PARAM_LATITUDE, latitude);
        }
        if ((longitude = provider.getLongitude()) != null) {
            params.put(PARAM_LONGITUDE, longitude);
        }
        if ((carrier = provider.getCarrier(this.mContext)) != null) {
            params.put(PARAM_CARRIER, carrier);
        }
        String dntValue = provider.isDntPresent() ? "1" : "0";
        params.put(PARAM_DNT, dntValue);
        if (provider.isWifiInfoAvailable(this.mContext) && !TextUtils.isEmpty((CharSequence)(wifiName = provider.getWifiName(this.mContext)))) {
            params.put(PARAM_WIFI_NAME, wifiName);
        }
        if (!TextUtils.isEmpty((CharSequence)(deviceId = provider.getDeviceId(this.mContext)))) {
            params.put(PARAM_IMEI, deviceId);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postDataToServer(Map<String, String> params) {
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL("http://loopme.me/api/v2/events?et=INFO&vt=" + params.get(PARAM_VIEWER_TOKEN));
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            OutputStream os = urlConnection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            String data = DataCollector.getPostDataString(params);
            String base64encryptedData = DataCollector.encodeData(data);
            writer.write(base64encryptedData);
            writer.flush();
            writer.close();
            os.close();
            urlConnection.connect();
            int code = urlConnection.getResponseCode();
            Logging.out(LOG_TAG, "response code : " + code);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            Logging.out(LOG_TAG, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            Logging.out(LOG_TAG, e.getMessage());
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static String encodeData(String initMessage) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(encryptionKey, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, keySpec);
            return Base64.encodeToString((byte[])cipher.doFinal(initMessage.getBytes()), (int)0);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            return null;
        }
    }

    private static String getPostDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }

    public void start() {
        if (mAlarmManager != null && !sStarted) {
            Logging.out(LOG_TAG, "start");
            if (this.mInterval >= 0L) {
                this.mInterval = 900000L;
            }
            mAlarmManager.setInexactRepeating(1, System.currentTimeMillis(), this.mInterval, mAlarmIntent);
            sStarted = true;
        }
    }

    public void setInterval(long milliseconds) {
        this.mInterval = milliseconds;
    }

    public void cancel() {
        if (mAlarmManager != null) {
            Logging.out(LOG_TAG, "cancel");
            mAlarmManager.cancel(mAlarmIntent);
        }
    }
}

