/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.common;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.loopme.common.ExecutorHelper;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.StaticParams;
import com.loopme.common.VideoUtils;
import com.loopme.debugging.ErrorTracker;
import com.loopme.request.AdRequestParametersProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class VideoLoader {
    private static final String LOG_TAG = VideoLoader.class.getSimpleName();
    private static final int TIMEOUT = 20000;
    private Callback mCallback;
    private Context mContext;
    private String mVideoUrl;
    private boolean mPartPreload;
    private File mVideoFile;
    private String mShortFileName;
    private int lenghtOfPreview;
    private volatile HttpURLConnection mConnection;
    private volatile boolean mIsVideoFullyDownloaded;
    private volatile boolean mStop;
    private FileOutputStream mOutputStream;

    public VideoLoader(@NonNull String videoUrl, boolean preload, @NonNull Context context, @NonNull Callback callback) {
        this.mCallback = callback;
        this.mContext = context;
        this.mVideoUrl = videoUrl;
        this.mPartPreload = preload;
    }

    public void start() {
        Logging.out(LOG_TAG, "start");
        Logging.out(LOG_TAG, "Use mobile network for caching: " + StaticParams.USE_MOBILE_NETWORK_FOR_CACHING);
        VideoUtils.deleteInvalidVideoFiles(this.mContext);
        this.mShortFileName = VideoUtils.detectFileName(this.mVideoUrl) + ".mp4";
        File f = VideoUtils.checkFileNotExists(this.mShortFileName, this.mContext);
        if (f != null) {
            Logging.out(LOG_TAG, "Video file already exists");
            if (this.mCallback != null) {
                this.mCallback.onFullVideoLoaded(VideoUtils.getParentDir(this.mContext).getAbsolutePath() + "/" + this.mShortFileName);
            }
            return;
        }
        int connectiontype = AdRequestParametersProvider.getInstance().getConnectionType(this.mContext);
        if (connectiontype == 2) {
            this.preloadVideo(this.mPartPreload);
        } else if (StaticParams.USE_MOBILE_NETWORK_FOR_CACHING) {
            this.preloadVideo(this.mPartPreload);
        } else if (this.mCallback != null) {
            this.mCallback.onError(new LoopMeError("Mobile network. Video will not be cached"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String filename, boolean preview) {
        if (this.mStop) {
            return;
        }
        int downloaded = 0;
        String eTag = null;
        int lengthOfFile = 0;
        this.lenghtOfPreview = 0;
        try {
            URL url = new URL(this.mVideoUrl);
            this.mConnection = (HttpURLConnection)url.openConnection();
            this.mConnection.setRequestMethod("HEAD");
            if (this.mConnection.getResponseCode() == 200) {
                int length;
                eTag = this.mConnection.getHeaderField("ETag");
                lengthOfFile = this.mConnection.getContentLength();
                this.mConnection.disconnect();
                if (this.mStop) {
                    return;
                }
                Logging.out(LOG_TAG, "Length of file: " + lengthOfFile);
                if (preview) {
                    this.lenghtOfPreview = lengthOfFile / 4;
                }
                this.mConnection = (HttpURLConnection)url.openConnection();
                this.mConnection.setRequestMethod("GET");
                if (preview) {
                    this.configGetConnection(eTag, this.lenghtOfPreview);
                } else {
                    this.configGetConnection(eTag, lengthOfFile);
                }
                BufferedInputStream stream = new BufferedInputStream(this.mConnection.getInputStream());
                if (this.mStop) {
                    return;
                }
                this.mShortFileName = VideoUtils.getParentDir(this.mContext).getAbsolutePath() + "/" + filename;
                this.mVideoFile = new File(this.mShortFileName);
                this.mOutputStream = new FileOutputStream(this.mVideoFile);
                byte[] buffer = new byte[4096];
                while ((length = ((InputStream)stream).read(buffer)) != -1) {
                    this.mOutputStream.write(buffer, 0, length);
                    downloaded += length;
                }
                if (preview) {
                    this.handleVideoPreviewLoaded(downloaded, eTag, lengthOfFile);
                } else {
                    this.handleVideoFullDownloaded();
                }
            } else {
                if (this.mCallback != null) {
                    this.mCallback.onError(new LoopMeError("Error during loading video"));
                }
                ErrorTracker.post("Bad asset: " + this.mVideoUrl);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            ErrorTracker.post("Bad asset: " + this.mVideoUrl);
        }
        catch (IOException e) {
            Logging.out(LOG_TAG, "Exception: " + e.getMessage());
            e.printStackTrace();
            int lenght = preview ? this.lenghtOfPreview : lengthOfFile;
            this.reconnect(downloaded, eTag, lenght, preview);
        }
        finally {
            if (this.mOutputStream != null) {
                try {
                    this.mOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void handleVideoPreviewLoaded(int downloaded, String eTag, int lengthOfFile) {
        Logging.out(LOG_TAG, "downloaded preview! file size: " + this.mVideoFile.length());
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (VideoLoader.this.mCallback != null) {
                    VideoLoader.this.mCallback.onPreviewLoaded(VideoLoader.this.mShortFileName);
                }
            }
        });
        Logging.out(LOG_TAG, "load rest of file");
        this.reconnect(downloaded, eTag, lengthOfFile, false);
    }

    private void reconnect(int downloadedBefore, String eTag, int lengthOfFile, boolean preview) {
        if (this.mStop) {
            return;
        }
        Logging.out(LOG_TAG, "reconnect " + downloadedBefore + " " + preview);
        if (downloadedBefore == 0) {
            ErrorTracker.post("Bad asset: " + this.mVideoUrl);
            if (this.mCallback != null) {
                this.mCallback.onError(new LoopMeError("Error during video loading"));
            }
            return;
        }
        int downloaded = downloadedBefore;
        try {
            URL url = new URL(this.mVideoUrl);
            this.mConnection = (HttpURLConnection)url.openConnection();
            this.mConnection.setRequestMethod("GET");
            this.mConnection.setRequestProperty("Range", "bytes=" + downloadedBefore + "-" + lengthOfFile);
            this.mConnection.setRequestProperty("If-Range", eTag);
            BufferedInputStream stream = new BufferedInputStream(this.mConnection.getInputStream());
            FileOutputStream fos = new FileOutputStream(this.mVideoFile, true);
            byte[] buffer = new byte[4096];
            int length = 0;
            while ((length = ((InputStream)stream).read(buffer)) != -1) {
                fos.write(buffer, 0, length);
                downloaded += length;
            }
            ((InputStream)stream).close();
            fos.close();
            if (preview) {
                this.handleVideoPreviewLoaded(downloaded, eTag, lengthOfFile);
            } else {
                this.handleVideoFullDownloaded();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            Logging.out(LOG_TAG, "Exception: " + e.getMessage());
            e.printStackTrace();
            this.reconnect(downloaded, eTag, lengthOfFile, preview);
        }
    }

    private void handleVideoFullDownloaded() {
        this.mIsVideoFullyDownloaded = true;
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (VideoLoader.this.mCallback != null) {
                    VideoLoader.this.mCallback.onFullVideoLoaded(VideoLoader.this.mShortFileName);
                }
            }
        });
    }

    private void preloadVideo(final boolean partPreload) {
        Logging.out(LOG_TAG, "preloadVideo " + partPreload);
        ExecutorHelper.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                VideoLoader.this.load(VideoLoader.this.mShortFileName, partPreload);
            }
        });
    }

    public void stop() {
        Logging.out(LOG_TAG, "stop()");
        this.mStop = true;
        if (this.mConnection != null) {
            ExecutorHelper.getExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    Logging.out(LOG_TAG, "disconnect()");
                    VideoLoader.this.mConnection.disconnect();
                }
            });
        }
        if (!this.mIsVideoFullyDownloaded && this.mVideoFile != null && this.mVideoFile.exists()) {
            Logging.out(LOG_TAG, "remove bad file");
            this.mVideoFile.delete();
        }
    }

    private void configGetConnection(String eTag, int lenght) {
        this.mConnection.setReadTimeout(20000);
        this.mConnection.setConnectTimeout(20000);
        this.mConnection.setRequestProperty("Range", "bytes=0-" + lenght);
        this.mConnection.setRequestProperty("If-Range", eTag);
    }

    public static interface Callback {
        public void onError(LoopMeError var1);

        public void onPreviewLoaded(String var1);

        public void onFullVideoLoaded(String var1);
    }
}

