/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.common;

import android.view.MotionEvent;
import android.view.View;

public class SwipeListener
implements View.OnTouchListener {
    private float initialX;
    private int mViewWidth;
    private Listener mListener;

    public SwipeListener(int viewWidth, Listener listener) {
        this.mViewWidth = viewWidth;
        this.mListener = listener;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.initialX = event.getX();
                break;
            }
            case 2: {
                return true;
            }
            case 1: {
                float distanceX;
                float finalX = event.getX();
                if (this.initialX < finalX) {
                    distanceX = finalX - this.initialX;
                    if (this.mListener != null && distanceX > (float)(this.mViewWidth / 2)) {
                        this.mListener.onSwipe(true);
                    }
                }
                if (!(this.initialX > finalX)) break;
                distanceX = this.initialX - finalX;
                if (this.mListener == null || !(distanceX > (float)(this.mViewWidth / 2))) break;
                this.mListener.onSwipe(false);
            }
        }
        return false;
    }

    public static interface Listener {
        public void onSwipe(boolean var1);
    }
}

