/*
 * Decompiled with CFR 0.152.
 */
package com.loopme.common;

import com.loopme.common.AdParams;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.StaticParams;
import com.loopme.debugging.DebugController;
import com.loopme.debugging.ErrorTracker;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ResponseParser {
    private static final String LOG_TAG = ResponseParser.class.getSimpleName();
    private static final String JSON_SCRIPT = "script";
    private static final String JSON_FORMAT = "format";
    private static final String JSON_ORIENTATION = "orientation";
    private static final String JSON_EXPIRED_TIME = "ad_expiry_time";
    private static final String JSON_SETTINGS = "settings";
    private static final String JSON_PACKAGE_IDS = "package_ids";
    private static final String JSON_TOKEN = "token";
    private static final String JSON_DEBUG = "debug";
    private static final String JSON_PART_PRELOAD = "preload25";
    private static final String JSON_TRACKING = "tracking";
    private static final String JSON_ERROR = "error";
    private static final String JSON_V360 = "v360";
    private Listener mListener;
    private int mAdFormat;

    public ResponseParser(Listener listener, int format) {
        if (listener == null) {
            Logging.out(LOG_TAG, "Wrong parameter(s)");
        }
        this.mListener = listener;
        this.mAdFormat = format;
    }

    public AdParams getAdParams(String result) {
        boolean preload;
        String format;
        JSONObject settings;
        JSONObject object;
        if (result == null) {
            return null;
        }
        try {
            String requestedFormat;
            object = (JSONObject)new JSONTokener(result).nextValue();
            JSONObject tracking = this.parseJsonObject(object, JSON_TRACKING);
            String errorUrl = this.extractTrackingUrl(tracking);
            ErrorTracker.init(errorUrl);
            settings = object.getJSONObject(JSON_SETTINGS);
            format = settings.getString(JSON_FORMAT);
            if (!this.isValidFormat(format)) {
                ErrorTracker.post("Broken response (wrong format parameter: " + format + ")");
            }
            switch (this.mAdFormat) {
                case 1000: {
                    requestedFormat = "banner";
                    break;
                }
                case 1001: {
                    requestedFormat = "interstitial";
                    break;
                }
                default: {
                    requestedFormat = "";
                }
            }
            if (!format.equalsIgnoreCase(requestedFormat)) {
                this.handleParseError("Wrong Ad format");
                return null;
            }
        }
        catch (JSONException e) {
            this.handleParseError("Exception during json parse");
            ErrorTracker.post("Broken response");
            return null;
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            this.handleParseError("Exception during json parse");
            ErrorTracker.post("Broken response");
            return null;
        }
        int debugValue = this.parseInt(settings, JSON_DEBUG);
        boolean debug = debugValue == 1;
        DebugController.setLiveDebug(debug);
        int preloadValue = this.parseInt(settings, JSON_PART_PRELOAD);
        StaticParams.PART_PRELOAD = preload = preloadValue == 1;
        int video360Value = this.parseInt(settings, JSON_V360);
        boolean video360 = video360Value == 1;
        return new AdParams.AdParamsBuilder(format).html(this.parseString(object, JSON_SCRIPT)).orientation(this.parseString(settings, JSON_ORIENTATION)).expiredTime(this.parseInt(settings, JSON_EXPIRED_TIME)).token(this.parseString(settings, JSON_TOKEN)).packageIds(this.parseArray(settings, JSON_PACKAGE_IDS)).partPreload(preload).video360(video360).build();
    }

    private boolean isValidFormat(String format) {
        if (format == null) {
            return false;
        }
        return format.equalsIgnoreCase("banner") || format.equalsIgnoreCase("interstitial");
    }

    private void handleParseError(String mess) {
        if (this.mListener != null) {
            this.mListener.onParseError(new LoopMeError(mess));
        }
    }

    private List<String> parseArray(JSONObject object, String jsonParam) {
        ArrayList<String> packagIds = new ArrayList<String>();
        try {
            JSONArray array = object.getJSONArray(jsonParam);
            for (int i = 0; i < array.length(); ++i) {
                String item = (String)array.get(i);
                packagIds.add(item);
            }
        }
        catch (JSONException e) {
            Logging.out(LOG_TAG, jsonParam + " absent");
        }
        return packagIds;
    }

    private String parseString(JSONObject object, String jsonParam) {
        String value = null;
        try {
            value = object.getString(jsonParam);
        }
        catch (JSONException e) {
            Logging.out(LOG_TAG, jsonParam + " absent");
        }
        return value;
    }

    private JSONObject parseJsonObject(JSONObject object, String jsonParam) {
        JSONObject value = null;
        try {
            value = object.getJSONObject(jsonParam);
        }
        catch (JSONException e) {
            Logging.out(LOG_TAG, jsonParam + " absent");
        }
        return value;
    }

    private int parseInt(JSONObject object, String jsonParam) {
        int value = 0;
        try {
            value = object.getInt(jsonParam);
        }
        catch (JSONException e) {
            Logging.out(LOG_TAG, jsonParam + " absent");
        }
        return value;
    }

    private String extractTrackingUrl(JSONObject tracking) {
        String value = null;
        try {
            if (tracking != null) {
                value = tracking.getJSONArray(JSON_ERROR).getString(0);
            }
        }
        catch (JSONException e) {
            Logging.out(LOG_TAG, "error absent");
        }
        return value;
    }

    public static interface Listener {
        public void onParseError(LoopMeError var1);
    }
}

