/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import com.loopme.adview.AdView;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.Utils;
import com.loopme.debugging.ErrorTracker;
import java.io.IOException;

class VideoController
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnCompletionListener {
    private static final String LOG_TAG = VideoController.class.getSimpleName();
    private volatile MediaPlayer mPlayer;
    private int mVideoDuration;
    private int mVideoPositionWhenError;
    private boolean mMuteState = false;
    private boolean mWasError;
    private boolean mIsSurfaceTextureAvailable;
    private boolean mWaitForVideo;
    private Handler mHandler;
    private Runnable mRunnable;
    private AdView mAdView;
    private Context mContext;
    private String mFileRest;
    private Callback mCallback;
    private Surface mSurface;
    private CountDownTimer mBufferingTimer;
    private String mAppKey;
    private int mFormat;
    private int mQuarter25;
    private int mQuarter50;
    private int mQuarter75;
    private boolean mIs360;

    public VideoController(AdView adView, Callback callback, String appKey, int format) {
        this.mAdView = adView;
        this.mCallback = callback;
        this.mContext = adView.getContext();
        this.mAppKey = appKey;
        this.mFormat = format;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.initProgressRunnable();
    }

    void contain360(boolean b) {
        this.mIs360 = b;
    }

    public void destroy() {
        Logging.out(LOG_TAG, "destroy");
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
        }
        if (this.mBufferingTimer != null) {
            this.mBufferingTimer.cancel();
        }
        this.mRunnable = null;
        this.releasePlayer();
        this.mCallback = null;
        this.mSurface = null;
    }

    private void initProgressRunnable() {
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                if (VideoController.this.mAdView == null) {
                    return;
                }
                int position = VideoController.this.getCurrentPosition();
                VideoController.this.mAdView.setVideoCurrentTime(position);
                VideoController.this.updateCurrentVolume();
                if (position < VideoController.this.mVideoDuration) {
                    VideoController.this.mHandler.postDelayed(VideoController.this.mRunnable, 100L);
                }
            }
        };
    }

    public int getCurrentPosition() {
        return this.mPlayer == null ? 0 : this.mPlayer.getCurrentPosition();
    }

    public void releasePlayer() {
        if (this.mPlayer != null) {
            this.mPlayer.reset();
            this.mPlayer.release();
        }
    }

    public void setSurface(Surface surface) {
        Log.d((String)LOG_TAG, (String)("setSurface " + surface));
        this.mSurface = surface;
        if (this.mPlayer != null) {
            this.mPlayer.setSurface(surface);
        }
    }

    public void waitForVideo() {
        if (this.mWaitForVideo) {
            this.releasePlayer();
            this.initPlayer(this.mFileRest);
            this.mPlayer.setSurface(this.mSurface);
            if (this.mAdView.getCurrentWebViewState() == 1) {
                this.mPlayer.start();
            }
            this.seekTo(this.mVideoPositionWhenError);
            Logging.out(LOG_TAG, "waitForVideo mHandler.postDelayed");
            this.mHandler.postDelayed(this.mRunnable, 200L);
            this.setVideoState(2);
        }
    }

    public void seekTo(int position) {
        if (this.mPlayer != null) {
            this.mPlayer.seekTo(position);
        }
    }

    public void initPlayerFromFile(String filePath) {
        this.mPlayer = new MediaPlayer();
        this.initPlayerListeners();
        this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        try {
            this.mPlayer.setDataSource(filePath);
            this.mPlayer.prepareAsync();
        }
        catch (IllegalStateException e) {
            Logging.out(LOG_TAG, e.getMessage());
            this.setVideoState(5);
        }
        catch (IOException e) {
            Logging.out(LOG_TAG, e.getMessage());
            this.setVideoState(5);
        }
    }

    private void initPlayer(String filePath) {
        this.mPlayer = MediaPlayer.create((Context)this.mContext, (Uri)Uri.parse((String)filePath));
        this.initPlayerListeners();
    }

    private void initPlayerListeners() {
        this.mPlayer.setLooping(false);
        this.mPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mPlayer.setAudioStreamType(3);
    }

    public void muteVideo(boolean mute) {
        if (mute) {
            this.mPlayer.setVolume(0.0f, 0.0f);
        } else {
            float systemVolume = Utils.getSystemVolume();
            this.mPlayer.setVolume(systemVolume, systemVolume);
        }
        this.mMuteState = mute;
    }

    private void applyMuteSettings() {
        if (this.mPlayer != null) {
            Logging.out(LOG_TAG, "applyMuteSettings " + this.mMuteState);
            this.muteVideo(this.mMuteState);
        }
    }

    private void updateCurrentVolume() {
        if (!this.mMuteState) {
            float systemVolume = Utils.getSystemVolume();
            this.mPlayer.setVolume(systemVolume, systemVolume);
        }
    }

    public void setSurfaceTextureAvailable(boolean b) {
        this.mIsSurfaceTextureAvailable = b;
    }

    private boolean isPlayerReadyForPlay() {
        return this.mPlayer != null && this.mAdView != null && !this.mWasError;
    }

    public void playVideo(int time, boolean is360) {
        if (this.isPlayerReadyForPlay()) {
            if (!is360 && !this.mIsSurfaceTextureAvailable) {
                Logging.out(LOG_TAG, "postpone play (surface not available)");
                this.mCallback.postponePlay(time);
                return;
            }
            try {
                if (this.mPlayer.isPlaying()) {
                    return;
                }
                Logging.out(LOG_TAG, "Play video " + time);
                this.applyMuteSettings();
                if (time == 10) {
                    this.mPlayer.seekTo(0);
                }
                this.mPlayer.start();
                this.mAdView.setVideoState(2);
                this.mHandler.postDelayed(this.mRunnable, 200L);
            }
            catch (IllegalStateException e) {
                Logging.out(LOG_TAG, "playVideo:" + e.getMessage());
            }
        }
    }

    public void pauseVideo() {
        if (this.mPlayer != null && this.mAdView != null && !this.mWasError) {
            try {
                if (this.mPlayer.isPlaying()) {
                    Logging.out(LOG_TAG, "Pause video");
                    this.mHandler.removeCallbacks(this.mRunnable);
                    this.mPlayer.pause();
                    this.mAdView.setVideoState(3);
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                Logging.out(LOG_TAG, e.getMessage());
            }
        }
    }

    public void setFileRest(String filePath) {
        this.mFileRest = filePath;
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.mAdView.getCurrentVideoState() != 4) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.mAdView.setVideoCurrentTime(this.mVideoDuration);
            this.mAdView.setVideoState(4);
            if (this.mCallback != null) {
                this.mCallback.onVideoReachEnd();
            }
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        Logging.out(LOG_TAG, "onError: " + extra);
        this.mHandler.removeCallbacks(this.mRunnable);
        if (extra == -1004) {
            Logging.out(LOG_TAG, "end of preview file");
            this.mPlayer.setOnErrorListener(null);
            this.mPlayer.setOnCompletionListener(null);
            if (!TextUtils.isEmpty((CharSequence)this.mFileRest)) {
                this.mVideoPositionWhenError = mp.getCurrentPosition();
                this.mPlayer.reset();
                this.mPlayer.release();
                this.mPlayer = MediaPlayer.create((Context)this.mContext, (Uri)Uri.parse((String)this.mFileRest));
                this.initPlayerListeners();
                this.mPlayer.setSurface(this.mSurface);
                this.mPlayer.start();
                this.mPlayer.seekTo(this.mVideoPositionWhenError);
                Logging.out(LOG_TAG, "mHandler.postDelayed");
                this.mHandler.postDelayed(this.mRunnable, 200L);
            } else {
                this.mWaitForVideo = true;
                this.mVideoPositionWhenError = mp.getCurrentPosition();
                this.setVideoState(6);
                this.mBufferingTimer = new CountDownTimer(2000L, 1000L){

                    public void onTick(long millisUntilFinished) {
                    }

                    public void onFinish() {
                        ErrorTracker.post("Buffering 2 seconds");
                    }
                };
                this.mBufferingTimer.start();
            }
            return true;
        }
        if (this.mPlayer != null) {
            this.mPlayer.setOnErrorListener(null);
            this.mPlayer.setOnCompletionListener(null);
        }
        if (this.mAdView.getCurrentVideoState() == 5 || this.mAdView.getCurrentVideoState() == 0) {
            if (this.mCallback != null) {
                this.mCallback.onFail(new LoopMeError("Error during video loading"));
            }
        } else {
            this.mAdView.setWebViewState(2);
            this.mAdView.setVideoState(3);
            this.mCallback.playbackFinishedWithError();
            if (this.mPlayer != null) {
                this.mPlayer.reset();
            }
            this.mWasError = true;
        }
        return true;
    }

    public void onPrepared(MediaPlayer mp) {
        Logging.out(LOG_TAG, "onPrepared");
        this.setVideoState(1);
        this.extractVideoInfo(mp);
        if (this.mBufferingTimer != null) {
            this.mBufferingTimer.cancel();
        }
    }

    private void setVideoState(int state) {
        if (this.mAdView != null) {
            this.mAdView.setVideoState(state);
        }
    }

    private void extractVideoInfo(MediaPlayer mp) {
        if (mp != null) {
            int width = mp.getVideoWidth();
            int height = mp.getVideoHeight();
            if (this.mCallback != null) {
                this.mCallback.onVideoSizeChanged(width, height);
            }
            this.mVideoDuration = mp.getDuration();
            if (this.mAdView != null) {
                this.mAdView.setVideoDuration(this.mVideoDuration);
            }
            this.mQuarter25 = this.mVideoDuration / 4;
            this.mQuarter50 = this.mVideoDuration / 2;
            this.mQuarter75 = this.mQuarter25 + this.mQuarter50;
        }
    }

    public static interface Callback {
        public void onVideoReachEnd();

        public void onFail(LoopMeError var1);

        public void onVideoSizeChanged(int var1, int var2);

        public void postponePlay(int var1);

        public void playbackFinishedWithError();
    }
}

