/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.Context;
import android.graphics.Rect;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import com.loopme.IViewController;
import com.loopme.LoopMeBanner;
import com.loopme.LoopMeBannerView;
import com.loopme.NativeVideoBinder;
import com.loopme.common.AdChecker;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.MinimizedMode;
import com.loopme.debugging.ErrorTracker;
import java.util.ArrayList;
import java.util.Collections;

class NativeVideoController {
    private static final String LOG_TAG = NativeVideoController.class.getSimpleName();
    private NativeVideoBinder mBinder;
    private LoopMeBanner.Listener mAdListener;
    private SparseArray<View> mViewMap = new SparseArray();
    private SparseArray<LoopMeBanner> mAdsMap = new SparseArray();
    private SparseArray<String> mAppKeysMap = new SparseArray();
    private boolean mHorizontalScrolling;
    private DataChangeListener mDataChangeListener;
    private int mItemCount;
    private Context mContext;
    private MinimizedMode mMinimizedMode;

    public NativeVideoController(Context context) {
        this.mContext = context;
    }

    void refreshAdPlacement(int itemCount) {
        if (itemCount >= this.mItemCount) {
            return;
        }
        if (itemCount == 0) {
            int position = this.mAdsMap.keyAt(0);
            LoopMeBanner banner = (LoopMeBanner)this.mAdsMap.get(position);
            banner.destroy();
            this.mAdsMap.clear();
            return;
        }
        SparseArray currentAdsMap = this.mAdsMap.clone();
        this.mAdsMap.clear();
        for (int i = 0; i < currentAdsMap.size(); ++i) {
            int key = currentAdsMap.keyAt(i);
            LoopMeBanner banner = (LoopMeBanner)currentAdsMap.get(key);
            if (key <= itemCount) {
                this.mAdsMap.put(key, (Object)banner);
                continue;
            }
            banner.destroy();
        }
    }

    void destroy() {
        Logging.out(LOG_TAG, "destroy");
        for (int i = 0; i < this.mAppKeysMap.size(); ++i) {
            IViewController viewController;
            LoopMeBanner banner = LoopMeBanner.getInstance((String)this.mAppKeysMap.valueAt(i), null);
            if (banner.getAdController().isVideoPresented()) {
                banner.getAdController().pauseVideo();
            }
            if ((viewController = banner.getAdController().getViewController()) != null) {
                viewController.onPause();
                viewController.onDestroy();
            }
            banner.destroy();
        }
        this.mViewMap.clear();
        this.mAdsMap.clear();
        this.mAppKeysMap.clear();
        this.mAdListener = null;
        this.mDataChangeListener = null;
    }

    void onPause() {
        if (this.mAdsMap.size() != 0) {
            for (int i = 0; i < this.mAdsMap.size(); ++i) {
                LoopMeBanner banner = (LoopMeBanner)this.mAdsMap.valueAt(i);
                if (banner == null) continue;
                banner.pause();
            }
        }
    }

    void onResume(AbsListView listView, AdChecker checker) {
        if (this.mAdsMap.size() != 0) {
            if (this.mAdsMap.size() == 1) {
                LoopMeBanner banner = (LoopMeBanner)this.mAdsMap.valueAt(0);
                banner.getAdController().getViewController().onResume();
                if (banner.getAdController().getCurrentDisplayMode() == 101) {
                    banner.getAdController().setWebViewState(1);
                    return;
                }
            }
            this.onScroll(listView, checker);
        }
    }

    void onResume(RecyclerView recyclerView, AdChecker checker) {
        if (this.mAdsMap.size() != 0) {
            if (this.mAdsMap.size() == 1) {
                LoopMeBanner banner = (LoopMeBanner)this.mAdsMap.valueAt(0);
                banner.getAdController().getViewController().onResume();
                if (banner.getAdController().getCurrentDisplayMode() == 101) {
                    banner.getAdController().setWebViewState(1);
                    return;
                }
            }
            this.onScroll(recyclerView, checker);
        }
    }

    void setViewBinder(NativeVideoBinder binder) {
        this.mBinder = binder;
    }

    void setListener(LoopMeBanner.Listener listener) {
        this.mAdListener = listener;
    }

    void onLoadFail(LoopMeError error) {
        if (this.mAdListener != null) {
            this.mAdListener.onLoopMeBannerLoadFail(null, error);
        }
    }

    void putAdWithAppKeyToPosition(String appKey, int position) {
        Logging.out(LOG_TAG, "putAdWithAppKeyToPosition " + appKey + " " + position);
        this.mAppKeysMap.put(position, (Object)appKey);
    }

    LoopMeBanner.Listener getListener() {
        return this.mAdListener;
    }

    LoopMeBanner getNativeVideoAd(int position) {
        return (LoopMeBanner)this.mAdsMap.get(position);
    }

    int getAdsCount() {
        return this.mAdsMap.size();
    }

    View getAdView(LayoutInflater inflater, ViewGroup parent, LoopMeBanner banner, int position) {
        View row;
        Logging.out(LOG_TAG, "getAdView");
        this.checkFiftyPersentVisibility((View)this.mViewMap.get(position), banner);
        if (this.mViewMap.indexOfKey(position) >= 0) {
            return (View)this.mViewMap.get(position);
        }
        if (this.mBinder == null) {
            Logging.out(LOG_TAG, "Error: NativeVideoBinder is null. Init and bind it");
            row = null;
        } else {
            row = inflater.inflate(this.mBinder.getLayout(), parent, false);
            this.bindDataToView(row, this.mBinder, position);
        }
        this.mViewMap.put(position, (Object)row);
        return row;
    }

    private void bindDataToView(View row, NativeVideoBinder binder, int position) {
        Logging.out(LOG_TAG, "bindDataToView");
        LoopMeBannerView video = (LoopMeBannerView)row.findViewById(binder.getBannerViewId());
        int index = this.mAdsMap.indexOfKey(position);
        LoopMeBanner banner = (LoopMeBanner)this.mAdsMap.valueAt(index);
        banner.bindView(video);
        banner.showNativeVideo();
    }

    void loadAds(int itemsCount, DataChangeListener listener) {
        this.mDataChangeListener = listener;
        this.mItemCount = itemsCount;
        if (this.mAppKeysMap.size() == 0) {
            ErrorTracker.post("No ads for loading");
        }
        LoopMeBanner.Listener bannerListener = this.initBannerListener();
        for (int i = 0; i < this.mAppKeysMap.size(); ++i) {
            String appKey = (String)this.mAppKeysMap.valueAt(i);
            LoopMeBanner banner = LoopMeBanner.getInstance(appKey, this.mContext);
            banner.setListener(bannerListener);
            banner.load();
        }
    }

    private LoopMeBanner.Listener initBannerListener() {
        return new LoopMeBanner.Listener(){

            @Override
            public void onLoopMeBannerLoadSuccess(LoopMeBanner banner) {
                banner.setMinimizedMode(NativeVideoController.this.mMinimizedMode);
                NativeVideoController.this.addItem(banner, NativeVideoController.this.mItemCount);
                if (NativeVideoController.this.mAdListener != null) {
                    NativeVideoController.this.mAdListener.onLoopMeBannerLoadSuccess(banner);
                }
            }

            @Override
            public void onLoopMeBannerLoadFail(LoopMeBanner banner, LoopMeError error) {
            }

            @Override
            public void onLoopMeBannerShow(LoopMeBanner banner) {
            }

            @Override
            public void onLoopMeBannerHide(LoopMeBanner banner) {
            }

            @Override
            public void onLoopMeBannerClicked(LoopMeBanner banner) {
            }

            @Override
            public void onLoopMeBannerLeaveApp(LoopMeBanner banner) {
            }

            @Override
            public void onLoopMeBannerVideoDidReachEnd(LoopMeBanner banner) {
            }

            @Override
            public void onLoopMeBannerExpired(LoopMeBanner banner) {
            }
        };
    }

    private void addItem(LoopMeBanner ad, int itemsCount) {
        int nextIndex;
        int indexOfValue = this.mAppKeysMap.indexOfValue((Object)ad.getAppKey());
        if (indexOfValue >= 0 && indexOfValue < this.mAppKeysMap.size() && (nextIndex = this.mAppKeysMap.keyAt(indexOfValue)) < itemsCount + this.getAdsCount()) {
            this.mAdsMap.put(nextIndex, (Object)ad);
            Logging.out(LOG_TAG, "add ad to position " + nextIndex);
            if (this.mDataChangeListener != null) {
                this.mDataChangeListener.onDataSetChanged();
            }
        }
    }

    int getInitialPosition(int position) {
        int adsBefore = 0;
        for (int i = 0; i < this.mAdsMap.size(); ++i) {
            if (this.mAdsMap.keyAt(i) > position) continue;
            ++adsBefore;
        }
        return position - adsBefore;
    }

    void onScroll(AbsListView listview, AdChecker detector) {
        if (this.mAdsMap.size() == 0) {
            return;
        }
        int first = listview.getFirstVisiblePosition();
        int last = listview.getLastVisiblePosition();
        if (last == -1) {
            return;
        }
        for (int i = 0; i < this.mAdsMap.size(); ++i) {
            int adIndex = this.mAdsMap.keyAt(i);
            LoopMeBanner banner = (LoopMeBanner)this.mAdsMap.get(adIndex);
            if (banner.getAdController().getCurrentDisplayMode() == 102) {
                return;
            }
            if (!detector.isAd(adIndex)) continue;
            if (adIndex < first || adIndex > last) {
                if (this.mAdsMap.size() == 1) {
                    banner.switchToMinimizedMode();
                    continue;
                }
                banner.pause();
                continue;
            }
            int childIndex = adIndex - first;
            View view = listview.getChildAt(childIndex);
            banner.switchToNormalMode();
            this.checkFiftyPersentVisibility(view, banner);
        }
    }

    void onScroll(RecyclerView recyclerView, AdChecker detector) {
        if (detector == null || recyclerView == null || this.mAdsMap.size() == 0) {
            return;
        }
        int first = 0;
        int last = 0;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            first = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            last = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
        } else if (layoutManager instanceof GridLayoutManager) {
            first = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
            last = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            int[] lasts;
            int[] firsts;
            try {
                firsts = ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(null);
                lasts = ((StaggeredGridLayoutManager)layoutManager).findLastVisibleItemPositions(null);
            }
            catch (NullPointerException e) {
                return;
            }
            int orientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation();
            if (orientation == 0) {
                this.mHorizontalScrolling = true;
            }
            ArrayList<Integer> firstList = new ArrayList<Integer>(firsts.length);
            for (int i = 0; i < firsts.length; ++i) {
                firstList.add(firsts[i]);
            }
            ArrayList<Integer> lastList = new ArrayList<Integer>(lasts.length);
            for (int i = 0; i < lasts.length; ++i) {
                lastList.add(lasts[i]);
            }
            first = (Integer)Collections.min(firstList);
            last = (Integer)Collections.max(lastList);
        }
        for (int i = 0; i < this.mAdsMap.size(); ++i) {
            int adIndex = this.mAdsMap.keyAt(i);
            LoopMeBanner banner = (LoopMeBanner)this.mAdsMap.get(adIndex);
            if (banner.getAdController().getCurrentDisplayMode() == 102) {
                return;
            }
            if (!detector.isAd(adIndex)) continue;
            if (adIndex < first || adIndex > last) {
                if (this.mAdsMap.size() == 1) {
                    banner.switchToMinimizedMode();
                    continue;
                }
                banner.pause();
                continue;
            }
            int childIndex = adIndex - first;
            View view = recyclerView.getLayoutManager().getChildAt(childIndex);
            banner.switchToNormalMode();
            this.checkFiftyPersentVisibility(view, banner);
        }
    }

    void checkFiftyPersentVisibility(View view, LoopMeBanner banner) {
        int rectHeight;
        if (banner == null || view == null) {
            return;
        }
        Rect rect = new Rect();
        boolean b = view.getGlobalVisibleRect(rect);
        int halfOfView = this.mHorizontalScrolling ? view.getWidth() / 2 : view.getHeight() / 2;
        int n = rectHeight = this.mHorizontalScrolling ? rect.width() : rect.height();
        if (b) {
            if (rectHeight < halfOfView) {
                banner.pause();
            } else {
                banner.getAdController().setWebViewState(1);
                banner.getAdController().getViewController().onResume();
            }
        }
    }

    void setMinimizedMode(MinimizedMode mode) {
        this.mMinimizedMode = mode;
    }

    public static interface DataChangeListener {
        public void onDataSetChanged();
    }
}

