/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import com.loopme.LoopMeBanner;
import com.loopme.NativeVideoBinder;
import com.loopme.NativeVideoController;
import com.loopme.common.AdChecker;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.MinimizedMode;
import com.loopme.common.Utils;

public class NativeVideoAdapter
extends BaseAdapter
implements AdChecker,
NativeVideoController.DataChangeListener {
    private static final String LOG_TAG = NativeVideoAdapter.class.getSimpleName();
    private BaseAdapter mOriginAdapter;
    private Context mContext;
    private NativeVideoController mNativeVideoController;
    private LayoutInflater mInflater;
    private AbsListView.OnScrollListener mOriginScrollListener;
    private AbsListView mListView;

    public NativeVideoAdapter(@NonNull BaseAdapter originAdapter, @NonNull Context context, @NonNull AbsListView listView) {
        this.mOriginAdapter = originAdapter;
        this.mContext = context.getApplicationContext();
        this.mListView = listView;
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mNativeVideoController = new NativeVideoController(this.mContext);
        listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (NativeVideoAdapter.this.mOriginScrollListener != null) {
                    NativeVideoAdapter.this.mOriginScrollListener.onScrollStateChanged(view, scrollState);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (NativeVideoAdapter.this.mOriginScrollListener != null) {
                    NativeVideoAdapter.this.mOriginScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
                }
                NativeVideoAdapter.this.mNativeVideoController.onScroll(view, (AdChecker)NativeVideoAdapter.this);
            }
        });
        this.mOriginAdapter.registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                NativeVideoAdapter.this.triggerUpdateProcessor();
            }

            public void onInvalidated() {
                NativeVideoAdapter.this.notifyDataSetInvalidated();
            }
        });
    }

    private void triggerUpdateProcessor() {
        this.notifyDataSetChanged();
        this.mNativeVideoController.refreshAdPlacement(this.mOriginAdapter.getCount());
    }

    public void destroy() {
        this.mNativeVideoController.destroy();
    }

    public void onPause() {
        Logging.out(LOG_TAG, "onPause");
        this.mNativeVideoController.onPause();
    }

    public void onResume() {
        Logging.out(LOG_TAG, "onResume");
        this.mNativeVideoController.onResume(this.mListView, (AdChecker)this);
    }

    public void putAdWithAppKeyToPosition(String appKey, int position) {
        if (position < this.mOriginAdapter.getCount()) {
            this.mNativeVideoController.putAdWithAppKeyToPosition(appKey, position);
        } else {
            Logging.out(LOG_TAG, "Wrong position " + position);
        }
    }

    public void loadAds() {
        if (Build.VERSION.SDK_INT < 14) {
            LoopMeError error = new LoopMeError("Not supported Android version. Expected Android 4.0+");
            this.mNativeVideoController.onLoadFail(error);
            return;
        }
        if (Utils.isOnline(this.mContext)) {
            this.mNativeVideoController.loadAds(this.mOriginAdapter.getCount(), this);
        } else {
            LoopMeError error = new LoopMeError("No connection");
            this.mNativeVideoController.onLoadFail(error);
        }
    }

    public void setMinimizedMode(MinimizedMode mode) {
        if (mode != null) {
            Logging.out(LOG_TAG, "Set minimized mode");
            this.mNativeVideoController.setMinimizedMode(mode);
        }
    }

    public void setOriginScrollListener(AbsListView.OnScrollListener scrollListener) {
        this.mOriginScrollListener = scrollListener;
    }

    public void setAdListener(LoopMeBanner.Listener listener) {
        this.mNativeVideoController.setListener(listener);
    }

    public void setViewBinder(NativeVideoBinder binder) {
        this.mNativeVideoController.setViewBinder(binder);
    }

    public boolean hasStableIds() {
        return this.mOriginAdapter.hasStableIds();
    }

    public int getItemViewType(int position) {
        if (this.isAd(position)) {
            return this.mOriginAdapter.getViewTypeCount();
        }
        return this.mOriginAdapter.getItemViewType(position);
    }

    public int getViewTypeCount() {
        return this.mOriginAdapter.getViewTypeCount() + 1;
    }

    public boolean isEmpty() {
        return this.mOriginAdapter.isEmpty();
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mOriginAdapter.registerDataSetObserver(observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mOriginAdapter.unregisterDataSetObserver(observer);
    }

    public boolean areAllItemsEnabled() {
        return this.mOriginAdapter.areAllItemsEnabled();
    }

    public boolean isEnabled(int position) {
        return this.mOriginAdapter.isEnabled(position);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.mOriginAdapter.getDropDownView(position, convertView, parent);
    }

    public int getCount() {
        return this.mOriginAdapter.getCount() + this.mNativeVideoController.getAdsCount();
    }

    public Object getItem(int position) {
        if (this.isAd(position)) {
            return this.mNativeVideoController.getNativeVideoAd(position);
        }
        int initPosition = this.mNativeVideoController.getInitialPosition(position);
        return this.mOriginAdapter.getItem(initPosition);
    }

    public long getItemId(int position) {
        if (this.isAd(position)) {
            return -System.identityHashCode(this.mNativeVideoController.getNativeVideoAd(position));
        }
        int initPosition = this.mNativeVideoController.getInitialPosition(position);
        return this.mOriginAdapter.getItemId(initPosition);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (this.isAd(position)) {
            LoopMeBanner item = this.mNativeVideoController.getNativeVideoAd(position);
            View row = this.mNativeVideoController.getAdView(this.mInflater, parent, item, position);
            return row;
        }
        int initPosition = this.mNativeVideoController.getInitialPosition(position);
        return this.mOriginAdapter.getView(initPosition, convertView, parent);
    }

    @Override
    public boolean isAd(int i) {
        return this.mNativeVideoController.getNativeVideoAd(i) != null;
    }

    @Override
    public void onDataSetChanged() {
        this.mOriginAdapter.notifyDataSetChanged();
    }
}

