/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.Context;
import android.text.TextUtils;
import com.loopme.BaseAd;
import com.loopme.LoopMeBanner;
import com.loopme.LoopMeInterstitial;
import java.util.HashMap;
import java.util.Map;

public class LoopMeAdHolder {
    private static final Map<String, LoopMeInterstitial> mInterstitialMap = new HashMap<String, LoopMeInterstitial>();
    private static final Map<String, LoopMeBanner> mBannerMap = new HashMap<String, LoopMeBanner>();

    private LoopMeAdHolder() {
    }

    static void putAd(BaseAd ad) {
        String appKey = ad.getAppKey();
        if (ad.getAdFormat() == 1001) {
            mInterstitialMap.put(appKey, (LoopMeInterstitial)ad);
        } else {
            mBannerMap.put(appKey, (LoopMeBanner)ad);
        }
    }

    public static LoopMeInterstitial getInterstitial(String appKey, Context context) {
        if (mInterstitialMap.containsKey(appKey)) {
            return mInterstitialMap.get(appKey);
        }
        if (context == null || TextUtils.isEmpty((CharSequence)appKey)) {
            return null;
        }
        LoopMeInterstitial interstitial = new LoopMeInterstitial(context.getApplicationContext(), appKey);
        mInterstitialMap.put(appKey, interstitial);
        return interstitial;
    }

    public static LoopMeBanner getBanner(String appKey, Context context) {
        if (mBannerMap.containsKey(appKey)) {
            return mBannerMap.get(appKey);
        }
        if (context == null || TextUtils.isEmpty((CharSequence)appKey)) {
            return null;
        }
        LoopMeBanner banner = new LoopMeBanner(context.getApplicationContext(), appKey);
        mBannerMap.put(appKey, banner);
        return banner;
    }

    static void removeInterstitial(String appKey) {
        mInterstitialMap.remove(appKey);
    }

    static void removeBanner(String appKey) {
        mBannerMap.remove(appKey);
    }
}

