/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.loopme.AdController;
import com.loopme.LoopMeAdHolder;
import com.loopme.common.AdFetcherTimer;
import com.loopme.common.AdParams;
import com.loopme.common.EventManager;
import com.loopme.common.ExecutorHelper;
import com.loopme.common.ExpirationTimer;
import com.loopme.common.Logging;
import com.loopme.common.LoopMeError;
import com.loopme.common.StaticParams;
import com.loopme.common.Utils;
import com.loopme.data.DataCollector;
import com.loopme.debugging.ErrorTracker;
import com.loopme.request.AdRequestParametersProvider;
import com.loopme.request.AdRequestUrlBuilder;
import com.loopme.request.AdTargeting;
import com.loopme.request.AdTargetingData;
import com.loopme.tasks.AdFetcher;
import com.loopme.tasks.AdvIdFetcher;
import java.util.concurrent.Future;

public abstract class BaseAd
implements AdTargeting {
    private static final String LOG_TAG = BaseAd.class.getSimpleName();
    private Context mContext;
    private String mAppKey;
    protected volatile AdController mAdController;
    protected Future mFuture;
    protected String mRequestUrl;
    protected ExpirationTimer mExpirationTimer;
    protected ExpirationTimer.Listener mExpirationListener;
    protected AdFetcherTimer mFetcherTimer;
    protected AdFetcherTimer.Listener mFetcherTimerListener;
    protected volatile AdFetcher.Listener mAdFetcherListener;
    protected volatile int mAdState = 200;
    protected volatile boolean mIsReady;
    protected long mAdLoadingTimer;
    protected int mShowWhenAdNotReadyCounter;
    private AdParams mAdParams;
    private AdTargetingData mAdTargetingData = new AdTargetingData();
    protected Handler mHandler = new Handler(Looper.getMainLooper());

    public BaseAd(Context context, String appKey) {
        if (context == null || TextUtils.isEmpty((CharSequence)appKey)) {
            throw new IllegalArgumentException("Wrong parameters");
        }
        this.mContext = context;
        this.mAppKey = appKey;
        DataCollector.getInstance(this.mContext).start();
    }

    public boolean isReady() {
        return this.mIsReady;
    }

    public boolean isShowing() {
        return this.mAdState == 202;
    }

    public boolean isLoading() {
        return this.mAdState == 201;
    }

    public void load() {
        Logging.out(LOG_TAG, "Start loading ad with app key " + this.mAppKey);
        if (this.mAdState == 201 || this.mAdState == 202) {
            Logging.out(LOG_TAG, "Ad already loading or showing");
            return;
        }
        if (this.mAdController == null) {
            this.mAdController = new AdController(this);
        }
        this.mAdState = 201;
        this.mAdLoadingTimer = System.currentTimeMillis();
        this.startFetcherTimer();
        if (this.isReady()) {
            Logging.out(LOG_TAG, "Ad already loaded");
            this.onAdLoadSuccess();
            return;
        }
        if (Build.VERSION.SDK_INT < 16) {
            this.onAdLoadFail(new LoopMeError("Not supported Android version. Expected Android 4.1+"));
            return;
        }
        if (Utils.isOnline(this.getContext())) {
            this.proceedLoad();
        } else {
            this.onAdLoadFail(new LoopMeError("No connection"));
        }
    }

    public void destroy() {
        Logging.out(LOG_TAG, "Ad will be destroyed");
        this.mAdFetcherListener = null;
        this.mIsReady = false;
        this.stopExpirationTimer();
        this.stopFetcherTimer();
        this.mAdState = 200;
        this.getAdTargetingData().clear();
        AdRequestParametersProvider.getInstance().reset();
        this.releaseViewController();
        if (this.getAdFormat() == 1001) {
            LoopMeAdHolder.removeInterstitial(this.mAppKey);
        } else {
            LoopMeAdHolder.removeBanner(this.mAppKey);
        }
        if (this.mFuture != null) {
            this.mFuture.cancel(true);
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    protected void cancelFetcher() {
        Logging.out(LOG_TAG, "Cancel ad fether");
        this.mAdFetcherListener = null;
        this.releaseViewController();
        if (this.mFuture != null) {
            this.mFuture.cancel(true);
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    public abstract int getAdFormat();

    public abstract void dismiss();

    abstract void onAdExpired();

    abstract void onAdLoadSuccess();

    abstract void onAdLoadFail(LoopMeError var1);

    abstract void onAdLeaveApp();

    abstract void onAdClicked();

    abstract void onAdVideoDidReachEnd();

    abstract int detectWidth();

    abstract int detectHeight();

    public String getAppKey() {
        return this.mAppKey;
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected AdTargetingData getAdTargetingData() {
        return this.mAdTargetingData;
    }

    protected AdParams getAdParams() {
        return this.mAdParams;
    }

    protected void setAdParams(AdParams params) {
        this.mAdParams = params;
    }

    protected void fetchAdComplete(AdParams params) {
        this.setAdParams(params);
        this.preloadHtmlInWebview(params.getHtml());
    }

    private void preloadHtmlInWebview(String html) {
        if (TextUtils.isEmpty((CharSequence)html)) {
            this.onAdLoadFail(new LoopMeError("Broken response"));
            ErrorTracker.post("Broken response (empty html)");
        } else if (this.mAdController != null) {
            this.mAdController.initControllers();
            this.mAdController.preloadHtml(html);
        } else {
            this.onAdLoadFail(new LoopMeError("Html loading error"));
        }
    }

    protected AdFetcher.Listener initAdFetcherListener() {
        return new AdFetcher.Listener(){

            @Override
            public void onComplete(AdParams params, LoopMeError error) {
                if (params != null && !params.getPackageIds().isEmpty()) {
                    boolean b = Utils.isPackageInstalled(params.getPackageIds());
                    if (b) {
                        BaseAd.this.mAdState = 200;
                        BaseAd.this.completeRequest(null, new LoopMeError("No valid ads found"));
                        EventManager eventManager = new EventManager();
                        eventManager.trackSdkEvent(params.getToken());
                    } else {
                        BaseAd.this.completeRequest(params, error);
                    }
                } else {
                    BaseAd.this.completeRequest(params, error);
                }
            }
        };
    }

    private void completeRequest(final AdParams params, final LoopMeError error) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (params == null) {
                    if (error != null) {
                        BaseAd.this.onAdLoadFail(error);
                    } else {
                        BaseAd.this.onAdLoadFail(new LoopMeError("Request timeout"));
                    }
                } else {
                    BaseAd.this.fetchAdComplete(params);
                }
            }
        });
    }

    private void proceedLoad() {
        if (AdRequestParametersProvider.getInstance().getGoogleAdvertisingId() == null) {
            Logging.out(LOG_TAG, "Start initialization google adv id");
            this.detectGoogleAdvertisingId();
        } else {
            this.fetchAd();
        }
    }

    private void detectGoogleAdvertisingId() {
        AdvIdFetcher advTask = new AdvIdFetcher(this.mContext, new AdvIdFetcher.Listener(){

            @Override
            public void onComplete(String advId, boolean isLimited) {
                AdRequestParametersProvider.getInstance().setGoogleAdvertisingId(advId, isLimited);
                BaseAd.this.fetchAd();
            }
        });
        this.mFuture = ExecutorHelper.getExecutor().submit(advTask);
    }

    protected void releaseViewController() {
        Logging.out(LOG_TAG, "Release ViewController");
        if (this.mAdController != null) {
            this.mAdController.destroy();
            this.mAdController = null;
        }
    }

    protected void startExpirationTimer() {
        if (this.mExpirationTimer != null || this.mAdParams == null || this.mAdController == null || !this.mAdController.isVideoPresented()) {
            return;
        }
        int validTime = this.mAdParams.getExpiredTime();
        this.mExpirationListener = new ExpirationTimer.Listener(){

            @Override
            public void onExpired() {
                BaseAd.this.onAdExpired();
            }
        };
        this.mExpirationTimer = new ExpirationTimer(validTime, this.mExpirationListener);
        this.mExpirationTimer.start();
    }

    protected void stopExpirationTimer() {
        if (this.mExpirationTimer != null) {
            Logging.out(LOG_TAG, "Stop schedule expiration");
            this.mExpirationTimer.cancel();
            this.mExpirationTimer = null;
        }
        this.mExpirationListener = null;
    }

    protected void startFetcherTimer() {
        if (this.mFetcherTimer != null) {
            return;
        }
        this.mFetcherTimerListener = new AdFetcherTimer.Listener(){

            @Override
            public void onTimeout() {
                BaseAd.this.cancelFetcher();
                BaseAd.this.onAdLoadFail(new LoopMeError("Ad processing timeout"));
            }
        };
        this.mFetcherTimer = new AdFetcherTimer(180000L, this.mFetcherTimerListener);
        float fetchTimeout = 3.0f;
        Logging.out(LOG_TAG, "Fetch timeout: " + fetchTimeout + " minutes");
        this.mFetcherTimer.start();
    }

    protected void stopFetcherTimer() {
        Logging.out(LOG_TAG, "Stop fetcher timer");
        if (this.mFetcherTimer != null) {
            this.mFetcherTimer.cancel();
            this.mFetcherTimer = null;
        }
        this.mFetcherTimerListener = null;
    }

    protected void fetchAd() {
        LoopMeAdHolder.putAd(this);
        this.mRequestUrl = new AdRequestUrlBuilder(this.mContext).buildRequestUrl(this.mAppKey, this.mAdTargetingData);
        if (this.mRequestUrl == null) {
            this.onAdLoadFail(new LoopMeError("Error during building ad request url"));
            return;
        }
        this.mAdFetcherListener = this.initAdFetcherListener();
        AdFetcher fetcher = new AdFetcher(this.mRequestUrl, this.mAdFetcherListener, this.getAdFormat());
        this.mFuture = ExecutorHelper.getExecutor().submit(fetcher);
    }

    public void setVideoCacheTimeInterval(long milliseconds) {
        if (milliseconds > 0L) {
            StaticParams.CACHED_VIDEO_LIFE_TIME = milliseconds;
        }
    }

    public void useMobileNetworkForCaching(boolean b) {
        StaticParams.USE_MOBILE_NETWORK_FOR_CACHING = b;
    }

    public void setDebugMode(boolean mode) {
        StaticParams.DEBUG_MODE = mode;
    }

    @Override
    public void setKeywords(String keywords) {
        this.mAdTargetingData.setKeywords(keywords);
    }

    @Override
    public void setGender(String gender) {
        this.mAdTargetingData.setGender(gender);
    }

    @Override
    public void setYearOfBirth(int year) {
        this.mAdTargetingData.setYob(year);
    }

    @Override
    public void addCustomParameter(String param, String paramValue) {
        this.mAdTargetingData.setCustomParameters(param, paramValue);
    }

    AdController getAdController() {
        return this.mAdController;
    }
}

