/*
 * Decompiled with CFR 0.152.
 */
package com.loopme;

import android.app.Activity;
import android.content.Context;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.loopme.AdController;
import com.loopme.AdReceiver;
import com.loopme.BaseAd;
import com.loopme.IViewController;
import com.loopme.LoopMeAdHolder;
import com.loopme.LoopMeBannerView;
import com.loopme.LoopMeInterstitial;
import com.loopme.common.Logging;
import com.loopme.common.Utils;

public final class AdActivity
extends Activity
implements AdReceiver.Listener {
    private static final String LOG_TAG = AdActivity.class.getSimpleName();
    private AdController mAdController;
    private IViewController mIViewController;
    private int mFormat;
    private boolean mIs360;
    private BaseAd mBaseAd;
    private FrameLayout mLayout;
    private boolean mKeepAlive = true;
    private AdReceiver mReceiver;
    private SensorManager mSensorManager;
    private float mAccel;
    private float mAccelCurrent;
    private float mAccelLast;
    private int mInitialOrientation;
    private boolean mReceivedDestroyBroadcast;
    private final SensorEventListener mSensorListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent se) {
            float x = se.values[0];
            float y = se.values[1];
            float z = se.values[2];
            AdActivity.this.mAccelLast = AdActivity.this.mAccelCurrent;
            AdActivity.this.mAccelCurrent = (float)Math.sqrt(x * x + y * y + z * z);
            float delta = AdActivity.this.mAccelCurrent - AdActivity.this.mAccelLast;
            AdActivity.this.mAccel = AdActivity.this.mAccel * 0.9f + delta;
            if (delta > 5.0f && AdActivity.this.mAdController != null) {
                AdActivity.this.mAdController.onAdShake();
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    public final void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setVolumeControlStream(3);
        this.mInitialOrientation = Utils.getScreenOrientation(this);
        String appKey = this.getIntent().getStringExtra("appkey");
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            Logging.out(LOG_TAG, "Empty app key");
        }
        this.mFormat = this.getIntent().getIntExtra("format", 0);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().setFlags(0x1000000, 0x1000000);
        Logging.out(LOG_TAG, "onCreate");
        if (this.mFormat == 1001) {
            this.mBaseAd = LoopMeAdHolder.getInterstitial(appKey, null);
        } else if (this.mFormat == 1000) {
            this.mBaseAd = LoopMeAdHolder.getBanner(appKey, null);
        }
        if (this.mBaseAd == null || this.mBaseAd.getAdController() == null) {
            Logging.out(LOG_TAG, "No ads with app key " + appKey);
            this.finish();
        } else {
            this.mIs360 = this.mBaseAd.getAdParams().isVideo360();
            this.mAdController = this.mBaseAd.getAdController();
            this.mIViewController = this.mAdController.getViewController();
            if (this.mFormat == 1001) {
                if (!this.mIs360) {
                    this.applyOrientationFromAdParams();
                }
            } else {
                this.setRequestedOrientation(6);
            }
            this.mLayout = this.buildLayout();
            this.setContentView((View)this.mLayout);
            this.initSensor();
            this.initDestroyReceiver();
            if (this.mFormat == 1001) {
                if (this.mIs360) {
                    this.mIViewController.initVRLibrary((Context)this);
                }
                ((LoopMeInterstitial)this.mBaseAd).onLoopMeInterstitialShow((LoopMeInterstitial)this.mBaseAd);
            }
        }
    }

    private void initSensor() {
        this.mSensorManager = (SensorManager)this.getSystemService("sensor");
        this.mAccel = 0.0f;
        this.mAccelCurrent = 9.80665f;
        this.mAccelLast = 9.80665f;
    }

    private FrameLayout buildLayout() {
        this.mLayout = new FrameLayout((Context)this);
        if (this.mFormat == 1001) {
            if (this.mAdController != null) {
                if (this.isVideoPresented()) {
                    this.mAdController.buildVideoAdView((ViewGroup)this.mLayout);
                } else {
                    this.mAdController.buildStaticAdView((ViewGroup)this.mLayout);
                }
            }
        } else {
            LoopMeBannerView banner = new LoopMeBannerView((Context)this);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            this.mAdController.rebuildView((ViewGroup)banner);
            this.mLayout.addView((View)banner, (ViewGroup.LayoutParams)params);
        }
        return this.mLayout;
    }

    private boolean isVideoPresented() {
        return this.mAdController.isVideoPresented();
    }

    private void initDestroyReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.loopme.DESTROY_INTENT");
        filter.addAction("com.loopme.CLICK_INTENT");
        this.mReceiver = new AdReceiver(this);
        this.registerReceiver(this.mReceiver, filter);
    }

    private void applyOrientationFromAdParams() {
        String or = this.mBaseAd.getAdParams().getAdOrientation();
        if (or == null) {
            return;
        }
        if (or.equalsIgnoreCase("portrait")) {
            this.setRequestedOrientation(7);
        } else if (or.equalsIgnoreCase("landscape")) {
            this.setRequestedOrientation(6);
        }
    }

    protected void onDestroy() {
        Logging.out(LOG_TAG, "onDestroy");
        if (this.mReceiver != null) {
            this.unregisterReceiver(this.mReceiver);
        }
        if (this.mLayout != null) {
            this.mLayout.removeAllViews();
        }
        if (this.mBaseAd != null && this.mFormat == 1001) {
            if (this.mIs360) {
                this.mIViewController.onDestroy();
            }
            ((LoopMeInterstitial)this.mBaseAd).onLoopMeInterstitialHide((LoopMeInterstitial)this.mBaseAd);
        }
        super.onDestroy();
    }

    protected void onPause() {
        super.onPause();
        Logging.out(LOG_TAG, "onPause");
        if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener(this.mSensorListener);
        }
        if (this.mIViewController != null) {
            this.mIViewController.onPause();
        }
        if (this.mFormat == 1000) {
            if (!this.mReceivedDestroyBroadcast && this.mAdController != null) {
                this.mAdController.setWebViewState(2);
            }
        } else if (!this.mKeepAlive && this.mFormat == 1001) {
            if (this.mAdController != null) {
                this.mAdController.setWebViewState(3);
                if (this.mIs360) {
                    this.mAdController.pauseVideo();
                }
            }
            this.finish();
        }
    }

    protected void onResume() {
        super.onResume();
        Logging.out(LOG_TAG, "onResume");
        this.mKeepAlive = false;
        if (this.mAdController != null) {
            this.mAdController.setWebViewState(1);
            if (this.mIViewController != null) {
                this.mIViewController.onResume();
            }
        }
        if (this.mSensorManager != null) {
            this.mSensorManager.registerListener(this.mSensorListener, this.mSensorManager.getDefaultSensor(1), 3);
        }
    }

    public void onBackPressed() {
        if (this.mFormat == 1000) {
            this.mAdController.switchToPreviousMode();
            super.onBackPressed();
        }
    }

    @Override
    public void onDestroyBroadcast() {
        Logging.out(LOG_TAG, "onDestroyBroadcast");
        this.mReceivedDestroyBroadcast = true;
        if (this.mFormat == 1000) {
            this.setRequestedOrientation(this.mInitialOrientation);
            this.mAdController.switchToPreviousMode();
        }
        if (this.mReceiver != null) {
            this.unregisterReceiver(this.mReceiver);
            this.mReceiver = null;
        }
        this.finish();
    }

    @Override
    public void onClickBroadcast() {
        this.mKeepAlive = true;
    }
}

