/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.util.Log;
import com.loopj.android.http.AsyncHttpResponseHandler;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;

public abstract class BinaryHttpResponseHandler
extends AsyncHttpResponseHandler {
    private static final String LOG_TAG = "BinaryHttpResponseHandler";
    private String[] mAllowedContentTypes = new String[]{"application/octet-stream", "image/jpeg", "image/png", "image/gif"};

    public String[] getAllowedContentTypes() {
        return this.mAllowedContentTypes;
    }

    public BinaryHttpResponseHandler() {
    }

    public BinaryHttpResponseHandler(String[] allowedContentTypes) {
        if (allowedContentTypes != null) {
            this.mAllowedContentTypes = allowedContentTypes;
        } else {
            Log.e((String)LOG_TAG, (String)"Constructor passed allowedContentTypes was null !");
        }
    }

    @Override
    public abstract void onSuccess(int var1, Header[] var2, byte[] var3);

    @Override
    public abstract void onFailure(int var1, Header[] var2, byte[] var3, Throwable var4);

    @Override
    public final void sendResponseMessage(HttpResponse response) throws IOException {
        StatusLine status = response.getStatusLine();
        Header[] contentTypeHeaders = response.getHeaders("Content-Type");
        if (contentTypeHeaders.length != 1) {
            this.sendFailureMessage(status.getStatusCode(), response.getAllHeaders(), null, (Throwable)new HttpResponseException(status.getStatusCode(), "None, or more than one, Content-Type Header found!"));
            return;
        }
        Header contentTypeHeader = contentTypeHeaders[0];
        boolean foundAllowedContentType = false;
        for (String anAllowedContentType : this.getAllowedContentTypes()) {
            try {
                if (!Pattern.matches(anAllowedContentType, contentTypeHeader.getValue())) continue;
                foundAllowedContentType = true;
            }
            catch (PatternSyntaxException e) {
                Log.e((String)LOG_TAG, (String)("Given pattern is not valid: " + anAllowedContentType), (Throwable)e);
            }
        }
        if (!foundAllowedContentType) {
            this.sendFailureMessage(status.getStatusCode(), response.getAllHeaders(), null, (Throwable)new HttpResponseException(status.getStatusCode(), "Content-Type (" + contentTypeHeader.getValue() + ") not allowed!"));
            return;
        }
        super.sendResponseMessage(response);
    }
}

