/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.SystemClock;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

class RetryHandler
implements HttpRequestRetryHandler {
    private static final int RETRY_SLEEP_TIME_MILLIS = 1500;
    private static HashSet<Class<?>> exceptionWhitelist = new HashSet();
    private static HashSet<Class<?>> exceptionBlacklist = new HashSet();
    private final int maxRetries;

    public RetryHandler(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        boolean sent;
        boolean retry = true;
        Boolean b = (Boolean)context.getAttribute("http.request_sent");
        boolean bl = sent = b != null && b != false;
        if (executionCount > this.maxRetries) {
            retry = false;
        } else if (this.isInList(exceptionBlacklist, exception)) {
            retry = false;
        } else if (this.isInList(exceptionWhitelist, exception)) {
            retry = true;
        } else if (!sent) {
            retry = true;
        }
        if (retry) {
            HttpUriRequest currentReq = (HttpUriRequest)context.getAttribute("http.request");
            String requestType = currentReq.getMethod();
            boolean bl2 = retry = !requestType.equals("POST");
        }
        if (retry) {
            SystemClock.sleep((long)1500L);
        } else {
            exception.printStackTrace();
        }
        return retry;
    }

    protected boolean isInList(HashSet<Class<?>> list, Throwable error) {
        Iterator<Class<?>> itr = list.iterator();
        while (itr.hasNext()) {
            if (!itr.next().isInstance(error)) continue;
            return true;
        }
        return false;
    }

    static {
        exceptionWhitelist.add(NoHttpResponseException.class);
        exceptionWhitelist.add(UnknownHostException.class);
        exceptionWhitelist.add(SocketException.class);
        exceptionBlacklist.add(InterruptedIOException.class);
        exceptionBlacklist.add(SSLHandshakeException.class);
    }
}

