/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Message;
import com.loopj.android.http.AsyncHttpResponseHandler;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

public class BinaryHttpResponseHandler
extends AsyncHttpResponseHandler {
    private static String[] mAllowedContentTypes = new String[]{"image/jpeg", "image/png"};

    public BinaryHttpResponseHandler() {
    }

    public BinaryHttpResponseHandler(String[] allowedContentTypes) {
        this();
        mAllowedContentTypes = allowedContentTypes;
    }

    public void onSuccess(byte[] binaryData) {
    }

    public void onSuccess(int statusCode, byte[] binaryData) {
        this.onSuccess(binaryData);
    }

    public void onFailure(Throwable error, byte[] binaryData) {
        this.onFailure(error);
    }

    protected void sendSuccessMessage(int statusCode, byte[] responseBody) {
        this.sendMessage(this.obtainMessage(0, new Object[]{statusCode, responseBody}));
    }

    @Override
    protected void sendFailureMessage(Throwable e, byte[] responseBody) {
        this.sendMessage(this.obtainMessage(1, new Object[]{e, responseBody}));
    }

    protected void handleSuccessMessage(int statusCode, byte[] responseBody) {
        this.onSuccess(statusCode, responseBody);
    }

    protected void handleFailureMessage(Throwable e, byte[] responseBody) {
        this.onFailure(e, responseBody);
    }

    @Override
    protected void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                Object[] response = (Object[])msg.obj;
                this.handleSuccessMessage((int)((Integer)response[0]), (byte[])response[1]);
                break;
            }
            case 1: {
                Object[] response = (Object[])msg.obj;
                this.handleFailureMessage((Throwable)response[0], (byte[])response[1]);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @Override
    void sendResponseMessage(HttpResponse response) {
        StatusLine status = response.getStatusLine();
        Header[] contentTypeHeaders = response.getHeaders("Content-Type");
        byte[] responseBody = null;
        if (contentTypeHeaders.length != 1) {
            this.sendFailureMessage((Throwable)new HttpResponseException(status.getStatusCode(), "None, or more than one, Content-Type Header found!"), responseBody);
            return;
        }
        Header contentTypeHeader = contentTypeHeaders[0];
        boolean foundAllowedContentType = false;
        for (String anAllowedContentType : mAllowedContentTypes) {
            if (!anAllowedContentType.equals(contentTypeHeader.getValue())) continue;
            foundAllowedContentType = true;
        }
        if (!foundAllowedContentType) {
            this.sendFailureMessage((Throwable)new HttpResponseException(status.getStatusCode(), "Content-Type not allowed!"), responseBody);
            return;
        }
        try {
            BufferedHttpEntity entity = null;
            HttpEntity temp = response.getEntity();
            if (temp != null) {
                entity = new BufferedHttpEntity(temp);
            }
            responseBody = EntityUtils.toByteArray(entity);
        }
        catch (IOException e) {
            this.sendFailureMessage((Throwable)e, (byte[])null);
        }
        if (status.getStatusCode() >= 300) {
            this.sendFailureMessage((Throwable)new HttpResponseException(status.getStatusCode(), status.getReasonPhrase()), responseBody);
        } else {
            this.sendSuccessMessage(status.getStatusCode(), responseBody);
        }
    }
}

