/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.TextHttpResponseHandler;
import cz.msebera.android.httpclient.Header;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonHttpResponseHandler
extends TextHttpResponseHandler {
    private static final String LOG_TAG = "JsonHttpRH";
    private boolean useRFC5179CompatibilityMode = true;

    public JsonHttpResponseHandler() {
        super("UTF-8");
    }

    public JsonHttpResponseHandler(String encoding) {
        super(encoding);
    }

    public JsonHttpResponseHandler(boolean useRFC5179CompatibilityMode) {
        super("UTF-8");
        this.useRFC5179CompatibilityMode = useRFC5179CompatibilityMode;
    }

    public JsonHttpResponseHandler(String encoding, boolean useRFC5179CompatibilityMode) {
        super(encoding);
        this.useRFC5179CompatibilityMode = useRFC5179CompatibilityMode;
    }

    public void onSuccess(int statusCode, Header[] headers, JSONObject response) {
        AsyncHttpClient.log.w(LOG_TAG, "onSuccess(int, Header[], JSONObject) was not overriden, but callback was received");
    }

    public void onSuccess(int statusCode, Header[] headers, JSONArray response) {
        AsyncHttpClient.log.w(LOG_TAG, "onSuccess(int, Header[], JSONArray) was not overriden, but callback was received");
    }

    public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
        AsyncHttpClient.log.w(LOG_TAG, "onFailure(int, Header[], Throwable, JSONObject) was not overriden, but callback was received", throwable);
    }

    public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONArray errorResponse) {
        AsyncHttpClient.log.w(LOG_TAG, "onFailure(int, Header[], Throwable, JSONArray) was not overriden, but callback was received", throwable);
    }

    @Override
    public void onFailure(int statusCode, Header[] headers, String responseString, Throwable throwable) {
        AsyncHttpClient.log.w(LOG_TAG, "onFailure(int, Header[], String, Throwable) was not overriden, but callback was received", throwable);
    }

    @Override
    public void onSuccess(int statusCode, Header[] headers, String responseString) {
        AsyncHttpClient.log.w(LOG_TAG, "onSuccess(int, Header[], String) was not overriden, but callback was received");
    }

    @Override
    public final void onSuccess(final int statusCode, final Header[] headers, final byte[] responseBytes) {
        if (statusCode != 204) {
            Runnable parser = new Runnable(){

                @Override
                public void run() {
                    try {
                        final Object jsonResponse = JsonHttpResponseHandler.this.parseResponse(responseBytes);
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                if (!JsonHttpResponseHandler.this.useRFC5179CompatibilityMode && jsonResponse == null) {
                                    JsonHttpResponseHandler.this.onSuccess(statusCode, headers, (String)null);
                                } else if (jsonResponse instanceof JSONObject) {
                                    JsonHttpResponseHandler.this.onSuccess(statusCode, headers, (JSONObject)jsonResponse);
                                } else if (jsonResponse instanceof JSONArray) {
                                    JsonHttpResponseHandler.this.onSuccess(statusCode, headers, (JSONArray)jsonResponse);
                                } else if (jsonResponse instanceof String) {
                                    if (JsonHttpResponseHandler.this.useRFC5179CompatibilityMode) {
                                        JsonHttpResponseHandler.this.onFailure(statusCode, headers, (String)jsonResponse, (Throwable)new JSONException("Response cannot be parsed as JSON data"));
                                    } else {
                                        JsonHttpResponseHandler.this.onSuccess(statusCode, headers, (String)jsonResponse);
                                    }
                                } else {
                                    JsonHttpResponseHandler.this.onFailure(statusCode, headers, (Throwable)new JSONException("Unexpected response type " + jsonResponse.getClass().getName()), (JSONObject)null);
                                }
                            }
                        });
                    }
                    catch (JSONException ex) {
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                JsonHttpResponseHandler.this.onFailure(statusCode, headers, (Throwable)ex, (JSONObject)null);
                            }
                        });
                    }
                }
            };
            if (!this.getUseSynchronousMode() && !this.getUsePoolThread()) {
                new Thread(parser).start();
            } else {
                parser.run();
            }
        } else {
            this.onSuccess(statusCode, headers, new JSONObject());
        }
    }

    @Override
    public final void onFailure(final int statusCode, final Header[] headers, final byte[] responseBytes, final Throwable throwable) {
        if (responseBytes != null) {
            Runnable parser = new Runnable(){

                @Override
                public void run() {
                    try {
                        final Object jsonResponse = JsonHttpResponseHandler.this.parseResponse(responseBytes);
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                if (!JsonHttpResponseHandler.this.useRFC5179CompatibilityMode && jsonResponse == null) {
                                    JsonHttpResponseHandler.this.onFailure(statusCode, headers, (String)null, throwable);
                                } else if (jsonResponse instanceof JSONObject) {
                                    JsonHttpResponseHandler.this.onFailure(statusCode, headers, throwable, (JSONObject)jsonResponse);
                                } else if (jsonResponse instanceof JSONArray) {
                                    JsonHttpResponseHandler.this.onFailure(statusCode, headers, throwable, (JSONArray)jsonResponse);
                                } else if (jsonResponse instanceof String) {
                                    JsonHttpResponseHandler.this.onFailure(statusCode, headers, (String)jsonResponse, throwable);
                                } else {
                                    JsonHttpResponseHandler.this.onFailure(statusCode, headers, (Throwable)new JSONException("Unexpected response type " + jsonResponse.getClass().getName()), (JSONObject)null);
                                }
                            }
                        });
                    }
                    catch (JSONException ex) {
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                JsonHttpResponseHandler.this.onFailure(statusCode, headers, (Throwable)ex, (JSONObject)null);
                            }
                        });
                    }
                }
            };
            if (!this.getUseSynchronousMode() && !this.getUsePoolThread()) {
                new Thread(parser).start();
            } else {
                parser.run();
            }
        } else {
            AsyncHttpClient.log.v(LOG_TAG, "response body is null, calling onFailure(Throwable, JSONObject)");
            this.onFailure(statusCode, headers, throwable, (JSONObject)null);
        }
    }

    protected Object parseResponse(byte[] responseBody) throws JSONException {
        if (null == responseBody) {
            return null;
        }
        Object result = null;
        String jsonString = JsonHttpResponseHandler.getResponseString(responseBody, this.getCharset());
        if (jsonString != null) {
            jsonString = jsonString.trim();
            if (this.useRFC5179CompatibilityMode) {
                if (jsonString.startsWith("{") || jsonString.startsWith("[")) {
                    result = new JSONTokener(jsonString).nextValue();
                }
            } else if (jsonString.startsWith("{") && jsonString.endsWith("}") || jsonString.startsWith("[") && jsonString.endsWith("]")) {
                result = new JSONTokener(jsonString).nextValue();
            } else if (jsonString.startsWith("\"") && jsonString.endsWith("\"")) {
                result = jsonString.substring(1, jsonString.length() - 1);
            }
        }
        if (result == null) {
            result = jsonString;
        }
        return result;
    }

    public boolean isUseRFC5179CompatibilityMode() {
        return this.useRFC5179CompatibilityMode;
    }

    public void setUseRFC5179CompatibilityMode(boolean useRFC5179CompatibilityMode) {
        this.useRFC5179CompatibilityMode = useRFC5179CompatibilityMode;
    }
}

