/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.utils;

import android.content.Context;
import android.os.Looper;
import com.loopeer.android.librarys.imagegroupview.utils.ImageUploadHandler;
import java.util.HashMap;
import java.util.Map;

public class ImageUploadHelper {
    private Context context;
    private OnImageUploadListener mListener;
    private ImageUploadHandler mHandler;
    private Thread mThread;

    public ImageUploadHelper(Context context) {
        this.context = context;
    }

    public void stopThread() {
        if (this.mThread != null) {
            this.mThread.interrupt();
            this.mThread = null;
        }
        if (this.mHandler != null) {
            this.mHandler = null;
        }
        if (this.mListener != null) {
            this.mListener = null;
        }
    }

    public void upload(final HashMap<String, String> map, OnImageUploadListener listener) {
        this.mListener = listener;
        this.mHandler = new ImageUploadHandler(listener);
        this.mThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                ImageUploadHelper.this.doUpload(map);
                Looper.loop();
            }
        });
        this.mThread.start();
    }

    private void doUpload(HashMap<String, String> map) {
        if (map == null || map.isEmpty()) {
            this.onFinish();
            return;
        }
        this.mHandler.onHandleStart();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() != null && entry.getKey() != null) break;
        }
    }

    private void doUploadImage(String url, String key, String token, HashMap<String, String> map) {
    }

    private void onFinish() {
        this.mHandler.onHandleComplete();
    }

    public static interface OnImageUploadListener {
        public void onImageUploadStart();

        public void onImageUploadComplete();
    }
}

