/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.fragment;

import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.facebook.binaryresource.BinaryResource;
import com.facebook.binaryresource.FileBinaryResource;
import com.facebook.cache.common.CacheKey;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.SimpleDraweeView;
import com.facebook.imagepipeline.cache.DefaultCacheKeyFactory;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.request.ImageRequest;
import com.loopeer.android.librarys.imagegroupview.OnTabOneClickListener;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.model.SquareImage;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.OnViewTapListener;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.PhotoDraweeView;
import com.loopeer.android.librarys.imagegroupview.utils.ImageDisplayHelper;
import java.io.File;
import java.io.FileNotFoundException;

public class ScaleImageFragment
extends Fragment {
    private SimpleDraweeView viewPlaceholder;
    private PhotoDraweeView viewScale;
    private OnTabOneClickListener listener;
    private SquareImage squareImage;
    private int placeholderDrawable;
    private View mUpPlaceHolderView;

    public static ScaleImageFragment newInstance(SquareImage image, int placeholderDrawable) {
        ScaleImageFragment scaleImageFragment = new ScaleImageFragment();
        scaleImageFragment.squareImage = image;
        scaleImageFragment.placeholderDrawable = placeholderDrawable;
        return scaleImageFragment;
    }

    public void setOneTabListener(OnTabOneClickListener listener) {
        this.listener = listener;
    }

    public void setSquareImage(SquareImage squareImage) {
        this.squareImage = squareImage;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_scale_image, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.updateView(view);
        this.setUpdata();
    }

    private void updateView(View view) {
        this.setUpPlaceHolderView(view);
        GenericDraweeHierarchyBuilder builder1 = new GenericDraweeHierarchyBuilder(this.getContext().getResources());
        builder1.setPlaceholderImage(ContextCompat.getDrawable((Context)this.getContext(), (int)this.placeholderDrawable), ScalingUtils.ScaleType.CENTER_CROP);
        this.viewScale = (PhotoDraweeView)view.findViewById(R.id.image_scale_image);
        this.viewScale.getAttacher().setOnViewTapListener(new OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                if (ScaleImageFragment.this.viewScale.getScale() == ScaleImageFragment.this.viewScale.getMinimumScale() && ScaleImageFragment.this.listener != null) {
                    ScaleImageFragment.this.listener.onTabOneClick();
                } else {
                    ScaleImageFragment.this.viewScale.getAttacher().setScale(ScaleImageFragment.this.viewScale.getMinimumScale(), x, y, true);
                }
            }
        });
        this.viewScale.getAttacher().setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)ScaleImageFragment.this.getActivity());
                builder.setMessage((CharSequence)"\u4fdd\u5b58\u8be5\u56fe\u7247\uff1f").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ScaleImageFragment.this.doSaveImage(((ScaleImageFragment)ScaleImageFragment.this).squareImage.interNetUrl);
                    }
                }).setNegativeButton((CharSequence)"\u53d6\u6d88", null);
                builder.show();
                return false;
            }
        });
    }

    private void doSaveImage(String imageUrl) {
        ImageRequest downloadRequest = ImageRequest.fromUri((Uri)Uri.parse((String)imageUrl));
        CacheKey cacheKey = DefaultCacheKeyFactory.getInstance().getEncodedCacheKey(downloadRequest, null);
        if (ImagePipelineFactory.getInstance().getMainDiskStorageCache().hasKey(cacheKey)) {
            BinaryResource resource = ImagePipelineFactory.getInstance().getMainDiskStorageCache().getResource(cacheKey);
            File cacheFile = ((FileBinaryResource)resource).getFile();
            try {
                MediaStore.Images.Media.insertImage((ContentResolver)this.getActivity().getContentResolver(), (String)cacheFile.getAbsolutePath(), (String)cacheFile.getName(), (String)"");
                Toast.makeText((Context)this.getActivity(), (CharSequence)"\u56fe\u7247\u4fdd\u5b58\u6210\u529f", (int)0).show();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.showErrorMessage();
            }
        } else {
            this.showErrorMessage();
        }
    }

    private void showErrorMessage() {
        Toast.makeText((Context)this.getActivity(), (CharSequence)"\u56fe\u7247\u6b63\u5728\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u4fdd\u5b58", (int)0).show();
    }

    private void setUpdata() {
        switch (this.squareImage.type) {
            case LOCAL: {
                ImageDisplayHelper.displayImageLocal(this.viewPlaceholder, this.squareImage.localUrl, 200, 200);
                ImageDisplayHelper.displayImageLocal(this.viewScale, this.squareImage.localUrl);
                break;
            }
            case NETWORK: {
                ImageDisplayHelper.displayImage(this.viewPlaceholder, this.squareImage.interNetUrl, 200, 200);
                ImageDisplayHelper.displayImage(this.viewScale, this.squareImage.interNetUrl);
            }
        }
    }

    public void setUpPlaceHolderView(View view) {
        this.viewPlaceholder = (SimpleDraweeView)view.findViewById(R.id.image_scale_placeholder);
        GenericDraweeHierarchyBuilder builder = new GenericDraweeHierarchyBuilder(this.getResources());
        GenericDraweeHierarchy hierarchy = builder.setFadeDuration(300).setPlaceholderImage(ContextCompat.getDrawable((Context)this.getContext(), (int)this.placeholderDrawable)).build();
        this.viewPlaceholder.setHierarchy((DraweeHierarchy)hierarchy);
    }
}

