/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.photodraweeview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.view.DraweeView;
import com.facebook.drawee.view.SimpleDraweeView;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.Attacher;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.IAttacher;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.OnPhotoTapListener;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.OnScaleChangeListener;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.OnViewTapListener;
import com.loopeer.android.librarys.imagegroupview.utils.DisplayUtils;

public class PhotoDraweeView
extends SimpleDraweeView
implements IAttacher {
    private Attacher mAttacher;
    private float mImageHeight;
    private float mImageWidth;
    private float mCenterX;
    private float mCenterY;
    private Matrix mMatrix;

    public PhotoDraweeView(Context context, GenericDraweeHierarchy hierarchy) {
        super(context, hierarchy);
        this.init();
    }

    public PhotoDraweeView(Context context) {
        super(context);
        this.init();
    }

    public PhotoDraweeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PhotoDraweeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        if (this.mAttacher == null || this.mAttacher.getDraweeView() == null) {
            this.mAttacher = new Attacher((DraweeView<GenericDraweeHierarchy>)this);
        }
        this.initImageSize();
        this.mMatrix = new Matrix();
    }

    private void initImageSize() {
        this.mImageWidth = DisplayUtils.getScreenWidth(this.getContext());
        this.mImageHeight = DisplayUtils.getScreenHeight(this.getContext()) - DisplayUtils.getStatusBarHeight(this.getContext());
        this.mCenterX = this.mImageWidth / 2.0f;
        this.mCenterY = this.mImageHeight / 2.0f;
    }

    public void setImageHeight(float height) {
        this.mImageHeight = height;
    }

    public float getImageHeight() {
        return this.mImageHeight;
    }

    public float getImageWidth() {
        return this.mImageWidth;
    }

    public float getCenterX() {
        return this.mCenterX;
    }

    public float getCenterY() {
        return this.mCenterY;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    protected void onDraw(@NonNull Canvas canvas) {
        canvas.concat(this.mMatrix);
        int saveCount = canvas.save();
        canvas.concat(this.mAttacher.getDrawMatrix());
        super.onDraw(canvas);
        canvas.restoreToCount(saveCount);
    }

    protected void onAttachedToWindow() {
        this.init();
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.mAttacher.onDetachedFromWindow();
        super.onDetachedFromWindow();
    }

    @Override
    public float getMinimumScale() {
        return this.mAttacher.getMinimumScale();
    }

    @Override
    public float getMediumScale() {
        return this.mAttacher.getMediumScale();
    }

    @Override
    public float getMaximumScale() {
        return this.mAttacher.getMaximumScale();
    }

    @Override
    public void setMinimumScale(float minimumScale) {
        this.mAttacher.setMinimumScale(minimumScale);
    }

    @Override
    public void setMediumScale(float mediumScale) {
        this.mAttacher.setMediumScale(mediumScale);
    }

    @Override
    public void setMaximumScale(float maximumScale) {
        this.mAttacher.setMaximumScale(maximumScale);
    }

    @Override
    public float getScale() {
        return this.mAttacher.getScale();
    }

    @Override
    public void setScale(float scale) {
        this.mAttacher.setScale(scale);
    }

    @Override
    public void setScale(float scale, boolean animate) {
        this.mAttacher.setScale(scale, animate);
    }

    @Override
    public void setScale(float scale, float focalX, float focalY, boolean animate) {
        this.mAttacher.setScale(scale, focalX, focalY, animate);
    }

    public void setScale(float scalex, float scaley) {
        this.mMatrix.setScale(1.0f + scalex, 1.0f + scaley, (float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredWidth() / 2));
        this.invalidate();
    }

    @Override
    public void setZoomTransitionDuration(long duration) {
        this.mAttacher.setZoomTransitionDuration(duration);
    }

    @Override
    public void setAllowParentInterceptOnEdge(boolean allow) {
        this.mAttacher.setAllowParentInterceptOnEdge(allow);
    }

    @Override
    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener listener) {
        this.mAttacher.setOnDoubleTapListener(listener);
    }

    @Override
    public void setOnScaleChangeListener(OnScaleChangeListener listener) {
        this.mAttacher.setOnScaleChangeListener(listener);
    }

    @Override
    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.mAttacher.setOnLongClickListener(listener);
    }

    @Override
    public void setOnPhotoTapListener(OnPhotoTapListener listener) {
        this.mAttacher.setOnPhotoTapListener(listener);
    }

    @Override
    public void setOnViewTapListener(OnViewTapListener listener) {
        this.mAttacher.setOnViewTapListener(listener);
    }

    @Override
    public OnPhotoTapListener getOnPhotoTapListener() {
        return this.mAttacher.getOnPhotoTapListener();
    }

    @Override
    public OnViewTapListener getOnViewTapListener() {
        return this.mAttacher.getOnViewTapListener();
    }

    @Override
    public void update(int imageInfoWidth, int imageInfoHeight) {
        this.mAttacher.update(imageInfoWidth, imageInfoHeight);
    }

    public Attacher getAttacher() {
        return this.mAttacher;
    }
}

