/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.fragment;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Animatable;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.facebook.binaryresource.BinaryResource;
import com.facebook.binaryresource.FileBinaryResource;
import com.facebook.cache.common.CacheKey;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.SimpleDraweeView;
import com.facebook.imagepipeline.cache.DefaultCacheKeyFactory;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import com.loopeer.android.librarys.imagegroupview.OnTabOneClickListener;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.model.SquareImage;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.OnViewTapListener;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.PhotoDraweeView;
import com.loopeer.android.librarys.imagegroupview.utils.ImageDisplayHelper;
import com.loopeer.android.librarys.imagegroupview.view.DragDismissFrameLayout;
import java.io.File;
import java.io.FileNotFoundException;

public class ScaleImageFragment
extends Fragment {
    private SimpleDraweeView mPlaceholderImage;
    private PhotoDraweeView mScaleImage;
    private OnTabOneClickListener listener;
    private SquareImage squareImage;
    private int placeholderDrawable;
    private DragDismissFrameLayout mDismissFrameLayout;
    private ProgressBar mProgressBar;
    private ControllerListener mControllerListener = new BaseControllerListener<ImageInfo>(){

        public void onFinalImageSet(String id2, ImageInfo imageInfo, Animatable animatable) {
            super.onFinalImageSet(id2, (Object)imageInfo, animatable);
            if (imageInfo == null) {
                return;
            }
            ScaleImageFragment.this.mProgressBar.setVisibility(4);
            ScaleImageFragment.this.mPlaceholderImage.setVisibility(4);
            ScaleImageFragment.this.mScaleImage.setImageHeight((float)imageInfo.getHeight() / (float)imageInfo.getWidth() * ScaleImageFragment.this.mScaleImage.getImageWidth());
            ScaleImageFragment.this.mScaleImage.update(imageInfo.getWidth(), imageInfo.getHeight());
        }
    };

    public static ScaleImageFragment newInstance(SquareImage image, int placeholderDrawable) {
        ScaleImageFragment scaleImageFragment = new ScaleImageFragment();
        scaleImageFragment.squareImage = image;
        scaleImageFragment.placeholderDrawable = placeholderDrawable;
        return scaleImageFragment;
    }

    public void setOneTabListener(OnTabOneClickListener listener) {
        this.listener = listener;
    }

    public void setSquareImage(SquareImage squareImage) {
        this.squareImage = squareImage;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_scale_image, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mPlaceholderImage = (SimpleDraweeView)view.findViewById(R.id.image_scale_placeholder);
        this.mDismissFrameLayout = (DragDismissFrameLayout)view.findViewById(R.id.container_layout);
        this.mScaleImage = (PhotoDraweeView)view.findViewById(R.id.image_scale_image);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.progress_scale_image);
        this.mDismissFrameLayout.setPhotoDraweeView(this.mScaleImage);
        this.setUpPlaceHolderView();
        this.setViewScaleListener();
        this.setupData();
    }

    public View getDismissFrameLayout() {
        return this.mDismissFrameLayout;
    }

    public View getScaleImage() {
        return this.mScaleImage;
    }

    public View getPlaceholderImage() {
        return this.mPlaceholderImage;
    }

    private void setViewScaleListener() {
        this.mScaleImage.getAttacher().setOnViewTapListener(new OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                if (ScaleImageFragment.this.mScaleImage.getScale() == ScaleImageFragment.this.mScaleImage.getMinimumScale() && ScaleImageFragment.this.listener != null) {
                    ScaleImageFragment.this.listener.onTabOneClick();
                } else {
                    ScaleImageFragment.this.mScaleImage.getAttacher().setScale(ScaleImageFragment.this.mScaleImage.getMinimumScale(), x, y, true);
                }
            }
        });
        this.mScaleImage.getAttacher().setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)ScaleImageFragment.this.getActivity());
                builder.setMessage((CharSequence)"\u4fdd\u5b58\u8be5\u56fe\u7247\uff1f").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        ScaleImageFragment.this.doSaveImage(((ScaleImageFragment)ScaleImageFragment.this).squareImage.interNetUrl);
                    }
                }).setNegativeButton((CharSequence)"\u53d6\u6d88", null);
                builder.show();
                return false;
            }
        });
    }

    public void setUpPlaceHolderView() {
        this.mProgressBar.setVisibility(0);
        GenericDraweeHierarchyBuilder builder = new GenericDraweeHierarchyBuilder(this.getResources());
        GenericDraweeHierarchy hierarchy = builder.setFadeDuration(300).setPlaceholderImage(ContextCompat.getDrawable((Context)this.getContext(), (int)this.placeholderDrawable)).setPlaceholderImageScaleType(ScalingUtils.ScaleType.CENTER_CROP).build();
        this.mPlaceholderImage.setHierarchy((DraweeHierarchy)hierarchy);
    }

    private void setupData() {
        switch (this.squareImage.type) {
            case LOCAL: {
                ImageDisplayHelper.displayImageLocal(this.mPlaceholderImage, this.squareImage.localUrl, 200, 200);
                ImageDisplayHelper.displayImageLocal(this.mScaleImage, this.squareImage.localUrl, this.mControllerListener);
                break;
            }
            case NETWORK: {
                ImageDisplayHelper.displayImage(this.mPlaceholderImage, this.squareImage.interNetUrl, 200, 200);
                ImageDisplayHelper.displayImage(this.mScaleImage, this.squareImage.interNetUrl, this.mControllerListener);
            }
        }
    }

    private void doSaveImage(String imageUrl) {
        ImageRequest downloadRequest = ImageRequest.fromUri((Uri)Uri.parse((String)imageUrl));
        CacheKey cacheKey = DefaultCacheKeyFactory.getInstance().getEncodedCacheKey(downloadRequest, null);
        if (ImagePipelineFactory.getInstance().getMainFileCache().hasKey(cacheKey)) {
            BinaryResource resource = ImagePipelineFactory.getInstance().getMainFileCache().getResource(cacheKey);
            File cacheFile = ((FileBinaryResource)resource).getFile();
            try {
                MediaStore.Images.Media.insertImage((ContentResolver)this.getActivity().getContentResolver(), (String)cacheFile.getAbsolutePath(), (String)cacheFile.getName(), (String)"");
                Toast.makeText((Context)this.getActivity(), (CharSequence)"\u56fe\u7247\u4fdd\u5b58\u6210\u529f", (int)0).show();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.showErrorMessage();
            }
        } else {
            this.showErrorMessage();
        }
    }

    private void showErrorMessage() {
        Toast.makeText((Context)this.getActivity(), (CharSequence)"\u56fe\u7247\u6b63\u5728\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u4fdd\u5b58", (int)0).show();
    }
}

