/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.utils;

import android.graphics.drawable.Animatable;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.SimpleDraweeView;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.PhotoDraweeView;
import java.io.File;

public final class ImageDisplayHelper {
    public static Uri createNetWorkImageUri(String path) {
        return Uri.parse((String)path);
    }

    public static void displayImage(final SimpleDraweeView draweeView, String path, final int failPlaceHolder) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        BaseControllerListener<ImageInfo> controllerListener = new BaseControllerListener<ImageInfo>(){

            public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable anim) {
                if (imageInfo == null) {
                    return;
                }
            }

            public void onIntermediateImageSet(String id2, @Nullable ImageInfo imageInfo) {
            }

            public void onFailure(String id2, Throwable throwable) {
                draweeView.setImageResource(failPlaceHolder);
            }
        };
        Uri uri = ImageDisplayHelper.createNetWorkImageUri(path);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setControllerListener((ControllerListener)controllerListener)).setUri(uri).setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImage(final SimpleDraweeView draweeView, String path, final int failPlaceHolder, int width, int height) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        BaseControllerListener<ImageInfo> controllerListener = new BaseControllerListener<ImageInfo>(){

            public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable anim) {
                if (imageInfo == null) {
                    return;
                }
            }

            public void onIntermediateImageSet(String id2, @Nullable ImageInfo imageInfo) {
            }

            public void onFailure(String id2, Throwable throwable) {
                draweeView.setImageResource(failPlaceHolder);
            }
        };
        Uri uri = ImageDisplayHelper.createNetWorkImageUri(path);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(width, height)).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setControllerListener((ControllerListener)controllerListener)).setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImage(SimpleDraweeView draweeView, String path, int width, int height) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        Uri uri = ImageDisplayHelper.createNetWorkImageUri(path);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(width, height)).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImage(SimpleDraweeView draweeView, Uri uri, int width, int height) {
        if (draweeView == null || uri == null) {
            return;
        }
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(width, height)).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImage(SimpleDraweeView draweeView, String path) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        Uri uri = ImageDisplayHelper.createNetWorkImageUri(path);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImage(PhotoDraweeView draweeView, String path, ControllerListener listener) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        Uri uri = ImageDisplayHelper.createNetWorkImageUri(path);
        PipelineDraweeControllerBuilder controller = Fresco.newDraweeControllerBuilder();
        controller.setUri(uri);
        controller.setOldController(draweeView.getController());
        controller.setControllerListener(listener);
        draweeView.setController((DraweeController)controller.build());
    }

    public static void displayImageLocal(SimpleDraweeView draweeView, String path) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        Uri uri = Uri.fromFile((File)new File(path));
        draweeView.setImageURI(uri);
    }

    public static void displayImageLocal(PhotoDraweeView draweeView, String path, ControllerListener listener) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        Uri uri = Uri.fromFile((File)new File(path));
        PipelineDraweeControllerBuilder controller = Fresco.newDraweeControllerBuilder();
        controller.setUri(uri);
        controller.setOldController(draweeView.getController());
        controller.setControllerListener(listener);
        draweeView.setController((DraweeController)controller.build());
    }

    public static void displayImageLocal(SimpleDraweeView draweeView, String path, int width, int height) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        Uri uri = Uri.fromFile((File)new File(path));
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(width, height)).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImageLocal(SimpleDraweeView draweeView, Uri uri, int width, int height) {
        if (draweeView == null || uri == null) {
            return;
        }
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(width, height)).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void setImageScaleType(SimpleDraweeView draweeView, ScalingUtils.ScaleType scaleType) {
        ((GenericDraweeHierarchy)draweeView.getHierarchy()).setActualImageScaleType(scaleType);
    }
}

