/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.photodraweeview;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.widget.ScrollerCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.view.DraweeView;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.DefaultOnDoubleTapListener;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.IAttacher;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.OnPhotoTapListener;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.OnScaleChangeListener;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.OnScaleDragGestureListener;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.OnViewTapListener;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.ScaleDragDetector;
import java.lang.ref.WeakReference;

public class Attacher
implements IAttacher,
View.OnTouchListener,
OnScaleDragGestureListener {
    private static final int EDGE_NONE = -1;
    private static final int EDGE_LEFT = 0;
    private static final int EDGE_RIGHT = 1;
    private static final int EDGE_BOTH = 2;
    private final float[] mMatrixValues = new float[9];
    private final RectF mDisplayRect = new RectF();
    private final Interpolator mZoomInterpolator = new AccelerateDecelerateInterpolator();
    private float mMinScale = 1.0f;
    private float mMidScale = 1.75f;
    private float mMaxScale = 3.0f;
    private long mZoomDuration = 200L;
    private ScaleDragDetector mScaleDragDetector;
    private GestureDetectorCompat mGestureDetector;
    private boolean mBlockParentIntercept = false;
    private boolean mAllowParentInterceptOnEdge = true;
    private int mScrollEdge = 2;
    private final Matrix mMatrix = new Matrix();
    private int mImageInfoHeight = -1;
    private int mImageInfoWidth = -1;
    private FlingRunnable mCurrentFlingRunnable;
    private WeakReference<DraweeView<GenericDraweeHierarchy>> mDraweeView;
    private OnPhotoTapListener mPhotoTapListener;
    private OnViewTapListener mViewTapListener;
    private View.OnLongClickListener mLongClickListener;
    private OnScaleChangeListener mScaleChangeListener;

    public Attacher(DraweeView<GenericDraweeHierarchy> draweeView) {
        this.mDraweeView = new WeakReference<DraweeView<GenericDraweeHierarchy>>(draweeView);
        ((GenericDraweeHierarchy)draweeView.getHierarchy()).setActualImageScaleType(ScalingUtils.ScaleType.FIT_CENTER);
        draweeView.setOnTouchListener((View.OnTouchListener)this);
        this.mScaleDragDetector = new ScaleDragDetector(draweeView.getContext(), this);
        this.mGestureDetector = new GestureDetectorCompat(draweeView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent e) {
                super.onLongPress(e);
                if (null != Attacher.this.mLongClickListener && ((DraweeView)Attacher.this.mDraweeView.get()).getTranslationX() == 0.0f && ((DraweeView)Attacher.this.mDraweeView.get()).getScaleX() == 1.0f) {
                    Attacher.this.mLongClickListener.onLongClick(Attacher.this.getDraweeView());
                }
            }
        });
        this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new DefaultOnDoubleTapListener(this));
    }

    @Override
    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener newOnDoubleTapListener) {
        if (newOnDoubleTapListener != null) {
            this.mGestureDetector.setOnDoubleTapListener(newOnDoubleTapListener);
        } else {
            this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new DefaultOnDoubleTapListener(this));
        }
    }

    public int getImageInfoWidth() {
        return this.mImageInfoWidth;
    }

    public int getImageInfoHeight() {
        return this.mImageInfoHeight;
    }

    @Nullable
    public DraweeView<GenericDraweeHierarchy> getDraweeView() {
        return (DraweeView)this.mDraweeView.get();
    }

    @Override
    public float getMinimumScale() {
        return this.mMinScale;
    }

    @Override
    public float getMediumScale() {
        return this.mMidScale;
    }

    @Override
    public float getMaximumScale() {
        return this.mMaxScale;
    }

    @Override
    public void setMaximumScale(float maximumScale) {
        Attacher.checkZoomLevels(this.mMinScale, this.mMidScale, maximumScale);
        this.mMaxScale = maximumScale;
    }

    @Override
    public void setMediumScale(float mediumScale) {
        Attacher.checkZoomLevels(this.mMinScale, mediumScale, this.mMaxScale);
        this.mMidScale = mediumScale;
    }

    @Override
    public void setMinimumScale(float minimumScale) {
        Attacher.checkZoomLevels(minimumScale, this.mMidScale, this.mMaxScale);
        this.mMinScale = minimumScale;
    }

    @Override
    public float getScale() {
        return (float)Math.sqrt((float)Math.pow(this.getMatrixValue(this.mMatrix, 0), 2.0) + (float)Math.pow(this.getMatrixValue(this.mMatrix, 3), 2.0));
    }

    @Override
    public void setScale(float scale) {
        this.setScale(scale, false);
    }

    @Override
    public void setScale(float scale, boolean animate) {
        DraweeView<GenericDraweeHierarchy> draweeView = this.getDraweeView();
        if (draweeView != null) {
            this.setScale(scale, draweeView.getRight() / 2, draweeView.getBottom() / 2, false);
        }
    }

    @Override
    public void setScale(float scale, float focalX, float focalY, boolean animate) {
        DraweeView<GenericDraweeHierarchy> draweeView = this.getDraweeView();
        if (draweeView == null || scale < this.mMinScale || scale > this.mMaxScale) {
            return;
        }
        if (animate) {
            draweeView.post((Runnable)new AnimatedZoomRunnable(this.getScale(), scale, focalX, focalY));
        } else {
            this.mMatrix.setScale(scale, scale, focalX, focalY);
            this.checkMatrixAndInvalidate();
        }
    }

    @Override
    public void setZoomTransitionDuration(long duration) {
        this.mZoomDuration = duration = duration < 0L ? 200L : duration;
    }

    @Override
    public void setAllowParentInterceptOnEdge(boolean allow) {
        this.mAllowParentInterceptOnEdge = allow;
    }

    @Override
    public void setOnScaleChangeListener(OnScaleChangeListener listener) {
        this.mScaleChangeListener = listener;
    }

    @Override
    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.mLongClickListener = listener;
    }

    @Override
    public void setOnPhotoTapListener(OnPhotoTapListener listener) {
        this.mPhotoTapListener = listener;
    }

    @Override
    public void setOnViewTapListener(OnViewTapListener listener) {
        this.mViewTapListener = listener;
    }

    @Override
    public OnPhotoTapListener getOnPhotoTapListener() {
        return this.mPhotoTapListener;
    }

    @Override
    public OnViewTapListener getOnViewTapListener() {
        return this.mViewTapListener;
    }

    @Override
    public void update(int imageInfoWidth, int imageInfoHeight) {
        this.mImageInfoWidth = imageInfoWidth;
        this.mImageInfoHeight = imageInfoHeight;
        this.updateBaseMatrix();
    }

    private static void checkZoomLevels(float minZoom, float midZoom, float maxZoom) {
        if (minZoom >= midZoom) {
            throw new IllegalArgumentException("MinZoom has to be less than MidZoom");
        }
        if (midZoom >= maxZoom) {
            throw new IllegalArgumentException("MidZoom has to be less than MaxZoom");
        }
    }

    private int getViewWidth() {
        DraweeView<GenericDraweeHierarchy> draweeView = this.getDraweeView();
        if (draweeView != null) {
            return draweeView.getWidth() - draweeView.getPaddingLeft() - draweeView.getPaddingRight();
        }
        return 0;
    }

    private int getViewHeight() {
        DraweeView<GenericDraweeHierarchy> draweeView = this.getDraweeView();
        if (draweeView != null) {
            return draweeView.getHeight() - draweeView.getPaddingTop() - draweeView.getPaddingBottom();
        }
        return 0;
    }

    private float getMatrixValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    public Matrix getDrawMatrix() {
        return this.mMatrix;
    }

    public RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDrawMatrix());
    }

    public void checkMatrixAndInvalidate() {
        DraweeView<GenericDraweeHierarchy> draweeView = this.getDraweeView();
        if (draweeView == null) {
            return;
        }
        if (this.checkMatrixBounds()) {
            draweeView.invalidate();
        }
    }

    public boolean checkMatrixBounds() {
        RectF rect = this.getDisplayRect(this.getDrawMatrix());
        if (rect == null) {
            return false;
        }
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int viewHeight = this.getViewHeight();
        if (height <= (float)viewHeight) {
            deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
        } else if (rect.top > 0.0f) {
            deltaY = -rect.top;
        } else if (rect.bottom < (float)viewHeight) {
            deltaY = (float)viewHeight - rect.bottom;
        }
        int viewWidth = this.getViewWidth();
        if (width <= (float)viewWidth) {
            deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
            this.mScrollEdge = 2;
        } else if (rect.left > 0.0f) {
            deltaX = -rect.left;
            this.mScrollEdge = 0;
        } else if (rect.right < (float)viewWidth) {
            deltaX = (float)viewWidth - rect.right;
            this.mScrollEdge = 1;
        } else {
            this.mScrollEdge = -1;
        }
        this.mMatrix.postTranslate(deltaX, deltaY);
        return true;
    }

    private RectF getDisplayRect(Matrix matrix) {
        DraweeView<GenericDraweeHierarchy> draweeView = this.getDraweeView();
        if (draweeView == null || this.mImageInfoWidth == -1 && this.mImageInfoHeight == -1) {
            return null;
        }
        this.mDisplayRect.set(0.0f, 0.0f, (float)this.mImageInfoWidth, (float)this.mImageInfoHeight);
        ((GenericDraweeHierarchy)draweeView.getHierarchy()).getActualImageBounds(this.mDisplayRect);
        matrix.mapRect(this.mDisplayRect);
        return this.mDisplayRect;
    }

    private void updateBaseMatrix() {
        if (this.mImageInfoWidth == -1 && this.mImageInfoHeight == -1) {
            return;
        }
        this.resetMatrix();
    }

    private void resetMatrix() {
        this.mMatrix.reset();
        this.checkMatrixBounds();
        DraweeView<GenericDraweeHierarchy> draweeView = this.getDraweeView();
        if (draweeView != null) {
            draweeView.invalidate();
        }
    }

    private void checkMinScale() {
        RectF rect;
        DraweeView<GenericDraweeHierarchy> draweeView = this.getDraweeView();
        if (draweeView == null) {
            return;
        }
        if (this.getScale() < this.mMinScale && null != (rect = this.getDisplayRect())) {
            draweeView.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.mMinScale, rect.centerX(), rect.centerY()));
        }
    }

    @Override
    public void onScale(float scaleFactor, float focusX, float focusY) {
        if (this.getScale() < this.mMaxScale || scaleFactor < 1.0f) {
            if (this.mScaleChangeListener != null) {
                this.mScaleChangeListener.onScaleChange(scaleFactor, focusX, focusY);
            }
            this.mMatrix.postScale(scaleFactor, scaleFactor, focusX, focusY);
            this.checkMatrixAndInvalidate();
        }
    }

    @Override
    public void onScaleEnd() {
        this.checkMinScale();
    }

    @Override
    public void onDrag(float dx, float dy) {
        DraweeView<GenericDraweeHierarchy> draweeView = this.getDraweeView();
        if (draweeView != null && !this.mScaleDragDetector.isScaling()) {
            this.mMatrix.postTranslate(dx, dy);
            this.checkMatrixAndInvalidate();
            ViewParent parent = draweeView.getParent();
            if (parent == null) {
                return;
            }
            if (this.mAllowParentInterceptOnEdge && !this.mScaleDragDetector.isScaling() && !this.mBlockParentIntercept) {
                if (this.mScrollEdge == 2 || this.mScrollEdge == 0 && dx >= 1.0f || this.mScrollEdge == 1 && dx <= -1.0f) {
                    parent.requestDisallowInterceptTouchEvent(false);
                }
            } else {
                parent.requestDisallowInterceptTouchEvent(true);
            }
        }
    }

    @Override
    public void onFling(float startX, float startY, float velocityX, float velocityY) {
        DraweeView<GenericDraweeHierarchy> draweeView = this.getDraweeView();
        if (draweeView == null) {
            return;
        }
        this.mCurrentFlingRunnable = new FlingRunnable(draweeView.getContext());
        this.mCurrentFlingRunnable.fling(this.getViewWidth(), this.getViewHeight(), (int)velocityX, (int)velocityY);
        draweeView.post((Runnable)this.mCurrentFlingRunnable);
    }

    public boolean onTouch(View v, MotionEvent event) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        switch (action) {
            case 0: {
                ViewParent parent = v.getParent();
                if (parent != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                this.cancelFling();
                break;
            }
            case 1: 
            case 3: {
                ViewParent parent = v.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(false);
            }
        }
        boolean wasScaling = this.mScaleDragDetector.isScaling();
        boolean wasDragging = this.mScaleDragDetector.isDragging();
        boolean handled = this.mScaleDragDetector.onTouchEvent(event);
        boolean noScale = !wasScaling && !this.mScaleDragDetector.isScaling();
        boolean noDrag = !wasDragging && !this.mScaleDragDetector.isDragging();
        boolean bl = this.mBlockParentIntercept = noScale && noDrag;
        if (this.mGestureDetector.onTouchEvent(event)) {
            handled = true;
        }
        return handled;
    }

    private void cancelFling() {
        if (this.mCurrentFlingRunnable != null) {
            this.mCurrentFlingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    private void postOnAnimation(View view, Runnable runnable) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.postOnAnimation(runnable);
        } else {
            view.postDelayed(runnable, 16L);
        }
    }

    protected void onDetachedFromWindow() {
        this.cancelFling();
    }

    private class FlingRunnable
    implements Runnable {
        private final ScrollerCompat mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable(Context context) {
            this.mScroller = ScrollerCompat.create((Context)context);
        }

        public void cancelFling() {
            this.mScroller.abortAnimation();
        }

        public void fling(int viewWidth, int viewHeight, int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            RectF rect = Attacher.this.getDisplayRect();
            if (null == rect) {
                return;
            }
            int startX = Math.round(-rect.left);
            if ((float)viewWidth < rect.width()) {
                minX = 0;
                maxX = Math.round(rect.width() - (float)viewWidth);
            } else {
                minX = maxX = startX;
            }
            int startY = Math.round(-rect.top);
            if ((float)viewHeight < rect.height()) {
                minY = 0;
                maxY = Math.round(rect.height() - (float)viewHeight);
            } else {
                minY = maxY = startY;
            }
            this.mCurrentX = startX;
            this.mCurrentY = startY;
            if (startX != maxX || startY != maxY) {
                this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
            }
        }

        @Override
        public void run() {
            if (this.mScroller.isFinished()) {
                return;
            }
            DraweeView<GenericDraweeHierarchy> draweeView = Attacher.this.getDraweeView();
            if (draweeView != null && this.mScroller.computeScrollOffset()) {
                int newX = this.mScroller.getCurrX();
                int newY = this.mScroller.getCurrY();
                Attacher.this.mMatrix.postTranslate((float)(this.mCurrentX - newX), (float)(this.mCurrentY - newY));
                draweeView.invalidate();
                this.mCurrentX = newX;
                this.mCurrentY = newY;
                Attacher.this.postOnAnimation(draweeView, this);
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        private final float mFocalX;
        private final float mFocalY;
        private final long mStartTime;
        private final float mZoomStart;
        private final float mZoomEnd;

        public AnimatedZoomRunnable(float currentZoom, float targetZoom, float focalX, float focalY) {
            this.mFocalX = focalX;
            this.mFocalY = focalY;
            this.mStartTime = System.currentTimeMillis();
            this.mZoomStart = currentZoom;
            this.mZoomEnd = targetZoom;
        }

        @Override
        public void run() {
            DraweeView<GenericDraweeHierarchy> draweeView = Attacher.this.getDraweeView();
            if (draweeView == null) {
                return;
            }
            float t = this.interpolate();
            float scale = this.mZoomStart + t * (this.mZoomEnd - this.mZoomStart);
            float deltaScale = scale / Attacher.this.getScale();
            Attacher.this.onScale(deltaScale, this.mFocalX, this.mFocalY);
            if (t < 1.0f) {
                Attacher.this.postOnAnimation(draweeView, this);
            }
        }

        private float interpolate() {
            float t = 1.0f * (float)(System.currentTimeMillis() - this.mStartTime) / (float)Attacher.this.mZoomDuration;
            t = Math.min(1.0f, t);
            t = Attacher.this.mZoomInterpolator.getInterpolation(t);
            return t;
        }
    }
}

