/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.provider.MediaStore;
import com.loopeer.android.librarys.imagegroupview.utils.DisplayUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageUtils {
    public static Bitmap imageZoom(Context context, Bitmap bitMap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitMap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        if (baos.toByteArray().length / 1024 > 200) {
            baos.reset();
            bitMap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)baos);
        }
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        int picWidth = newOpts.outWidth;
        int picHeight = newOpts.outHeight;
        int screenWidth = DisplayUtils.getScreenWidth(context);
        int screenHeight = DisplayUtils.getScreenHeight(context);
        newOpts.inSampleSize = 1;
        if (picWidth > picHeight) {
            if (picWidth > screenWidth) {
                newOpts.inSampleSize = picWidth / screenWidth;
            }
        } else if (picHeight > screenHeight) {
            newOpts.inSampleSize = picHeight / screenHeight;
        }
        newOpts.inJustDecodeBounds = false;
        isBm = new ByteArrayInputStream(baos.toByteArray());
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        return bitmap;
    }

    public static byte[] compressImage(Bitmap bitmap) {
        return ImageUtils.compressImage(bitmap, 100.0);
    }

    public static byte[] compressImage(Bitmap bitmap, double mSize) {
        double maxSize = 100.0;
        if (mSize > 0.0) {
            maxSize = mSize;
        }
        int option = 100;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, option, (OutputStream)baos);
        byte[] b = baos.toByteArray();
        double mid = b.length / 1024;
        while (mid > maxSize) {
            baos.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, option -= 10, (OutputStream)baos);
            mid = baos.toByteArray().length / 1024;
            if (option != 30) continue;
            break;
        }
        return baos.toByteArray();
    }

    public static Bitmap imageZoomByScreen(Context context, String uri) {
        int degree = ImageUtils.readPictureDegree(uri);
        BitmapFactory.Options opt = new BitmapFactory.Options();
        opt.inJustDecodeBounds = true;
        Bitmap bm = BitmapFactory.decodeFile((String)uri, (BitmapFactory.Options)opt);
        int picWidth = opt.outWidth;
        int picHeight = opt.outHeight;
        int screenWidth = DisplayUtils.getScreenWidth(context);
        int screenHeight = DisplayUtils.getScreenHeight(context);
        opt.inSampleSize = 1;
        if (picWidth > picHeight) {
            if (picWidth > screenWidth) {
                opt.inSampleSize = picWidth / screenWidth;
            }
        } else if (picHeight > screenHeight) {
            opt.inSampleSize = picHeight / screenHeight;
        }
        opt.inJustDecodeBounds = false;
        bm = BitmapFactory.decodeFile((String)uri, (BitmapFactory.Options)opt);
        bm = ImageUtils.rotateBitmap(bm, degree);
        return bm;
    }

    private static Bitmap zoomImage(Bitmap bgimage, double newWidth, double newHeight) {
        float width = bgimage.getWidth();
        float height = bgimage.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)newWidth / width;
        float scaleHeight = (float)newHeight / height;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bitmap = bgimage;
        try {
            bitmap = Bitmap.createBitmap((Bitmap)bgimage, (int)0, (int)0, (int)((int)width), (int)((int)height), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        return bitmap;
    }

    private static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    private static Bitmap rotateBitmap(Bitmap bitmap, int rotate) {
        if (bitmap == null) {
            return null;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Matrix mtx = new Matrix();
        mtx.postRotate((float)rotate);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)mtx, (boolean)true);
    }

    public static String getPathOfPhotoByUri(Context context, Uri uri) {
        String[] filePathColumn = new String[]{"_data"};
        Cursor cursor = MediaStore.Images.Media.query((ContentResolver)context.getContentResolver(), (Uri)uri, (String[])filePathColumn);
        cursor.moveToFirst();
        int columnIndex = cursor.getColumnIndex(filePathColumn[0]);
        String picturePath = cursor.getString(columnIndex);
        cursor.close();
        return picturePath;
    }
}

