/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.utils;

import android.graphics.Bitmap;
import android.graphics.drawable.Animatable;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.ViewGroup;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.SimpleDraweeView;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.BasePostprocessor;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import java.io.File;

public final class ImageGroupDisplayHelper {
    public static Uri createNetWorkImageUri(String path) {
        return Uri.parse((String)path);
    }

    public static void displayImage(final SimpleDraweeView draweeView, String path, final int failPlaceHolder) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        BaseControllerListener<ImageInfo> controllerListener = new BaseControllerListener<ImageInfo>(){

            public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable anim) {
                if (imageInfo == null) {
                    return;
                }
            }

            public void onIntermediateImageSet(String id2, @Nullable ImageInfo imageInfo) {
            }

            public void onFailure(String id2, Throwable throwable) {
                draweeView.setImageResource(failPlaceHolder);
            }
        };
        Uri uri = ImageGroupDisplayHelper.createNetWorkImageUri(path);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setControllerListener((ControllerListener)controllerListener)).setUri(uri).setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImage(final SimpleDraweeView draweeView, String path, final int failPlaceHolder, int width, int height) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        BaseControllerListener<ImageInfo> controllerListener = new BaseControllerListener<ImageInfo>(){

            public void onFinalImageSet(String id2, @Nullable ImageInfo imageInfo, @Nullable Animatable anim) {
                if (imageInfo == null) {
                    return;
                }
            }

            public void onIntermediateImageSet(String id2, @Nullable ImageInfo imageInfo) {
            }

            public void onFailure(String id2, Throwable throwable) {
                draweeView.setImageResource(failPlaceHolder);
            }
        };
        Uri uri = ImageGroupDisplayHelper.createNetWorkImageUri(path);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(width, height)).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setControllerListener((ControllerListener)controllerListener)).setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImage(SimpleDraweeView draweeView, String path, int width, int height) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        Uri uri = ImageGroupDisplayHelper.createNetWorkImageUri(path);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(width, height)).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImage(SimpleDraweeView draweeView, Uri uri, int width, int height) {
        if (draweeView == null || uri == null) {
            return;
        }
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(width, height)).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImage(SimpleDraweeView draweeView, String path) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        Uri uri = ImageGroupDisplayHelper.createNetWorkImageUri(path);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImageOneShow(final SimpleDraweeView draweeView, String path, final int maxSize) {
        if (draweeView == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        BasePostprocessor reSizeProcessor = new BasePostprocessor(){

            public String getName() {
                return "redMeshPostprocessor";
            }

            public void process(Bitmap bitmap) {
                int width = bitmap.getWidth();
                int height = bitmap.getHeight();
                ViewGroup.LayoutParams layoutParams = draweeView.getLayoutParams();
                int tmp = maxSize;
                if (width < height) {
                    width = width * tmp / height;
                    height = tmp;
                } else {
                    height = height * tmp / width;
                    width = tmp;
                }
                layoutParams.width = width;
                layoutParams.height = height;
                draweeView.setLayoutParams(layoutParams);
            }
        };
        Uri uri = ImageGroupDisplayHelper.createNetWorkImageUri(path);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(500, 500)).setAutoRotateEnabled(true).setPostprocessor((Postprocessor)reSizeProcessor).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImageLocal(SimpleDraweeView draweeView, String path, int width, int height) {
        if (draweeView == null) {
            return;
        }
        Uri uri = TextUtils.isEmpty((CharSequence)path) ? null : Uri.fromFile((File)new File(path));
        ImageRequest request = null;
        if (uri != null) {
            request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(width, height)).setAutoRotateEnabled(true).build();
        }
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest(request)).build();
        draweeView.setController((DraweeController)controller);
    }

    public static void displayImageLocal(SimpleDraweeView draweeView, Uri uri, int width, int height) {
        if (draweeView == null || uri == null) {
            return;
        }
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setResizeOptions(new ResizeOptions(width, height)).setAutoRotateEnabled(true).build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).build();
        draweeView.setController((DraweeController)controller);
    }
}

