/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.view;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.util.AttributeSet;
import android.view.View;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.view.SimpleDraweeView;
import com.loopeer.android.librarys.imagegroupview.NavigatorImage;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.model.Image;
import com.loopeer.android.librarys.imagegroupview.model.SquareImage;
import com.loopeer.android.librarys.imagegroupview.utils.ImageGroupDisplayHelper;
import java.util.List;

public class SingleImageView
extends SimpleDraweeView
implements View.OnClickListener {
    private SquareImage mImage;
    private int mPlaceholderDrawable;

    public SingleImageView(Context context, GenericDraweeHierarchy hierarchy) {
        super(context, hierarchy);
        this.init();
    }

    public SingleImageView(Context context) {
        super(context);
        this.init();
    }

    public SingleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setOnClickListener(this);
        this.mImage = new SquareImage();
    }

    public void doUpLoadPhotoClick() {
        this.doUpLoadPhotoClick(1, 1);
    }

    public void doUpLoadPhotoClick(final int aspectRatioX, final int aspectRatioY) {
        new AlertDialog.Builder(this.getContext()).setItems((CharSequence[])new String[]{this.getContext().getString(R.string.take_photo), this.getContext().getString(R.string.select_images)}, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == 0) {
                    SingleImageView.this.doTakePhoto(aspectRatioX, aspectRatioY);
                } else {
                    SingleImageView.this.doAlbum(aspectRatioX, aspectRatioY);
                }
            }
        }).show();
    }

    public void doTakePhoto(int aspectRatioX, int aspectRatioY) {
        NavigatorImage.startAvatarAlbumActivity(this.getContext(), this.getId(), 1, aspectRatioX, aspectRatioY);
    }

    public void doAlbum(int aspectRatioX, int aspectRatioY) {
        NavigatorImage.startAvatarAlbumActivity(this.getContext(), this.getId(), 2, aspectRatioX, aspectRatioY);
    }

    public void onClick(View v) {
        this.doUpLoadPhotoClick();
    }

    public void onParentResult(int requestCode, Intent data) {
        if (data == null) {
            return;
        }
        List images = (List)((Object)data.getSerializableExtra("extra_photos_url"));
        if (requestCode == 2005 && null != images) {
            this.refreshLocalImage(((Image)images.get((int)0)).url);
        }
    }

    private void refreshLocalImage(String url) {
        this.mImage.localUrl = url;
        this.updateView();
    }

    private void updateView() {
        if (this.mImage.localUrl != null) {
            ImageGroupDisplayHelper.displayImageLocal((SimpleDraweeView)this, this.mImage.localUrl, 100, 100);
        } else if (this.mImage.interNetUrl != null) {
            ImageGroupDisplayHelper.displayImage(this, this.mImage.interNetUrl, this.mPlaceholderDrawable, 100, 100);
        } else {
            this.setImageResource(this.mPlaceholderDrawable);
        }
    }

    public void updateImage(SquareImage squareImage) {
        this.mImage = squareImage;
        this.updateView();
    }

    public String getLocalUrl() {
        if (this.mImage == null) {
            return null;
        }
        return this.mImage.localUrl;
    }

    @NonNull
    private String getPhotoKey() {
        return "image_" + System.currentTimeMillis();
    }
}

