/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import com.loopeer.android.librarys.imagegroupview.model.SquareImage;
import com.loopeer.android.librarys.imagegroupview.view.SquareImageView;
import java.util.ArrayList;
import java.util.List;

public class GridImageAdapter
extends BaseAdapter {
    private Context mContext;
    private List<SquareImage> mData;
    private OnSquareClickListener mClickListener;
    private int mAddButtonDrawable;
    private int mPlaceholderDrawable;
    private boolean mRoundAsCircle;

    public GridImageAdapter(Context c, OnSquareClickListener listener) {
        this.mContext = c;
        this.mData = new ArrayList<SquareImage>();
        this.mClickListener = listener;
    }

    public void updateParam(int addButtonDrawable, int placeholderDrawable, boolean roundAsCircle) {
        this.mAddButtonDrawable = addButtonDrawable;
        this.mPlaceholderDrawable = placeholderDrawable;
        this.mRoundAsCircle = roundAsCircle;
        this.notifyDataSetChanged();
    }

    public void updateData(List<SquareImage> datas, boolean showAddButton) {
        this.setData(datas, showAddButton);
        this.notifyDataSetChanged();
    }

    public void setData(List<SquareImage> datas, boolean showAddButton) {
        this.mData.clear();
        this.mData.addAll(datas);
        if (showAddButton) {
            this.mData.add(null);
        }
    }

    public int getCount() {
        return this.mData.size();
    }

    public SquareImage getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        SquareImageView squareView;
        if (convertView == null || !convertView.getTag().equals(this.getTag(position))) {
            squareView = new SquareImageView(this.mContext);
            squareView.setPlaceholderDrawable(this.mPlaceholderDrawable);
            squareView.setRoundAsCircle(this.mRoundAsCircle);
            squareView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -2));
            squareView.setTag(this.getTag(position));
        } else {
            squareView = (SquareImageView)convertView;
        }
        this.bindData(squareView, position);
        return squareView;
    }

    @NonNull
    private String getTag(int position) {
        return "POSITION" + position;
    }

    private void bindData(SquareImageView squareView, final int position) {
        if (this.getItem(position) == null) {
            squareView.setImageResource(this.mAddButtonDrawable);
        } else {
            squareView.setImageData(this.getItem(position));
        }
        squareView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GridImageAdapter.this.mClickListener.photoClick(v, GridImageAdapter.this.getItem(position), position);
            }
        });
    }

    public static interface OnSquareClickListener {
        public void photoClick(View var1, SquareImage var2, int var3);
    }
}

