/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.view;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.RequiresApi;
import android.support.v4.view.NestedScrollingParent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.utils.AnimUtils;
import java.util.ArrayList;
import java.util.List;

public class ElasticDragDismissFrameLayout
extends FrameLayout
implements NestedScrollingParent {
    private float dragDismissDistance = Float.MAX_VALUE;
    private float dragDismissFraction = -1.0f;
    private float dragDismissScale = 1.0f;
    private boolean shouldScale = false;
    private float dragElacticity = 0.8f;
    private float totalDrag;
    private boolean draggingDown = false;
    private boolean draggingUp = false;
    private List<ElasticDragDismissCallback> callbacks;

    public ElasticDragDismissFrameLayout(Context context) {
        this(context, null);
    }

    public ElasticDragDismissFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ElasticDragDismissFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @RequiresApi(api=21)
    public ElasticDragDismissFrameLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    protected void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ElasticDragDismissFrameLayout, 0, 0);
        if (a.hasValue(R.styleable.ElasticDragDismissFrameLayout_dragDismissDistance)) {
            this.dragDismissDistance = a.getDimensionPixelSize(R.styleable.ElasticDragDismissFrameLayout_dragDismissDistance, 0);
        } else if (a.hasValue(R.styleable.ElasticDragDismissFrameLayout_dragDismissFraction)) {
            this.dragDismissFraction = a.getFloat(R.styleable.ElasticDragDismissFrameLayout_dragDismissFraction, this.dragDismissFraction);
        }
        if (a.hasValue(R.styleable.ElasticDragDismissFrameLayout_dragDismissScale)) {
            this.dragDismissScale = a.getFloat(R.styleable.ElasticDragDismissFrameLayout_dragDismissScale, this.dragDismissScale);
            boolean bl = this.shouldScale = this.dragDismissScale != 1.0f;
        }
        if (a.hasValue(R.styleable.ElasticDragDismissFrameLayout_dragElasticity)) {
            this.dragElacticity = a.getFloat(R.styleable.ElasticDragDismissFrameLayout_dragElasticity, this.dragElacticity);
        }
        a.recycle();
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (this.draggingDown && dy > 0 || this.draggingUp && dy < 0) {
            this.dragScale(dy);
            consumed[1] = dy;
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dragScale(dyUnconsumed);
    }

    public void onStopNestedScroll(View child) {
        if (Math.abs(this.totalDrag) >= this.dragDismissDistance) {
            this.dispatchDismissCallback();
        } else {
            this.animate().translationY(0.0f).scaleX(1.0f).scaleY(1.0f).setDuration(200L).setInterpolator((TimeInterpolator)AnimUtils.getFastOutSlowInInterpolator(this.getContext())).setListener(null).start();
            this.totalDrag = 0.0f;
            this.draggingUp = false;
            this.draggingDown = false;
            this.dispatchDragCallback(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.dragDismissFraction > 0.0f) {
            this.dragDismissDistance = (float)h * this.dragDismissFraction;
        }
    }

    public void addListener(ElasticDragDismissCallback listener) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<ElasticDragDismissCallback>();
        }
        this.callbacks.add(listener);
    }

    public void removeListener(ElasticDragDismissCallback listener) {
        if (this.callbacks != null && this.callbacks.size() > 0) {
            this.callbacks.remove(listener);
        }
    }

    private void dragScale(int scroll) {
        if (scroll == 0) {
            return;
        }
        this.totalDrag += (float)scroll;
        if (scroll < 0 && !this.draggingUp && !this.draggingDown) {
            this.draggingDown = true;
            if (this.shouldScale) {
                this.setPivotY(this.getHeight());
            }
        } else if (scroll > 0 && !this.draggingDown && !this.draggingUp) {
            this.draggingUp = true;
            if (this.shouldScale) {
                this.setPivotY(0.0f);
            }
        }
        float dragFraction = (float)Math.log10(1.0f + Math.abs(this.totalDrag) / this.dragDismissDistance);
        float dragTo = dragFraction * this.dragDismissDistance * this.dragElacticity;
        if (this.draggingUp) {
            dragTo *= -1.0f;
        }
        this.setTranslationY(dragTo);
        if (this.shouldScale) {
            float scale = 1.0f - (1.0f - this.dragDismissScale) * dragFraction;
            this.setScaleX(scale);
            this.setScaleY(scale);
        }
        if (this.draggingDown && this.totalDrag >= 0.0f || this.draggingUp && this.totalDrag <= 0.0f) {
            dragFraction = 0.0f;
            dragTo = 0.0f;
            this.totalDrag = 0.0f;
            this.draggingUp = false;
            this.draggingDown = false;
            this.setTranslationY(0.0f);
            this.setScaleX(1.0f);
            this.setScaleY(1.0f);
        }
        this.dispatchDragCallback(dragFraction, dragTo, Math.min(1.0f, Math.abs(this.totalDrag) / this.dragDismissDistance), this.totalDrag);
    }

    private void dispatchDragCallback(float elasticOffset, float elasticOffsetPixels, float rawOffset, float rawOffsetPixels) {
        if (this.callbacks != null && !this.callbacks.isEmpty()) {
            for (ElasticDragDismissCallback callback : this.callbacks) {
                callback.onDrag(elasticOffset, elasticOffsetPixels, rawOffset, rawOffsetPixels);
            }
        }
    }

    private void dispatchDismissCallback() {
        if (this.callbacks != null && !this.callbacks.isEmpty()) {
            for (ElasticDragDismissCallback callback : this.callbacks) {
                callback.onDragDismissed();
            }
        }
    }

    public static abstract class ElasticDragDismissCallback {
        public void onDrag(float elasticOffset, float elasticOffsetPixels, float rawOffset, float rawOffsetPixels) {
        }

        public void onDragDismissed() {
        }
    }
}

