/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.view;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.AccelerateInterpolator;
import android.widget.FrameLayout;
import com.loopeer.android.librarys.imagegroupview.OnTabOneClickListener;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.PhotoDraweeView;
import com.loopeer.android.librarys.imagegroupview.utils.DisplayUtils;

public class DragDismissFrameLayout
extends FrameLayout {
    private PhotoDraweeView mPhotoDraweeView;
    private int mScreenHeight;
    private int mDragDismissDistance;
    private int mBlackColor;
    private int mWhiteColor;
    private boolean mIsMoving;
    private boolean mDragDismiss = true;
    float downX;
    float downY;
    float moveX;
    float moveY;

    public DragDismissFrameLayout(Context context) {
        this(context, null);
    }

    public DragDismissFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DragDismissFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setDragDismiss(boolean dragDismiss) {
        this.mDragDismiss = dragDismiss;
    }

    private void init() {
        this.mScreenHeight = DisplayUtils.getScreenHeight(this.getContext());
        this.mDragDismissDistance = this.mScreenHeight / 8;
        this.mBlackColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.scale_bg_black);
        this.mWhiteColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.scale_bg_white);
    }

    public void setPhotoDraweeView(PhotoDraweeView photoDraweeView) {
        this.mPhotoDraweeView = photoDraweeView;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (!this.mDragDismiss || this.mPhotoDraweeView == null) {
            return super.dispatchTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.downX = event.getX();
                this.downY = event.getY();
                break;
            }
            case 2: {
                this.moveX = event.getX();
                this.moveY = event.getY();
                if (!this.mIsMoving && this.mPhotoDraweeView.getScale() == this.mPhotoDraweeView.getMinimumScale() && this.moveY > this.downY && Math.abs(this.moveY - this.downY) > Math.abs(this.moveX - this.downX)) {
                    this.mIsMoving = true;
                }
                if (!this.mIsMoving) break;
                this.mPhotoDraweeView.setTranslationX(this.moveX - this.downX);
                this.mPhotoDraweeView.setTranslationY(this.moveY - this.downY);
                float scale = this.calculateScale(this.moveY - this.downY);
                this.mPhotoDraweeView.setScaleX(scale);
                this.mPhotoDraweeView.setScaleY(scale);
                this.setBackgroundColor(this.calculateColor(this.calculateColorFraction(this.moveY - this.downY), this.mBlackColor, this.mWhiteColor));
                break;
            }
            case 1: 
            case 3: {
                if (this.mIsMoving) {
                    this.moveTouchUp();
                }
                this.mIsMoving = false;
            }
        }
        return super.dispatchTouchEvent(event);
    }

    private void moveTouchUp() {
        if (this.mPhotoDraweeView.getTranslationY() >= (float)this.mDragDismissDistance) {
            if (this.getContext() instanceof OnTabOneClickListener) {
                ((OnTabOneClickListener)this.getContext()).onTabOneClick();
            }
        } else {
            this.doRestoreAnimation();
        }
    }

    private void doRestoreAnimation() {
        this.setBackgroundColor(this.mBlackColor);
        this.mPhotoDraweeView.animate().scaleX(1.0f).scaleY(1.0f).translationX(0.0f).translationY(0.0f).setDuration(100L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).start();
    }

    private float calculateScale(float distance) {
        if (this.mPhotoDraweeView.getTranslationY() <= 0.0f) {
            return 1.0f;
        }
        return 1.0f - Math.abs(distance) / (float)this.mScreenHeight;
    }

    private float calculateColorFraction(float distance) {
        if (this.mPhotoDraweeView.getTranslationY() <= 0.0f) {
            return 0.0f;
        }
        return Math.abs(distance) / (float)this.mScreenHeight;
    }

    public int calculateColor(float fraction, int startColor, int endColor) {
        int startA = startColor >> 24 & 0xFF;
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endA = endColor >> 24 & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
    }
}

