/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.activity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.util.Property;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.loopeer.android.librarys.imagegroupview.OnTabOneClickListener;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.adapter.ImagesSwitcherAdapter;
import com.loopeer.android.librarys.imagegroupview.fragment.ScaleImageFragment;
import com.loopeer.android.librarys.imagegroupview.model.ImageSwitcherWrapper;
import com.loopeer.android.librarys.imagegroupview.model.SquareImage;
import com.loopeer.android.librarys.imagegroupview.photodraweeview.PhotoDraweeView;
import com.loopeer.android.librarys.imagegroupview.view.DragDismissFrameLayout;
import com.loopeer.android.librarys.imagegroupview.view.MutipleTouchViewPager;
import java.util.ArrayList;

public class ImageSwitcherActivity
extends AppCompatActivity
implements OnTabOneClickListener {
    private MutipleTouchViewPager mViewPager;
    private ArrayList<ImageSwitcherWrapper> mImageSwitcherWrappers;
    private ImagesSwitcherAdapter mAdapter;
    private boolean canImageDelete;
    private int mCurrentPagerPosition;
    private int placeholderDrawable;
    private ArrayList<Integer> mDeletePositions;
    private ImageView mBtnDelete;
    private int mImageGroupId;
    private FrameLayout mDragDismissFrameLayout;
    private boolean mDragDismiss;
    private FrameLayout mDragLayout;

    protected void onCreate(Bundle savedInstanceState) {
        this.overridePendingTransition(0, 0);
        this.getWindow().setFlags(1024, 1024);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_switcher);
        this.mDragDismissFrameLayout = (FrameLayout)this.findViewById(R.id.drag_frame);
        this.mDeletePositions = new ArrayList();
        this.parseIntent();
        this.updateView();
        this.updateData();
        this.mDragDismissFrameLayout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ImageSwitcherActivity.this.mDragDismissFrameLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                ImageSwitcherActivity.this.doAnimation(true);
            }
        });
    }

    private void doAnimation(final boolean isEnter) {
        int[] bgColor;
        float[] translationY;
        float[] translationX;
        float[] scaleY;
        float[] scaleX;
        ScaleImageFragment imageFragment = this.mAdapter.getFragmentByPosition(this.mCurrentPagerPosition);
        PhotoDraweeView photoDraweeView = (PhotoDraweeView)imageFragment.getScaleImage();
        DragDismissFrameLayout dismissFrameLayout = (DragDismissFrameLayout)imageFragment.getDismissFrameLayout();
        dismissFrameLayout.setDragDismiss(this.mDragDismiss);
        float width = photoDraweeView.getImageWidth();
        float height = photoDraweeView.getImageHeight();
        int blackColor = ContextCompat.getColor((Context)this, (int)R.color.scale_bg_black);
        int whiteColor = ContextCompat.getColor((Context)this, (int)R.color.scale_bg_white);
        SquareImage squareImage = this.mImageSwitcherWrappers.get((int)this.mCurrentPagerPosition).squareImage;
        float distanceX = squareImage.getCenterX() - photoDraweeView.getCenterX();
        float distanceY = squareImage.getCenterY() - photoDraweeView.getCenterY();
        if (isEnter) {
            photoDraweeView.setScaleX((float)squareImage.width / width);
            photoDraweeView.setScaleY((float)squareImage.height / height);
            photoDraweeView.setTranslationX(distanceX);
            photoDraweeView.setTranslationY(distanceY);
            scaleX = new float[]{photoDraweeView.getScaleX(), 1.0f};
            scaleY = new float[]{photoDraweeView.getScaleY(), 1.0f};
            translationX = new float[]{distanceX, 0.0f};
            translationY = new float[]{distanceY, 0.0f};
            bgColor = new int[]{whiteColor, blackColor};
        } else {
            scaleX = new float[]{photoDraweeView.getScaleX(), (float)squareImage.width / width};
            scaleY = new float[]{photoDraweeView.getScaleY(), (float)squareImage.height / height};
            translationX = new float[]{photoDraweeView.getTranslationX(), distanceX};
            translationY = new float[]{photoDraweeView.getTranslationY(), distanceY};
            bgColor = new int[]{((ColorDrawable)dismissFrameLayout.getBackground()).getColor(), whiteColor};
        }
        ObjectAnimator sX = ObjectAnimator.ofFloat((Object)photoDraweeView, (Property)View.SCALE_X, (float[])scaleX);
        ObjectAnimator sY = ObjectAnimator.ofFloat((Object)photoDraweeView, (Property)View.SCALE_Y, (float[])scaleY);
        ObjectAnimator tX = ObjectAnimator.ofFloat((Object)photoDraweeView, (Property)View.TRANSLATION_X, (float[])translationX);
        ObjectAnimator tY = ObjectAnimator.ofFloat((Object)photoDraweeView, (Property)View.TRANSLATION_Y, (float[])translationY);
        ObjectAnimator bg = ObjectAnimator.ofInt((Object)((Object)dismissFrameLayout), (String)"backgroundColor", (int[])bgColor);
        bg.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        bg.setDuration(125L);
        AnimatorSet animatorSet = new AnimatorSet();
        if (isEnter) {
            animatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        } else {
            animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        }
        animatorSet.setDuration(250L);
        animatorSet.play((Animator)sX).with((Animator)sY).with((Animator)tX).with((Animator)tY);
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!isEnter) {
                    ImageSwitcherActivity.this.finish();
                    ImageSwitcherActivity.this.overridePendingTransition(0, 0);
                }
            }
        });
        bg.start();
        animatorSet.start();
    }

    private void parseIntent() {
        Intent intent = this.getIntent();
        ArrayList images = intent.getParcelableArrayListExtra("image_url");
        this.setUpImageWrappers(images);
        this.mImageGroupId = intent.getIntExtra("extra_image_group_id", 0);
        this.mCurrentPagerPosition = intent.getIntExtra("image_position", 0);
        this.canImageDelete = intent.getBooleanExtra("extra_image_delete", false);
        this.placeholderDrawable = intent.getIntExtra("extra_image_place_drawable_id", R.drawable.ic_image_default);
        this.mDragDismiss = intent.getBooleanExtra("extra_drag_dismiss", true);
    }

    private void setUpImageWrappers(ArrayList<SquareImage> images) {
        this.mImageSwitcherWrappers = new ArrayList();
        for (int i = 0; i < images.size(); ++i) {
            this.mImageSwitcherWrappers.add(new ImageSwitcherWrapper(images.get(i), i));
        }
    }

    private void updateView() {
        this.mViewPager = (MutipleTouchViewPager)this.findViewById(R.id.view_pager);
        this.mBtnDelete = (ImageView)this.findViewById(R.id.btn_delete);
        this.mDragLayout = (FrameLayout)this.findViewById(R.id.drag_frame);
        this.mBtnDelete.setVisibility(this.canImageDelete ? 0 : 8);
        this.mBtnDelete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageSwitcherActivity.this.deleteImage();
            }
        });
        this.setUpView();
    }

    private void setUpView() {
        this.mAdapter = new ImagesSwitcherAdapter(this.getSupportFragmentManager(), this.placeholderDrawable);
        this.mAdapter.setOnTabOneClickListener(this);
        this.mViewPager.setAdapter(this.mAdapter);
        this.mViewPager.setPageMargin(this.getResources().getDimensionPixelSize(R.dimen.view_pager_page_margin));
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ImageSwitcherActivity.this.mCurrentPagerPosition = position;
                ImageSwitcherActivity.this.updatePositionText();
            }

            public void onPageScrollStateChanged(int state) {
                if (state == 0) {
                    ImageSwitcherActivity.this.mDragLayout.setBackgroundColor(0);
                } else {
                    ImageSwitcherActivity.this.mDragLayout.setBackgroundResource(R.color.scale_bg_black);
                }
            }
        });
    }

    protected void updatePositionText() {
        ((TextView)this.findViewById(R.id.text_bottom)).setText((CharSequence)(this.mCurrentPagerPosition + 1 + "/" + this.mImageSwitcherWrappers.size()));
    }

    private void updateData() {
        this.mAdapter.setImages(this.createShowImages());
        this.setCurrentPosition();
        this.updatePositionText();
    }

    private ArrayList<SquareImage> createShowImages() {
        ArrayList<SquareImage> squareImages = new ArrayList<SquareImage>();
        for (ImageSwitcherWrapper imageSwitcherWrapper : this.mImageSwitcherWrappers) {
            squareImages.add(imageSwitcherWrapper.squareImage);
        }
        return squareImages;
    }

    private void setCurrentPosition() {
        this.mViewPager.setCurrentItem(this.mCurrentPagerPosition);
    }

    private void deleteImage() {
        this.mDeletePositions.add(this.mImageSwitcherWrappers.get((int)this.mCurrentPagerPosition).originPosition);
        this.updateImagesPosition();
        this.mImageSwitcherWrappers.remove(this.mCurrentPagerPosition);
        if (this.mImageSwitcherWrappers.size() == 0) {
            this.goBackWithResult(false);
        } else if (this.mCurrentPagerPosition == this.mImageSwitcherWrappers.size()) {
            --this.mCurrentPagerPosition;
            this.updateData();
        } else {
            this.updateData();
        }
    }

    private void updateImagesPosition() {
        if (this.mCurrentPagerPosition == this.mImageSwitcherWrappers.size() - 1) {
            return;
        }
        for (int i = this.mCurrentPagerPosition; i < this.mImageSwitcherWrappers.size() - 1; ++i) {
            SquareImage squareImage = this.mImageSwitcherWrappers.get((int)i).squareImage;
            this.mImageSwitcherWrappers.get((int)(i + 1)).squareImage.setPosition(squareImage.left, squareImage.top, squareImage.width, squareImage.height);
        }
    }

    public void onBackPressed() {
        this.goBackWithResult(true);
    }

    private void goBackWithResult(boolean doAnimation) {
        Intent intent = new Intent();
        intent.putExtra("image_position", this.mDeletePositions);
        intent.putExtra("extra_image_group_id", this.mImageGroupId);
        this.setResult(-1, intent);
        if (doAnimation) {
            this.doAnimation(false);
        } else {
            this.finish();
            this.overridePendingTransition(0, 0);
        }
    }

    @Override
    public void onTabOneClick() {
        this.goBackWithResult(true);
    }
}

