/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.view;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.SimpleDraweeView;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.model.SquareImage;
import com.loopeer.android.librarys.imagegroupview.utils.ImageGroupDisplayHelper;

public class SquareImageView
extends SimpleDraweeView
implements View.OnClickListener {
    private String mLocalUrl;
    private String mUploadKey;
    private String mInternetUrl;
    private int placeholderDrawable;
    private int width;
    private boolean mClickUpload = true;

    public SquareImageView(Context context) {
        this(context, null);
    }

    public SquareImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SquareImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.placeholderDrawable = R.drawable.ic_image_default;
        this.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.setClickable(this.mClickUpload);
        this.setOnClickListener(this);
        GenericDraweeHierarchyBuilder builder1 = new GenericDraweeHierarchyBuilder(this.getContext().getResources());
        builder1.setPlaceholderImage(ContextCompat.getDrawable((Context)this.getContext(), (int)this.placeholderDrawable), ScalingUtils.ScaleType.CENTER_CROP);
        this.getControllerBuilder().build().setHierarchy((DraweeHierarchy)builder1.build());
    }

    public void setWidthByParent(int widthByParent) {
        this.width = widthByParent;
    }

    public void setPlaceholderDrawable(int src) {
        this.placeholderDrawable = src;
        ((GenericDraweeHierarchy)this.getHierarchy()).setPlaceholderImage(this.placeholderDrawable);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(SquareImageView.getDefaultSize((int)0, (int)widthMeasureSpec), SquareImageView.getDefaultSize((int)0, (int)heightMeasureSpec));
        int childWidthSize = this.getMeasuredWidth();
        heightMeasureSpec = widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setLocalUrl(final String localUrl) {
        if (!TextUtils.isEmpty((CharSequence)this.mInternetUrl)) {
            this.mInternetUrl = null;
        }
        if (this.getHeight() == 0) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    SquareImageView.this.setLocalUrl(localUrl);
                }
            });
            return;
        }
        this.mLocalUrl = localUrl;
        ImageGroupDisplayHelper.displayImageLocal((SimpleDraweeView)this, this.mLocalUrl, this.getWidth(), this.getHeight());
    }

    public void setmInternetUrl(String internetUrl) {
        this.mInternetUrl = internetUrl;
    }

    public void setUploadKey(String key) {
        this.mUploadKey = key;
    }

    public String getUploadImageKey() {
        return this.mUploadKey;
    }

    public String getLocalUrl() {
        return this.mLocalUrl;
    }

    public String getImageLocalUrl() {
        return this.mLocalUrl;
    }

    public String getInternetUrl() {
        return this.mInternetUrl;
    }

    public void setInternetData(final String netUrl) {
        this.mInternetUrl = netUrl;
        this.mLocalUrl = null;
        if (netUrl == null) {
            this.setImageResource(this.placeholderDrawable);
            return;
        }
        if (this.getHeight() == 0) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    SquareImageView.this.setInternetData(netUrl);
                }
            });
            return;
        }
        ImageGroupDisplayHelper.displayImage(this, this.mInternetUrl, this.placeholderDrawable, this.getWidth(), this.getHeight());
    }

    public void setImageData(SquareImage squareImage) {
        if (squareImage.localUrl != null) {
            this.setLocalUrl(squareImage.localUrl);
        }
        if (squareImage.interNetUrl != null) {
            this.setInternetData(squareImage.interNetUrl);
        }
        if (squareImage.urlKey != null) {
            this.setUploadKey(squareImage.urlKey);
        }
    }

    public void setClickAble(boolean able) {
        this.mClickUpload = able;
    }

    public void onClick(View v) {
        if (this.mClickUpload) {
            // empty if block
        }
    }

    public View getSquareImage() {
        return null;
    }

    public void setRoundAsCircle(boolean flag) {
        if (!flag) {
            return;
        }
        RoundingParams roundingParams = RoundingParams.fromCornersRadius((float)5.0f);
        roundingParams.setRoundAsCircle(flag);
        ((GenericDraweeHierarchy)this.getHierarchy()).setRoundingParams(roundingParams);
    }
}

