/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.view;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.loopeer.android.librarys.imagegroupview.NavigatorImage;
import com.loopeer.android.librarys.imagegroupview.OnImageClickListener;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.model.Image;
import com.loopeer.android.librarys.imagegroupview.model.SquareImage;
import com.loopeer.android.librarys.imagegroupview.utils.Album;
import com.loopeer.android.librarys.imagegroupview.utils.DisplayUtils;
import com.loopeer.android.librarys.imagegroupview.utils.ImageGroupSavedState;
import com.loopeer.android.librarys.imagegroupview.view.GridImageAdapter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ImageGridView
extends GridView
implements GridImageAdapter.OnSquareClickListener {
    private static final int MAX_VALUE = -1;
    private ImageGroupSavedState imageGroupSavedState;
    private List<SquareImage> preImages;
    private OnImageClickListener clickListener;
    private int mAddButtonDrawable;
    private int mPlaceholderDrawable;
    private boolean mShowAddButton;
    private boolean mRoundAsCircle;
    private int maxImageNum;
    private boolean mDragDismiss;
    private GridImageAdapter mGridImageAdapter;
    private Album mAlbum;

    public ImageGridView(Context context) {
        this(context, null);
    }

    public ImageGridView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.getAttrs(context, attrs, defStyle);
        this.init();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int expandSpec = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        super.onMeasure(widthMeasureSpec, expandSpec);
    }

    private void getAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ImageGroupView, defStyleAttr, 0);
        if (a == null) {
            return;
        }
        this.mShowAddButton = a.getBoolean(R.styleable.ImageGroupView_showAddButton, false);
        this.mRoundAsCircle = false;
        this.maxImageNum = a.getInteger(R.styleable.ImageGroupView_maxImageNum, -1);
        this.mAddButtonDrawable = a.getResourceId(R.styleable.ImageGroupView_addButtonDrawable, R.drawable.ic_photo_default);
        this.mPlaceholderDrawable = a.getResourceId(R.styleable.ImageGroupView_imagePlaceholderDrawable, R.drawable.ic_image_default);
        this.mDragDismiss = a.getBoolean(R.styleable.ImageGroupView_dragDismiss, true);
        a.recycle();
    }

    private void init() {
        this.mAlbum = new Album(this.getContext());
        this.preImages = new ArrayList<SquareImage>();
        this.mGridImageAdapter = new GridImageAdapter(this.getContext(), this);
        this.setAdapter((ListAdapter)this.mGridImageAdapter);
        this.updateImages();
    }

    public void setAlbumOptions(Album.Options options) {
        this.mAlbum.withOptions(options);
    }

    private void updateImages() {
        this.mGridImageAdapter.updateData(this.preImages, this.mShowAddButton && (this.getCanSelectMaxNum() != 0 || this.maxImageNum == -1));
        this.mGridImageAdapter.updateParam(this.mAddButtonDrawable, this.mPlaceholderDrawable, this.mRoundAsCircle);
    }

    private void updateImagesPosition() {
        int[] position = new int[2];
        this.getLocationOnScreen(position);
        int columnWidth = this.getColumnWidth();
        int numColumns = this.getNumColumns();
        int horizontalSpacing = this.getHorizontalSpacing();
        int verticalSpacing = this.getVerticalSpacing();
        for (int i = 0; i < this.preImages.size(); ++i) {
            int left = position[0] + this.getPaddingLeft() + i % numColumns * columnWidth + i % numColumns * horizontalSpacing;
            int top = position[1] + this.getPaddingTop() - DisplayUtils.getStatusBarHeight(this.getContext()) + i / numColumns * columnWidth + i / numColumns * verticalSpacing;
            this.preImages.get(i).setPosition(left, top, columnWidth, columnWidth);
        }
    }

    public void setGridImageAdapter(GridImageAdapter gridImageAdapter) {
        this.mGridImageAdapter = gridImageAdapter;
        this.updateImages();
    }

    public void updateNetPhotos(List<String> photos) {
        if (photos == null) {
            return;
        }
        this.preImages.clear();
        for (String url : photos) {
            SquareImage squareImage = new SquareImage(null, url, null, SquareImage.PhotoType.NETWORK);
            squareImage.setId(this.createIndex());
            this.preImages.add(squareImage);
        }
        this.updateImages();
    }

    public void setNetworkPhotosWithKey(List<String> urls) {
        if (urls == null) {
            return;
        }
        this.preImages.clear();
        for (String url : urls) {
            String[] headWithKey = url.split("/");
            this.preImages.add(new SquareImage(null, url, headWithKey[headWithKey.length - 1], SquareImage.PhotoType.NETWORK));
        }
        this.updateImages();
    }

    public void setNetworkPhotosWithKey(List<String> urls, List<String> keys) {
        if (urls == null || keys == null || urls.size() != keys.size()) {
            return;
        }
        for (int i = 0; i < urls.size(); ++i) {
        }
    }

    public void updateLocalPhotos(List<String> photos) {
        if (photos == null) {
            return;
        }
        this.preImages.clear();
        for (String url : photos) {
            SquareImage squareImage = new SquareImage(url, null, null, SquareImage.PhotoType.LOCAL);
            squareImage.setId(this.createIndex());
            this.preImages.add(squareImage);
        }
        this.updateImages();
    }

    public void updateImage(List<SquareImage> photos) {
        if (photos == null) {
            return;
        }
        this.preImages.clear();
        for (SquareImage squareImage : photos) {
            squareImage.setId(this.createIndex());
            this.preImages.add(squareImage);
        }
        this.updateImages();
    }

    public void showAddButton(boolean showAddButton) {
        this.mShowAddButton = showAddButton;
        this.updateImages();
    }

    @Override
    public void photoClick(View v, SquareImage squareImage, int position) {
        if (squareImage == null) {
            this.doUpLoadPhotoClick();
        } else if (this.clickListener != null) {
            this.clickListener.onImageClick(v, squareImage);
        } else {
            this.updateImagesPosition();
            NavigatorImage.startImageSwitcherActivity(this.getContext(), this.getSquarePhotos(), position, this.mShowAddButton, this.mPlaceholderDrawable, this.getId(), this.mDragDismiss);
        }
    }

    private List<SquareImage> getSquarePhotos() {
        return this.preImages;
    }

    private void doUpLoadPhotoClick() {
        NavigatorImage.startCustomAlbumActivity(this.mAlbum, this.getCanSelectMaxNum(), this.getId());
    }

    private int getCanSelectMaxNum() {
        if (this.maxImageNum == -1) {
            return 0;
        }
        return this.maxImageNum - this.preImages.size();
    }

    public void onParentResult(int requestCode, Intent data) {
        if (data == null || data.getIntExtra("extra_image_group_id", 0) != this.getId()) {
            return;
        }
        List images = (List)((Object)data.getSerializableExtra("extra_photos_url"));
        ArrayList positions = data.getIntegerArrayListExtra("image_position");
        if (requestCode == 2004 && null != positions) {
            this.doPhotosDelete(positions);
        } else if (requestCode == 2005 && null != images) {
            this.doSelectPhotos(images);
        }
    }

    public ArrayList<String> getImageKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (SquareImage squareImage : this.preImages) {
            if (TextUtils.isEmpty((CharSequence)squareImage.interNetUrl) && TextUtils.isEmpty((CharSequence)squareImage.localUrl)) continue;
            result.add(squareImage.urlKey);
        }
        return result;
    }

    public HashMap<String, String> getUploadKeyUrlMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (SquareImage squareImage : this.preImages) {
            if (!TextUtils.isEmpty((CharSequence)squareImage.interNetUrl) || TextUtils.isEmpty((CharSequence)squareImage.localUrl)) continue;
            map.put(squareImage.urlKey, squareImage.localUrl);
        }
        return map;
    }

    public String getImageKeyString() {
        ArrayList<String> keys = this.getImageKeys();
        if (keys.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String key : keys) {
            sb.append(key);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public ArrayList<String> getLocalUrls() {
        ArrayList<String> result = new ArrayList<String>();
        for (SquareImage squareImage : this.preImages) {
            if (!TextUtils.isEmpty((CharSequence)squareImage.interNetUrl) || TextUtils.isEmpty((CharSequence)squareImage.localUrl)) continue;
            result.add(squareImage.localUrl);
        }
        return result;
    }

    public ArrayList<String> getInternetUrls() {
        ArrayList<String> result = new ArrayList<String>();
        for (SquareImage squareImage : this.preImages) {
            if (TextUtils.isEmpty((CharSequence)squareImage.interNetUrl)) continue;
            result.add(squareImage.interNetUrl);
        }
        return result;
    }

    private void doPhotosDelete(ArrayList<Integer> positions) {
        if (positions == null) {
            return;
        }
        ArrayList<SquareImage> deleteImages = new ArrayList<SquareImage>();
        for (int position : positions) {
            deleteImages.add(this.preImages.get(position));
        }
        for (SquareImage squareImage : deleteImages) {
            if (!this.preImages.contains(squareImage)) continue;
            this.preImages.remove(squareImage);
        }
        this.updateImages();
    }

    private void doSelectPhotos(List<Image> images) {
        for (Image image : images) {
            SquareImage squareImage = new SquareImage(image.url, null, this.getPhotoKey(image.time), SquareImage.PhotoType.LOCAL);
            this.preImages.add(squareImage);
        }
        this.updateImages();
    }

    @NonNull
    private String getPhotoKey(long time) {
        return "image_" + time;
    }

    private int createIndex() {
        long time = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("mmss");
        String date = sdf.format(new Date(time));
        int num1 = Integer.valueOf(date + Long.toString(time % 1000L));
        int i = num1 * 10 + this.preImages.size();
        return i;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        ImageGroupSavedState imageSaveState = new ImageGroupSavedState(parcelable);
        imageSaveState.setSquarePhotos(this.getSquarePhotos());
        return imageSaveState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof ImageGroupSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        ImageGroupSavedState ss = (ImageGroupSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.imageGroupSavedState = ss;
        this.restoreView();
    }

    private void restoreView() {
        if (this.imageGroupSavedState != null) {
            this.preImages.clear();
            this.preImages.addAll(this.getSquarePhotos());
            this.updateImages();
            this.imageGroupSavedState = null;
        }
    }

    public void setOnImageClickListener(OnImageClickListener listener) {
        this.clickListener = listener;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.isEnabled() || !this.isClickable()) {
            return false;
        }
        if (this.pointToPosition((int)ev.getX(), (int)ev.getY()) == -1 && ev.getAction() == 0) {
            return false;
        }
        return super.dispatchTouchEvent(ev);
    }
}

